/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableCollection;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class DefaultStoreFileManager
implements StoreFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStoreFileManager.class);
    private final CellComparator cellComparator;
    private final CompactionConfiguration comConf;
    private final int blockingFileCount;
    private final Comparator<HStoreFile> storeFileComparator;
    private volatile ImmutableList<HStoreFile> storefiles = ImmutableList.of();
    private volatile ImmutableList<HStoreFile> compactedfiles = ImmutableList.of();

    public DefaultStoreFileManager(CellComparator cellComparator, Comparator<HStoreFile> storeFileComparator, Configuration conf, CompactionConfiguration comConf) {
        this.cellComparator = cellComparator;
        this.storeFileComparator = storeFileComparator;
        this.comConf = comConf;
        this.blockingFileCount = conf.getInt("hbase.hstore.blockingStoreFiles", 16);
    }

    @Override
    public void loadFiles(List<HStoreFile> storeFiles) {
        this.storefiles = ImmutableList.sortedCopyOf(this.storeFileComparator, storeFiles);
    }

    @Override
    public final Collection<HStoreFile> getStorefiles() {
        return this.storefiles;
    }

    @Override
    public Collection<HStoreFile> getCompactedfiles() {
        return this.compactedfiles;
    }

    @Override
    public void insertNewFiles(Collection<HStoreFile> sfs) throws IOException {
        this.storefiles = ImmutableList.sortedCopyOf(this.storeFileComparator, Iterables.concat(this.storefiles, sfs));
    }

    @Override
    public ImmutableCollection<HStoreFile> clearFiles() {
        ImmutableList<HStoreFile> result = this.storefiles;
        this.storefiles = ImmutableList.of();
        return result;
    }

    @Override
    public Collection<HStoreFile> clearCompactedFiles() {
        ImmutableList<HStoreFile> result = this.compactedfiles;
        this.compactedfiles = ImmutableList.of();
        return result;
    }

    @Override
    public final int getStorefileCount() {
        return this.storefiles.size();
    }

    @Override
    public final int getCompactedFilesCount() {
        return this.compactedfiles.size();
    }

    @Override
    public void addCompactionResults(Collection<HStoreFile> newCompactedfiles, Collection<HStoreFile> results) {
        this.storefiles = ImmutableList.sortedCopyOf(this.storeFileComparator, Iterables.concat(Iterables.filter(this.storefiles, sf -> !newCompactedfiles.contains(sf)), results));
        newCompactedfiles.forEach(HStoreFile::markCompactedAway);
        this.compactedfiles = ImmutableList.sortedCopyOf(this.storeFileComparator, Iterables.concat(this.compactedfiles, newCompactedfiles));
    }

    @Override
    public void removeCompactedFiles(Collection<HStoreFile> removedCompactedfiles) throws IOException {
        this.compactedfiles = this.compactedfiles.stream().filter(sf -> !removedCompactedfiles.contains(sf)).sorted(this.storeFileComparator).collect(ImmutableList.toImmutableList());
    }

    @Override
    public final Iterator<HStoreFile> getCandidateFilesForRowKeyBefore(KeyValue targetKey) {
        return this.storefiles.reverse().iterator();
    }

    @Override
    public Iterator<HStoreFile> updateCandidateFilesForRowKeyBefore(Iterator<HStoreFile> candidateFiles, KeyValue targetKey, Cell candidate) {
        return candidateFiles;
    }

    @Override
    public final Optional<byte[]> getSplitPoint() throws IOException {
        return StoreUtils.getSplitPoint(this.storefiles, this.cellComparator);
    }

    @Override
    public final Collection<HStoreFile> getFilesForScan(byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow) {
        return this.getStorefiles();
    }

    @Override
    public int getStoreCompactionPriority() {
        int priority = this.blockingFileCount - this.storefiles.size();
        return priority == 1 ? priority + 1 : priority;
    }

    @Override
    public Collection<HStoreFile> getUnneededFiles(long maxTs, List<HStoreFile> filesCompacting) {
        ImmutableList<HStoreFile> files = this.storefiles;
        return files.stream().limit(Math.max(0, files.size() - 1)).filter(sf -> {
            long fileTs = sf.getReader().getMaxTimestamp();
            if (fileTs < maxTs && !filesCompacting.contains(sf)) {
                LOG.info("Found an expired store file {} whose maxTimestamp is {}, which is below {}", new Object[]{sf.getPath(), fileTs, maxTs});
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    @Override
    public double getCompactionPressure() {
        int minFilesToCompact;
        int storefileCount = this.getStorefileCount();
        if (storefileCount <= (minFilesToCompact = this.comConf.getMinFilesToCompact())) {
            return 0.0;
        }
        return (double)(storefileCount - minFilesToCompact) / (double)(this.blockingFileCount - minFilesToCompact);
    }

    @Override
    public Comparator<HStoreFile> getStoreFileComparator() {
        return this.storeFileComparator;
    }
}

