/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class CompressionTest {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionTest.class);
    private static final Boolean[] compressionTestResults = new Boolean[Compression.Algorithm.values().length];
    protected static Path path;

    public static boolean testCompression(String codec) {
        Compression.Algorithm a;
        codec = codec.toLowerCase(Locale.ROOT);
        try {
            a = Compression.getCompressionAlgorithmByName(codec);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Codec type: " + codec + " is not known");
            return false;
        }
        try {
            CompressionTest.testCompression(a);
            return true;
        }
        catch (IOException ignored) {
            LOG.warn("Can't instantiate codec: " + codec, (Throwable)ignored);
            return false;
        }
    }

    public static void testCompression(Compression.Algorithm algo) throws IOException {
        if (compressionTestResults[algo.ordinal()] != null) {
            if (compressionTestResults[algo.ordinal()].booleanValue()) {
                return;
            }
            throw new DoNotRetryIOException("Compression algorithm '" + algo.getName() + "' previously failed test.");
        }
        try {
            Compressor c = algo.getCompressor();
            algo.returnCompressor(c);
            CompressionTest.compressionTestResults[algo.ordinal()] = true;
        }
        catch (Throwable t) {
            CompressionTest.compressionTestResults[algo.ordinal()] = false;
            throw new DoNotRetryIOException(t);
        }
    }

    public static void usage() {
        System.err.println("Usage: CompressionTest <path> " + StringUtils.join((Object[])Compression.Algorithm.values(), (String)"|").toLowerCase(Locale.ROOT) + "\nFor example:\n  hbase " + CompressionTest.class + " file:///tmp/testfile gz\n");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSmokeTest(FileSystem fs, Path path, String codec) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        HFileContext context = new HFileContextBuilder().withCompression(HFileWriterImpl.compressionByName(codec)).build();
        HFile.Writer writer = HFile.getWriterFactoryNoCache(conf).withPath(fs, path).withFileContext(context).create();
        byte[] rowKey = Bytes.toBytes("compressiontestkey");
        Cell c = CellUtil.createCell(rowKey, Bytes.toBytes("compressiontestval"));
        writer.append(c);
        writer.appendFileInfo(Bytes.toBytes("compressioninfokey"), Bytes.toBytes("compressioninfoval"));
        writer.close();
        Cell cc = null;
        try (HFile.Reader reader = HFile.createReader(fs, path, CacheConfig.DISABLED, true, conf);){
            HFileScanner scanner = reader.getScanner(false, true);
            scanner.seekTo();
            cc = scanner.getCell();
            if (CellComparator.getInstance().compareRows(c, cc) != 0) {
                throw new Exception("Read back incorrect result: " + c.toString() + " vs " + cc.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Configuration conf;
        Path path;
        FileSystem fs;
        if (args.length != 2) {
            CompressionTest.usage();
            System.exit(1);
        }
        if ((fs = (path = new Path(args[0])).getFileSystem(conf = new Configuration())).exists(path)) {
            System.err.println("The specified path exists, aborting!");
            System.exit(1);
        }
        try {
            CompressionTest.doSmokeTest(fs, path, args[1]);
        }
        finally {
            fs.delete(path, false);
        }
        System.out.println("SUCCESS");
    }

    static {
        for (int i = 0; i < compressionTestResults.length; ++i) {
            CompressionTest.compressionTestResults[i] = null;
        }
        path = new Path(".hfile-comp-test");
    }
}

