/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import io.hops.hudi.org.apache.avro.AvroMissingFieldException;
import io.hops.hudi.org.apache.avro.AvroRuntimeException;
import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.data.RecordBuilder;
import io.hops.hudi.org.apache.avro.generic.GenericData;
import io.hops.hudi.org.apache.avro.io.DatumReader;
import io.hops.hudi.org.apache.avro.io.DatumWriter;
import io.hops.hudi.org.apache.avro.io.Encoder;
import io.hops.hudi.org.apache.avro.io.ResolvingDecoder;
import io.hops.hudi.org.apache.avro.message.BinaryMessageDecoder;
import io.hops.hudi.org.apache.avro.message.BinaryMessageEncoder;
import io.hops.hudi.org.apache.avro.message.SchemaStore;
import io.hops.hudi.org.apache.avro.specific.AvroGenerated;
import io.hops.hudi.org.apache.avro.specific.SpecificData;
import io.hops.hudi.org.apache.avro.specific.SpecificRecord;
import io.hops.hudi.org.apache.avro.specific.SpecificRecordBase;
import io.hops.hudi.org.apache.avro.specific.SpecificRecordBuilderBase;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionStrategy;

@AvroGenerated
public class HoodieCompactionPlan
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -996104195261885896L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieCompactionPlan\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"operations\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"HoodieCompactionOperation\",\"fields\":[{\"name\":\"baseInstantTime\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"deltaFilePaths\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"dataFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"partitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"metrics\",\"type\":[\"null\",{\"type\":\"map\",\"values\":\"double\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"bootstrapFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null}]}}],\"default\":null},{\"name\":\"extraMetadata\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"strategy\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieCompactionStrategy\",\"fields\":[{\"name\":\"compactorClassName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The class name that is provided here should extend CompactionExecutionStrategy abstract class, idea is that the plan generator will also provide the execution strategy to use.\",\"default\":null},{\"name\":\"strategyParams\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"}],\"doc\":\"These parameters play a key role in determining which action type it is i.e. compaction or logcompaction and it will also include configs that determine how compaction needs to be executed.\",\"default\":null},{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1}]}],\"default\":null},{\"name\":\"preserveHoodieMetadata\",\"type\":[\"boolean\",\"null\"],\"default\":false},{\"name\":\"missingSchedulePartitions\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieCompactionPlan> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieCompactionPlan> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private List<HoodieCompactionOperation> operations;
    private Map<String, String> extraMetadata;
    private Integer version;
    private HoodieCompactionStrategy strategy;
    private Boolean preserveHoodieMetadata;
    private List<String> missingSchedulePartitions;
    private static final DatumWriter<HoodieCompactionPlan> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieCompactionPlan> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieCompactionPlan> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieCompactionPlan> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieCompactionPlan> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<HoodieCompactionPlan>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static HoodieCompactionPlan fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieCompactionPlan)DECODER.decode(b);
    }

    public HoodieCompactionPlan() {
    }

    public HoodieCompactionPlan(List<HoodieCompactionOperation> operations, Map<String, String> extraMetadata, Integer version, HoodieCompactionStrategy strategy, Boolean preserveHoodieMetadata, List<String> missingSchedulePartitions) {
        this.operations = operations;
        this.extraMetadata = extraMetadata;
        this.version = version;
        this.strategy = strategy;
        this.preserveHoodieMetadata = preserveHoodieMetadata;
        this.missingSchedulePartitions = missingSchedulePartitions;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.operations;
            }
            case 1: {
                return this.extraMetadata;
            }
            case 2: {
                return this.version;
            }
            case 3: {
                return this.strategy;
            }
            case 4: {
                return this.preserveHoodieMetadata;
            }
            case 5: {
                return this.missingSchedulePartitions;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.operations = (List)value$;
                break;
            }
            case 1: {
                this.extraMetadata = (Map)value$;
                break;
            }
            case 2: {
                this.version = (Integer)value$;
                break;
            }
            case 3: {
                this.strategy = (HoodieCompactionStrategy)value$;
                break;
            }
            case 4: {
                this.preserveHoodieMetadata = (Boolean)value$;
                break;
            }
            case 5: {
                this.missingSchedulePartitions = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public List<HoodieCompactionOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<HoodieCompactionOperation> value) {
        this.operations = value;
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    public void setExtraMetadata(Map<String, String> value) {
        this.extraMetadata = value;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer value) {
        this.version = value;
    }

    public HoodieCompactionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(HoodieCompactionStrategy value) {
        this.strategy = value;
    }

    public Boolean getPreserveHoodieMetadata() {
        return this.preserveHoodieMetadata;
    }

    public void setPreserveHoodieMetadata(Boolean value) {
        this.preserveHoodieMetadata = value;
    }

    public List<String> getMissingSchedulePartitions() {
        return this.missingSchedulePartitions;
    }

    public void setMissingSchedulePartitions(List<String> value) {
        this.missingSchedulePartitions = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieCompactionPlan other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        if (this.operations == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.operations.size();
            out.writeArrayStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (HoodieCompactionOperation hoodieCompactionOperation : this.operations) {
                ++actualSize0;
                out.startItem();
                hoodieCompactionOperation.customEncode(out);
            }
            out.writeArrayEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
        if (this.extraMetadata == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size1 = this.extraMetadata.size();
            out.writeMapStart();
            out.setItemCount(size1);
            long actualSize1 = 0L;
            for (Map.Entry entry : this.extraMetadata.entrySet()) {
                ++actualSize1;
                out.startItem();
                out.writeString((String)entry.getKey());
                String v1 = (String)entry.getValue();
                out.writeString(v1);
            }
            out.writeMapEnd();
            if (actualSize1 != size1) {
                throw new ConcurrentModificationException("Map-size written was " + size1 + ", but element count was " + actualSize1 + ".");
            }
        }
        if (this.version == null) {
            out.writeIndex(1);
            out.writeNull();
        } else {
            out.writeIndex(0);
            out.writeInt(this.version);
        }
        if (this.strategy == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            this.strategy.customEncode(out);
        }
        if (this.preserveHoodieMetadata == null) {
            out.writeIndex(1);
            out.writeNull();
        } else {
            out.writeIndex(0);
            out.writeBoolean(this.preserveHoodieMetadata);
        }
        if (this.missingSchedulePartitions == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size2 = this.missingSchedulePartitions.size();
            out.writeArrayStart();
            out.setItemCount(size2);
            long actualSize2 = 0L;
            for (String string : this.missingSchedulePartitions) {
                ++actualSize2;
                out.startItem();
                out.writeString(string);
            }
            out.writeArrayEnd();
            if (actualSize2 != size2) {
                throw new ConcurrentModificationException("Array-size written was " + size2 + ", but element count was " + actualSize2 + ".");
            }
        }
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 1) {
                in.readNull();
                this.operations = null;
            } else {
                GenericData.Array ga0;
                long size0 = in.readArrayStart();
                List<HoodieCompactionOperation> a0 = this.operations;
                if (a0 == null) {
                    this.operations = a0 = new GenericData.Array<HoodieCompactionOperation>((int)size0, SCHEMA$.getField("operations").schema().getTypes().get(1));
                } else {
                    a0.clear();
                }
                GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                while (0L < size0) {
                    while (size0 != 0L) {
                        HoodieCompactionOperation e0;
                        HoodieCompactionOperation hoodieCompactionOperation = e0 = ga0 != null ? (HoodieCompactionOperation)ga0.peek() : null;
                        if (e0 == null) {
                            e0 = new HoodieCompactionOperation();
                        }
                        e0.customDecode(in);
                        a0.add(e0);
                        --size0;
                    }
                    size0 = in.arrayNext();
                }
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.extraMetadata = null;
            } else {
                long size1 = in.readMapStart();
                Map<String, String> m1 = this.extraMetadata;
                if (m1 == null) {
                    this.extraMetadata = m1 = new HashMap<String, String>((int)size1);
                } else {
                    m1.clear();
                }
                while (0L < size1) {
                    while (size1 != 0L) {
                        String k1 = null;
                        k1 = in.readString();
                        String v1 = null;
                        v1 = in.readString();
                        m1.put(k1, v1);
                        --size1;
                    }
                    size1 = in.mapNext();
                }
            }
            if (in.readIndex() != 0) {
                in.readNull();
                this.version = null;
            } else {
                this.version = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.strategy = null;
            } else {
                if (this.strategy == null) {
                    this.strategy = new HoodieCompactionStrategy();
                }
                this.strategy.customDecode(in);
            }
            if (in.readIndex() != 0) {
                in.readNull();
                this.preserveHoodieMetadata = null;
            } else {
                this.preserveHoodieMetadata = in.readBoolean();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.missingSchedulePartitions = null;
            } else {
                GenericData.Array ga2;
                long size2 = in.readArrayStart();
                List<String> a2 = this.missingSchedulePartitions;
                if (a2 == null) {
                    this.missingSchedulePartitions = a2 = new GenericData.Array<String>((int)size2, SCHEMA$.getField("missingSchedulePartitions").schema().getTypes().get(1));
                } else {
                    a2.clear();
                }
                GenericData.Array array = ga2 = a2 instanceof GenericData.Array ? (GenericData.Array)a2 : null;
                while (0L < size2) {
                    while (size2 != 0L) {
                        String e2 = ga2 != null ? (String)ga2.peek() : null;
                        e2 = in.readString();
                        a2.add(e2);
                        --size2;
                    }
                    size2 = in.arrayNext();
                }
            }
        } else {
            block14: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        GenericData.Array ga0;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.operations = null;
                            continue block14;
                        }
                        long size0 = in.readArrayStart();
                        List<HoodieCompactionOperation> a0 = this.operations;
                        if (a0 == null) {
                            this.operations = a0 = new GenericData.Array<HoodieCompactionOperation>((int)size0, SCHEMA$.getField("operations").schema().getTypes().get(1));
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                HoodieCompactionOperation e0;
                                HoodieCompactionOperation hoodieCompactionOperation = e0 = ga0 != null ? (HoodieCompactionOperation)ga0.peek() : null;
                                if (e0 == null) {
                                    e0 = new HoodieCompactionOperation();
                                }
                                e0.customDecode(in);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block14;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.extraMetadata = null;
                            continue block14;
                        }
                        long size1 = in.readMapStart();
                        Map<String, String> m1 = this.extraMetadata;
                        if (m1 == null) {
                            this.extraMetadata = m1 = new HashMap<String, String>((int)size1);
                        } else {
                            m1.clear();
                        }
                        while (0L < size1) {
                            while (size1 != 0L) {
                                String k1 = null;
                                k1 = in.readString();
                                String v1 = null;
                                v1 = in.readString();
                                m1.put(k1, v1);
                                --size1;
                            }
                            size1 = in.mapNext();
                        }
                        continue block14;
                    }
                    case 2: {
                        if (in.readIndex() != 0) {
                            in.readNull();
                            this.version = null;
                            continue block14;
                        }
                        this.version = in.readInt();
                        continue block14;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.strategy = null;
                            continue block14;
                        }
                        if (this.strategy == null) {
                            this.strategy = new HoodieCompactionStrategy();
                        }
                        this.strategy.customDecode(in);
                        continue block14;
                    }
                    case 4: {
                        if (in.readIndex() != 0) {
                            in.readNull();
                            this.preserveHoodieMetadata = null;
                            continue block14;
                        }
                        this.preserveHoodieMetadata = in.readBoolean();
                        continue block14;
                    }
                    case 5: {
                        GenericData.Array ga2;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.missingSchedulePartitions = null;
                            continue block14;
                        }
                        long size2 = in.readArrayStart();
                        List<String> a2 = this.missingSchedulePartitions;
                        if (a2 == null) {
                            this.missingSchedulePartitions = a2 = new GenericData.Array<String>((int)size2, SCHEMA$.getField("missingSchedulePartitions").schema().getTypes().get(1));
                        } else {
                            a2.clear();
                        }
                        GenericData.Array array = ga2 = a2 instanceof GenericData.Array ? (GenericData.Array)a2 : null;
                        while (0L < size2) {
                            while (size2 != 0L) {
                                String e2 = ga2 != null ? (String)ga2.peek() : null;
                                e2 = in.readString();
                                a2.add(e2);
                                --size2;
                            }
                            size2 = in.arrayNext();
                        }
                        continue block14;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieCompactionPlan>
    implements RecordBuilder<HoodieCompactionPlan> {
        private List<HoodieCompactionOperation> operations;
        private Map<String, String> extraMetadata;
        private Integer version;
        private HoodieCompactionStrategy strategy;
        private HoodieCompactionStrategy.Builder strategyBuilder;
        private Boolean preserveHoodieMetadata;
        private List<String> missingSchedulePartitions;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.operations)) {
                this.operations = this.data().deepCopy(this.fields()[0].schema(), other.operations);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.extraMetadata)) {
                this.extraMetadata = this.data().deepCopy(this.fields()[1].schema(), other.extraMetadata);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.version)) {
                this.version = this.data().deepCopy(this.fields()[2].schema(), other.version);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.strategy)) {
                this.strategy = this.data().deepCopy(this.fields()[3].schema(), other.strategy);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (other.hasStrategyBuilder()) {
                this.strategyBuilder = HoodieCompactionStrategy.newBuilder(other.getStrategyBuilder());
            }
            if (Builder.isValidValue(this.fields()[4], other.preserveHoodieMetadata)) {
                this.preserveHoodieMetadata = this.data().deepCopy(this.fields()[4].schema(), other.preserveHoodieMetadata);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue(this.fields()[5], other.missingSchedulePartitions)) {
                this.missingSchedulePartitions = this.data().deepCopy(this.fields()[5].schema(), other.missingSchedulePartitions);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(HoodieCompactionPlan other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.operations)) {
                this.operations = this.data().deepCopy(this.fields()[0].schema(), other.operations);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.extraMetadata)) {
                this.extraMetadata = this.data().deepCopy(this.fields()[1].schema(), other.extraMetadata);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.version)) {
                this.version = this.data().deepCopy(this.fields()[2].schema(), other.version);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.strategy)) {
                this.strategy = this.data().deepCopy(this.fields()[3].schema(), other.strategy);
                this.fieldSetFlags()[3] = true;
            }
            this.strategyBuilder = null;
            if (Builder.isValidValue(this.fields()[4], other.preserveHoodieMetadata)) {
                this.preserveHoodieMetadata = this.data().deepCopy(this.fields()[4].schema(), other.preserveHoodieMetadata);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue(this.fields()[5], other.missingSchedulePartitions)) {
                this.missingSchedulePartitions = this.data().deepCopy(this.fields()[5].schema(), other.missingSchedulePartitions);
                this.fieldSetFlags()[5] = true;
            }
        }

        public List<HoodieCompactionOperation> getOperations() {
            return this.operations;
        }

        public Builder setOperations(List<HoodieCompactionOperation> value) {
            this.validate(this.fields()[0], value);
            this.operations = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasOperations() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearOperations() {
            this.operations = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Map<String, String> getExtraMetadata() {
            return this.extraMetadata;
        }

        public Builder setExtraMetadata(Map<String, String> value) {
            this.validate(this.fields()[1], value);
            this.extraMetadata = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasExtraMetadata() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearExtraMetadata() {
            this.extraMetadata = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(Integer value) {
            this.validate(this.fields()[2], value);
            this.version = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public HoodieCompactionStrategy getStrategy() {
            return this.strategy;
        }

        public Builder setStrategy(HoodieCompactionStrategy value) {
            this.validate(this.fields()[3], value);
            this.strategyBuilder = null;
            this.strategy = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasStrategy() {
            return this.fieldSetFlags()[3];
        }

        public HoodieCompactionStrategy.Builder getStrategyBuilder() {
            if (this.strategyBuilder == null) {
                if (this.hasStrategy()) {
                    this.setStrategyBuilder(HoodieCompactionStrategy.newBuilder(this.strategy));
                } else {
                    this.setStrategyBuilder(HoodieCompactionStrategy.newBuilder());
                }
            }
            return this.strategyBuilder;
        }

        public Builder setStrategyBuilder(HoodieCompactionStrategy.Builder value) {
            this.clearStrategy();
            this.strategyBuilder = value;
            return this;
        }

        public boolean hasStrategyBuilder() {
            return this.strategyBuilder != null;
        }

        public Builder clearStrategy() {
            this.strategy = null;
            this.strategyBuilder = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Boolean getPreserveHoodieMetadata() {
            return this.preserveHoodieMetadata;
        }

        public Builder setPreserveHoodieMetadata(Boolean value) {
            this.validate(this.fields()[4], value);
            this.preserveHoodieMetadata = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasPreserveHoodieMetadata() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearPreserveHoodieMetadata() {
            this.preserveHoodieMetadata = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public List<String> getMissingSchedulePartitions() {
            return this.missingSchedulePartitions;
        }

        public Builder setMissingSchedulePartitions(List<String> value) {
            this.validate(this.fields()[5], value);
            this.missingSchedulePartitions = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasMissingSchedulePartitions() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearMissingSchedulePartitions() {
            this.missingSchedulePartitions = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        @Override
        public HoodieCompactionPlan build() {
            try {
                HoodieCompactionPlan record = new HoodieCompactionPlan();
                record.operations = this.fieldSetFlags()[0] ? this.operations : (List)this.defaultValue(this.fields()[0]);
                record.extraMetadata = this.fieldSetFlags()[1] ? this.extraMetadata : (Map)this.defaultValue(this.fields()[1]);
                record.version = this.fieldSetFlags()[2] ? this.version : (Integer)this.defaultValue(this.fields()[2]);
                if (this.strategyBuilder != null) {
                    try {
                        record.strategy = this.strategyBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("strategy"));
                        throw e;
                    }
                } else {
                    record.strategy = this.fieldSetFlags()[3] ? this.strategy : (HoodieCompactionStrategy)this.defaultValue(this.fields()[3]);
                }
                record.preserveHoodieMetadata = this.fieldSetFlags()[4] ? this.preserveHoodieMetadata : (Boolean)this.defaultValue(this.fields()[4]);
                record.missingSchedulePartitions = this.fieldSetFlags()[5] ? this.missingSchedulePartitions : (List)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

