/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.common.data.HoodieAccumulator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFlatMapFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.StorageConfiguration;

public abstract class HoodieEngineContext {
    private final StorageConfiguration<?> storageConf;
    protected TaskContextSupplier taskContextSupplier;

    public HoodieEngineContext(StorageConfiguration<?> storageConf, TaskContextSupplier taskContextSupplier) {
        this.storageConf = storageConf;
        this.taskContextSupplier = taskContextSupplier;
    }

    public StorageConfiguration<?> getStorageConf() {
        return this.storageConf;
    }

    public TaskContextSupplier getTaskContextSupplier() {
        return this.taskContextSupplier;
    }

    public abstract HoodieAccumulator newAccumulator();

    public abstract <T> HoodieData<T> emptyHoodieData();

    public abstract <K, V> HoodiePairData<K, V> emptyHoodiePairData();

    public boolean supportsFileGroupReader() {
        return false;
    }

    public <T> HoodieData<T> parallelize(List<T> data) {
        if (data.isEmpty()) {
            return this.emptyHoodieData();
        }
        return this.parallelize(data, data.size());
    }

    public abstract <T> HoodieData<T> parallelize(List<T> var1, int var2);

    public abstract <I, O> List<O> map(List<I> var1, SerializableFunction<I, O> var2, int var3);

    public abstract <I, K, V> List<V> mapToPairAndReduceByKey(List<I> var1, SerializablePairFunction<I, K, V> var2, SerializableBiFunction<V, V, V> var3, int var4);

    public abstract <I, K, V> Stream<ImmutablePair<K, V>> mapPartitionsToPairAndReduceByKey(Stream<I> var1, SerializablePairFlatMapFunction<Iterator<I>, K, V> var2, SerializableBiFunction<V, V, V> var3, int var4);

    public abstract <I, K, V> List<V> reduceByKey(List<Pair<K, V>> var1, SerializableBiFunction<V, V, V> var2, int var3);

    public abstract <I, O> List<O> flatMap(List<I> var1, SerializableFunction<I, Stream<O>> var2, int var3);

    public abstract <I> void foreach(List<I> var1, SerializableConsumer<I> var2, int var3);

    public abstract <I, K, V> Map<K, V> mapToPair(List<I> var1, SerializablePairFunction<I, K, V> var2, Integer var3);

    public abstract void setProperty(EngineProperty var1, String var2);

    public abstract Option<String> getProperty(EngineProperty var1);

    public abstract void setJobStatus(String var1, String var2);

    public abstract void putCachedDataIds(HoodieData.HoodieDataCacheKey var1, int ... var2);

    public abstract List<Integer> getCachedDataIds(HoodieData.HoodieDataCacheKey var1);

    public abstract List<Integer> removeCachedDataIds(HoodieData.HoodieDataCacheKey var1);

    public abstract void cancelJob(String var1);

    public abstract void cancelAllJobs();

    public abstract <I, O> O aggregate(HoodieData<I> var1, O var2, Functions.Function2<O, I, O> var3, Functions.Function2<O, O, O> var4);
}

