/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import io.hops.hudi.org.apache.avro.Schema;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;

public class BufferedRecord<T>
implements Serializable {
    private final String recordKey;
    private final Comparable orderingValue;
    private T record;
    private final Integer schemaId;
    private final boolean isDelete;

    private BufferedRecord(String recordKey, Comparable orderingValue, T record, Integer schemaId, boolean isDelete) {
        this.recordKey = recordKey;
        this.orderingValue = orderingValue;
        this.record = record;
        this.schemaId = schemaId;
        this.isDelete = isDelete;
    }

    public static <T> BufferedRecord<T> forRecordWithContext(HoodieRecord<T> record, Schema schema, HoodieReaderContext<T> readerContext, Properties props) {
        boolean isDelete;
        HoodieKey hoodieKey = record.getKey();
        String recordKey = hoodieKey == null ? readerContext.getRecordKey(record.getData(), schema) : hoodieKey.getRecordKey();
        Integer schemaId = readerContext.encodeAvroSchema(schema);
        try {
            isDelete = record.isDelete(schema, props);
        }
        catch (IOException e) {
            throw new HoodieException("Failed to get isDelete from record.", e);
        }
        return new BufferedRecord<T>(recordKey, record.getOrderingValue(schema, props), record.getData(), schemaId, isDelete);
    }

    public static <T> BufferedRecord<T> forRecordWithContext(T record, Schema schema, HoodieReaderContext<T> readerContext, Option<String> orderingFieldName, boolean isDelete) {
        String recordKey = readerContext.getRecordKey(record, schema);
        Integer schemaId = readerContext.encodeAvroSchema(schema);
        Comparable orderingValue = readerContext.getOrderingValue(record, schema, orderingFieldName);
        return new BufferedRecord<T>(recordKey, orderingValue, record, schemaId, isDelete);
    }

    public static <T> BufferedRecord<T> forDeleteRecord(DeleteRecord deleteRecord, Comparable orderingValue) {
        return new BufferedRecord<Object>(deleteRecord.getRecordKey(), orderingValue, null, null, true);
    }

    public String getRecordKey() {
        return this.recordKey;
    }

    public Comparable getOrderingValue() {
        return this.orderingValue;
    }

    public T getRecord() {
        return this.record;
    }

    public Integer getSchemaId() {
        return this.schemaId;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public boolean isCommitTimeOrderingDelete() {
        return this.isDelete && this.getOrderingValue().equals(0);
    }

    public BufferedRecord<T> toBinary(HoodieReaderContext<T> readerContext) {
        if (this.record != null) {
            this.record = readerContext.seal(readerContext.toBinaryRow(readerContext.getSchemaFromBufferRecord(this), this.record));
        }
        return this;
    }
}

