/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.util.collection.ClosableIterator;

public abstract class CachingIterator<T>
implements ClosableIterator<T> {
    protected T nextRecord;

    protected abstract boolean doHasNext();

    @Override
    public final boolean hasNext() {
        return this.nextRecord != null || this.doHasNext();
    }

    @Override
    public final T next() {
        T record = this.nextRecord;
        this.nextRecord = null;
        return record;
    }

    public static <U> CachingIterator<U> wrap(final ClosableIterator<U> iterator) {
        return new CachingIterator<U>(){

            @Override
            protected boolean doHasNext() {
                if (iterator.hasNext()) {
                    this.nextRecord = iterator.next();
                    return true;
                }
                return false;
            }

            @Override
            public void close() {
                iterator.close();
            }
        };
    }

    public static <U> CachingIterator<U> wrap(final ClosableIterator<U> iterator, final HoodieReaderContext<U> readerContext) {
        return new CachingIterator<U>(){

            @Override
            protected boolean doHasNext() {
                if (iterator.hasNext()) {
                    this.nextRecord = readerContext.seal(iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public void close() {
                iterator.close();
            }
        };
    }
}

