/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.convert;

import io.hops.hudi.org.apache.avro.JsonProperties;
import io.hops.hudi.org.apache.avro.LogicalType;
import io.hops.hudi.org.apache.avro.LogicalTypes;
import io.hops.hudi.org.apache.avro.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.exception.HoodieNullSchemaTypeException;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;

public class AvroInternalSchemaConverter {
    private static final String AVRO_NAME_DELIMITER = ".";

    public static Schema convert(InternalSchema internalSchema, String name) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromInternalSchema(internalSchema, name);
    }

    public static InternalSchema pruneAvroSchemaToInternalSchema(Schema schema, InternalSchema originSchema) {
        List<String> pruneNames = AvroInternalSchemaConverter.collectColNamesFromSchema(schema);
        return InternalSchemaUtils.pruneInternalSchema(originSchema, pruneNames);
    }

    @VisibleForTesting
    static List<String> collectColNamesFromSchema(Schema schema) {
        ArrayList<String> result = new ArrayList<String>();
        LinkedList<String> visited = new LinkedList<String>();
        AvroInternalSchemaConverter.collectColNamesFromAvroSchema(schema, visited, result);
        return result;
    }

    private static void collectColNamesFromAvroSchema(Schema schema, Deque<String> visited, List<String> resultSet) {
        switch (schema.getType()) {
            case RECORD: {
                List<Schema.Field> fields = schema.getFields();
                for (Schema.Field f : fields) {
                    visited.push(f.name());
                    AvroInternalSchemaConverter.collectColNamesFromAvroSchema(f.schema(), visited, resultSet);
                    visited.pop();
                    AvroInternalSchemaConverter.addFullNameIfLeafNode(f.schema(), f.name(), visited, resultSet);
                }
                return;
            }
            case UNION: {
                AvroInternalSchemaConverter.collectColNamesFromAvroSchema(AvroSchemaUtils.resolveNullableSchema(schema), visited, resultSet);
                return;
            }
            case ARRAY: {
                visited.push("element");
                AvroInternalSchemaConverter.collectColNamesFromAvroSchema(schema.getElementType(), visited, resultSet);
                visited.pop();
                AvroInternalSchemaConverter.addFullNameIfLeafNode(schema.getElementType(), "element", visited, resultSet);
                return;
            }
            case MAP: {
                AvroInternalSchemaConverter.addFullNameIfLeafNode(Schema.Type.STRING, "key", visited, resultSet);
                visited.push("value");
                AvroInternalSchemaConverter.collectColNamesFromAvroSchema(schema.getValueType(), visited, resultSet);
                visited.pop();
                AvroInternalSchemaConverter.addFullNameIfLeafNode(schema.getValueType(), "value", visited, resultSet);
                return;
            }
        }
    }

    private static void addFullNameIfLeafNode(Schema schema, String name, Deque<String> visited, List<String> resultSet) {
        AvroInternalSchemaConverter.addFullNameIfLeafNode(AvroSchemaUtils.resolveNullableSchema(schema).getType(), name, visited, resultSet);
    }

    private static void addFullNameIfLeafNode(Schema.Type type, String name, Deque<String> visited, List<String> resultSet) {
        switch (type) {
            case RECORD: 
            case ARRAY: 
            case MAP: {
                return;
            }
        }
        resultSet.add(InternalSchemaUtils.createFullName(name, visited));
    }

    public static Schema fixNullOrdering(Schema schema) {
        if (schema == null) {
            return Schema.create(Schema.Type.NULL);
        }
        if (schema.getType() == Schema.Type.NULL) {
            return schema;
        }
        return AvroInternalSchemaConverter.convert(AvroInternalSchemaConverter.convert(schema), schema.getFullName());
    }

    public static Schema convert(Types.RecordType type, String name) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromType(type, name);
    }

    public static Schema convert(Type type, String name) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromType(type, name);
    }

    public static Type convertToField(Schema schema) {
        return AvroInternalSchemaConverter.buildTypeFromAvroSchema(schema, Collections.emptyMap());
    }

    private static Type convertToField(Schema schema, Map<String, Integer> existingFieldNameToPositionMapping) {
        return AvroInternalSchemaConverter.buildTypeFromAvroSchema(schema, existingFieldNameToPositionMapping);
    }

    public static InternalSchema convert(Schema schema, Map<String, Integer> existingFieldNameToPositionMapping) {
        return new InternalSchema((Types.RecordType)AvroInternalSchemaConverter.convertToField(schema, existingFieldNameToPositionMapping));
    }

    public static InternalSchema convert(Schema schema) {
        return new InternalSchema((Types.RecordType)AvroInternalSchemaConverter.convertToField(schema));
    }

    public static boolean isOptional(Schema schema) {
        if (schema.getType() == Schema.Type.UNION && schema.getTypes().size() == 2) {
            return schema.getTypes().get(0).getType() == Schema.Type.NULL || schema.getTypes().get(1).getType() == Schema.Type.NULL;
        }
        return false;
    }

    public static Schema nullableSchema(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            if (!AvroInternalSchemaConverter.isOptional(schema)) {
                throw new HoodieSchemaException(String.format("Union schemas are not supported: %s", schema));
            }
            return schema;
        }
        return Schema.createUnion(Schema.create(Schema.Type.NULL), schema);
    }

    public static Type buildTypeFromAvroSchema(Schema schema, Map<String, Integer> existingNameToPositions) {
        LinkedList<String> visited = new LinkedList<String>();
        AtomicInteger nextId = new AtomicInteger(0);
        return AvroInternalSchemaConverter.visitAvroSchemaToBuildType(schema, visited, "", nextId, existingNameToPositions);
    }

    private static void checkNullType(Type fieldType, String fieldName, Deque<String> visited) {
        if (fieldType == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Field '");
            Iterator<String> visitedIterator = visited.descendingIterator();
            while (visitedIterator.hasNext()) {
                sb.append(visitedIterator.next());
                sb.append(AVRO_NAME_DELIMITER);
            }
            sb.append(fieldName);
            sb.append("' has type null");
            throw new HoodieNullSchemaTypeException(sb.toString());
        }
        if (fieldType.typeId() == Type.TypeID.ARRAY) {
            visited.push(fieldName);
            AvroInternalSchemaConverter.checkNullType(((Types.ArrayType)fieldType).elementType(), "element", visited);
            visited.pop();
        } else if (fieldType.typeId() == Type.TypeID.MAP) {
            visited.push(fieldName);
            AvroInternalSchemaConverter.checkNullType(((Types.MapType)fieldType).valueType(), "value", visited);
            visited.pop();
        }
    }

    private static Type visitAvroSchemaToBuildType(Schema schema, Deque<String> visited, String currentFieldPath, AtomicInteger nextId, Map<String, Integer> existingNameToPosition) {
        switch (schema.getType()) {
            case RECORD: {
                String name = schema.getFullName();
                if (visited.contains(name)) {
                    throw new HoodieSchemaException(String.format("cannot convert recursive avro record %s", name));
                }
                visited.push(name);
                List<Schema.Field> fields = existingNameToPosition.isEmpty() ? schema.getFields() : schema.getFields().stream().sorted(Comparator.comparing(field -> existingNameToPosition.getOrDefault(currentFieldPath + field.name(), Integer.MAX_VALUE))).collect(Collectors.toList());
                ArrayList fieldTypes = new ArrayList(fields.size());
                int nextAssignId = nextId.get();
                nextId.set(nextAssignId + fields.size());
                fields.forEach(field -> {
                    Type fieldType = AvroInternalSchemaConverter.visitAvroSchemaToBuildType(field.schema(), visited, currentFieldPath + field.name() + AVRO_NAME_DELIMITER, nextId, existingNameToPosition);
                    AvroInternalSchemaConverter.checkNullType(fieldType, field.name(), visited);
                    fieldTypes.add(fieldType);
                });
                visited.pop();
                ArrayList<Types.Field> internalFields = new ArrayList<Types.Field>(fields.size());
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.Field field2 = fields.get(i);
                    Type fieldType = (Type)fieldTypes.get(i);
                    internalFields.add(Types.Field.get(nextAssignId, AvroInternalSchemaConverter.isOptional(field2.schema()), field2.name(), fieldType, field2.doc()));
                    ++nextAssignId;
                }
                return Types.RecordType.get(internalFields, schema.getFullName());
            }
            case UNION: {
                ArrayList fTypes = new ArrayList(2);
                schema.getTypes().forEach(t -> fTypes.add(AvroInternalSchemaConverter.visitAvroSchemaToBuildType(t, visited, currentFieldPath, nextId, existingNameToPosition)));
                return fTypes.get(0) == null ? (Type)fTypes.get(1) : (Type)fTypes.get(0);
            }
            case ARRAY: {
                String elementPath = currentFieldPath + "element" + AVRO_NAME_DELIMITER;
                Schema elementSchema = schema.getElementType();
                int elementId = nextId.get();
                nextId.set(elementId + 1);
                Type elementType = AvroInternalSchemaConverter.visitAvroSchemaToBuildType(elementSchema, visited, elementPath, nextId, existingNameToPosition);
                return Types.ArrayType.get(elementId, AvroInternalSchemaConverter.isOptional(schema.getElementType()), elementType);
            }
            case MAP: {
                int keyId = nextId.get();
                int valueId = keyId + 1;
                nextId.set(valueId + 1);
                String valuePath = currentFieldPath + "value" + AVRO_NAME_DELIMITER;
                Type valueType = AvroInternalSchemaConverter.visitAvroSchemaToBuildType(schema.getValueType(), visited, valuePath, nextId, existingNameToPosition);
                return Types.MapType.get(keyId, valueId, Types.StringType.get(), valueType, AvroInternalSchemaConverter.isOptional(schema.getValueType()));
            }
        }
        return AvroInternalSchemaConverter.visitAvroPrimitiveToBuildInternalType(schema);
    }

    private static Type visitAvroPrimitiveToBuildInternalType(Schema primitive) {
        LogicalType logical = primitive.getLogicalType();
        if (logical != null) {
            String name = logical.getName();
            if (logical instanceof LogicalTypes.Decimal) {
                return Types.DecimalType.get(((LogicalTypes.Decimal)logical).getPrecision(), ((LogicalTypes.Decimal)logical).getScale());
            }
            if (logical instanceof LogicalTypes.Date) {
                return Types.DateType.get();
            }
            if (logical instanceof LogicalTypes.TimeMillis || logical instanceof LogicalTypes.TimeMicros) {
                return Types.TimeType.get();
            }
            if (logical instanceof LogicalTypes.TimestampMillis || logical instanceof LogicalTypes.TimestampMicros) {
                return Types.TimestampType.get();
            }
            if (LogicalTypes.uuid().getName().equals(name)) {
                return Types.UUIDType.get();
            }
        }
        switch (primitive.getType()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case INT: {
                return Types.IntType.get();
            }
            case LONG: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case STRING: 
            case ENUM: {
                return Types.StringType.get();
            }
            case FIXED: {
                return Types.FixedType.getFixed(primitive.getFixedSize());
            }
            case BYTES: {
                return Types.BinaryType.get();
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + primitive);
    }

    public static Schema buildAvroSchemaFromType(Type type, String recordName) {
        HashMap<Type, Schema> cache = new HashMap<Type, Schema>();
        return AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(type, cache, recordName);
    }

    public static Schema buildAvroSchemaFromInternalSchema(InternalSchema schema, String recordName) {
        HashMap<Type, Schema> cache = new HashMap<Type, Schema>();
        return AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(schema.getRecord(), cache, recordName);
    }

    private static Schema visitInternalSchemaToBuildAvroSchema(Type type, Map<Type, Schema> cache, String recordName) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                ArrayList<Schema> schemas = new ArrayList<Schema>();
                record.fields().forEach(f -> {
                    String nestedRecordName = recordName + AVRO_NAME_DELIMITER + f.name();
                    Schema tempSchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(f.type(), cache, nestedRecordName);
                    Schema result = f.isOptional() ? AvroInternalSchemaConverter.nullableSchema(tempSchema) : tempSchema;
                    schemas.add(result);
                });
                Schema recordSchema = cache.get(record);
                if (recordSchema != null) {
                    return recordSchema;
                }
                recordSchema = AvroInternalSchemaConverter.visitInternalRecordToBuildAvroRecord(record, schemas, recordName);
                cache.put(record, recordSchema);
                return recordSchema;
            }
            case ARRAY: {
                Types.ArrayType array = (Types.ArrayType)type;
                Schema elementSchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(array.elementType(), cache, recordName);
                Schema arraySchema = cache.get(array);
                if (arraySchema != null) {
                    return arraySchema;
                }
                arraySchema = AvroInternalSchemaConverter.visitInternalArrayToBuildAvroArray(array, elementSchema);
                cache.put(array, arraySchema);
                return arraySchema;
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                Schema keySchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(map.keyType(), cache, recordName);
                Schema valueSchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(map.valueType(), cache, recordName);
                Schema mapSchema = cache.get(map);
                if (mapSchema != null) {
                    return mapSchema;
                }
                mapSchema = AvroInternalSchemaConverter.visitInternalMapToBuildAvroMap(map, keySchema, valueSchema);
                cache.put(map, mapSchema);
                return mapSchema;
            }
        }
        Schema primitiveSchema = AvroInternalSchemaConverter.visitInternalPrimitiveToBuildAvroPrimitiveType((Type.PrimitiveType)type, recordName);
        cache.put(type, primitiveSchema);
        return primitiveSchema;
    }

    private static Schema visitInternalRecordToBuildAvroRecord(Types.RecordType recordType, List<Schema> fieldSchemas, String recordNameFallback) {
        List<Types.Field> fields = recordType.fields();
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (int i = 0; i < fields.size(); ++i) {
            Types.Field f = fields.get(i);
            Schema.Field field = new Schema.Field(f.name(), fieldSchemas.get(i), f.doc(), f.isOptional() ? JsonProperties.NULL_VALUE : null);
            avroFields.add(field);
        }
        String recordName = Option.ofNullable(recordType.name()).orElse(recordNameFallback);
        return Schema.createRecord(recordName, null, null, false, avroFields);
    }

    private static Schema visitInternalArrayToBuildAvroArray(Types.ArrayType array, Schema elementSchema) {
        Schema result = array.isElementOptional() ? Schema.createArray(AvroInternalSchemaConverter.nullableSchema(elementSchema)) : Schema.createArray(elementSchema);
        return result;
    }

    private static Schema visitInternalMapToBuildAvroMap(Types.MapType map, Schema keySchema, Schema valueSchema) {
        if (keySchema.getType() != Schema.Type.STRING) {
            throw new HoodieSchemaException("only support StringType key for avro MapType");
        }
        Schema mapSchema = Schema.createMap(map.isValueOptional() ? AvroInternalSchemaConverter.nullableSchema(valueSchema) : valueSchema);
        return mapSchema;
    }

    private static Schema visitInternalPrimitiveToBuildAvroPrimitiveType(Type.PrimitiveType primitive, String recordName) {
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return Schema.create(Schema.Type.BOOLEAN);
            }
            case INT: {
                return Schema.create(Schema.Type.INT);
            }
            case LONG: {
                return Schema.create(Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create(Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create(Schema.Type.DOUBLE);
            }
            case DATE: {
                return LogicalTypes.date().addToSchema(Schema.create(Schema.Type.INT));
            }
            case TIME: {
                return LogicalTypes.timeMicros().addToSchema(Schema.create(Schema.Type.LONG));
            }
            case TIMESTAMP: {
                return LogicalTypes.timestampMicros().addToSchema(Schema.create(Schema.Type.LONG));
            }
            case STRING: {
                return Schema.create(Schema.Type.STRING);
            }
            case BINARY: {
                return Schema.create(Schema.Type.BYTES);
            }
            case UUID: {
                String name = recordName + AVRO_NAME_DELIMITER + "fixed";
                Schema fixedSchema = Schema.createFixed(name, null, null, 16);
                return LogicalTypes.uuid().addToSchema(fixedSchema);
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)primitive;
                String name = recordName + AVRO_NAME_DELIMITER + "fixed";
                return Schema.createFixed(name, null, null, fixed.getFixedSize());
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                String name = recordName + AVRO_NAME_DELIMITER + "fixed";
                Schema fixedSchema = Schema.createFixed(name, null, null, AvroInternalSchemaConverter.computeMinBytesForPrecision(decimal.precision()));
                return LogicalTypes.decimal(decimal.precision(), decimal.scale()).addToSchema(fixedSchema);
            }
        }
        throw new UnsupportedOperationException("Unsupported type ID: " + (Object)((Object)primitive.typeId()));
    }

    private static int computeMinBytesForPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }
}

