/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.BlockIndexEntry;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockReader;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileCursor;
import org.apache.hudi.io.hfile.HFileDataBlock;
import org.apache.hudi.io.hfile.HFileFileInfoBlock;
import org.apache.hudi.io.hfile.HFileInfo;
import org.apache.hudi.io.hfile.HFileLeafIndexBlock;
import org.apache.hudi.io.hfile.HFileMetaBlock;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.HFileRootIndexBlock;
import org.apache.hudi.io.hfile.HFileTrailer;
import org.apache.hudi.io.hfile.HFileUtils;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.logging.log4j.util.Strings;

public class HFileReaderImpl
implements HFileReader {
    private final SeekableDataInputStream stream;
    private final long fileSize;
    private final HFileCursor cursor;
    private boolean isMetadataInitialized = false;
    private HFileTrailer trailer;
    private HFileContext context;
    private TreeMap<Key, BlockIndexEntry> dataBlockIndexEntryMap;
    private TreeMap<Key, BlockIndexEntry> metaBlockIndexEntryMap;
    private HFileInfo fileInfo;
    private Option<BlockIndexEntry> currentDataBlockEntry;
    private Option<HFileDataBlock> currentDataBlock;

    public HFileReaderImpl(SeekableDataInputStream stream, long fileSize) {
        this.stream = stream;
        this.fileSize = fileSize;
        this.cursor = new HFileCursor();
        this.currentDataBlockEntry = Option.empty();
        this.currentDataBlock = Option.empty();
    }

    @Override
    public synchronized void initializeMetadata() throws IOException {
        if (this.isMetadataInitialized) {
            return;
        }
        this.trailer = HFileReaderImpl.readTrailer(this.stream, this.fileSize);
        this.context = HFileContext.builder().compressionCodec(this.trailer.getCompressionCodec()).build();
        HFileBlockReader blockReader = new HFileBlockReader(this.context, this.stream, this.trailer.getLoadOnOpenDataOffset(), this.fileSize - (long)HFileTrailer.getTrailerSize());
        this.dataBlockIndexEntryMap = this.readDataBlockIndex(blockReader, this.trailer.getDataIndexCount(), this.trailer.getNumDataIndexLevels());
        HFileRootIndexBlock metaIndexBlock = (HFileRootIndexBlock)blockReader.nextBlock(HFileBlockType.ROOT_INDEX);
        this.metaBlockIndexEntryMap = metaIndexBlock.readBlockIndex(this.trailer.getMetaIndexCount(), true);
        HFileFileInfoBlock fileInfoBlock = (HFileFileInfoBlock)blockReader.nextBlock(HFileBlockType.FILE_INFO);
        this.fileInfo = fileInfoBlock.readFileInfo();
        this.isMetadataInitialized = true;
    }

    @Override
    public Option<byte[]> getMetaInfo(UTF8StringKey key) throws IOException {
        this.initializeMetadata();
        return Option.ofNullable(this.fileInfo.get(key));
    }

    @Override
    public Option<ByteBuffer> getMetaBlock(String metaBlockName) throws IOException {
        this.initializeMetadata();
        BlockIndexEntry blockIndexEntry = this.metaBlockIndexEntryMap.get(new UTF8StringKey(metaBlockName));
        if (blockIndexEntry == null) {
            return Option.empty();
        }
        HFileBlockReader blockReader = new HFileBlockReader(this.context, this.stream, blockIndexEntry.getOffset(), blockIndexEntry.getOffset() + (long)blockIndexEntry.getSize());
        HFileMetaBlock block = (HFileMetaBlock)blockReader.nextBlock(HFileBlockType.META);
        return Option.of(block.readContent());
    }

    @Override
    public long getNumKeyValueEntries() {
        try {
            this.initializeMetadata();
            return this.trailer.getNumKeyValueEntries();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read HFile", e);
        }
    }

    @Override
    public int seekTo(Key key) throws IOException {
        Option<KeyValue> currentKeyValue = this.getKeyValue();
        if (!currentKeyValue.isPresent()) {
            return 2;
        }
        int compareCurrent = key.compareTo(currentKeyValue.get().getKey());
        if (compareCurrent > 0) {
            int comparedLastKey;
            int comparedNextBlockFirstKey;
            if (this.currentDataBlockEntry.get().getNextBlockFirstKey().isPresent() && (comparedNextBlockFirstKey = key.compareTo(this.currentDataBlockEntry.get().getNextBlockFirstKey().get())) >= 0) {
                Map.Entry<Key, BlockIndexEntry> floorEntry = this.dataBlockIndexEntryMap.floorEntry(key);
                if (floorEntry == null) {
                    throw new IllegalStateException("Unexpected state of the HFile reader when looking up the key: " + key + " data block index: " + Strings.join(this.dataBlockIndexEntryMap.values(), (char)','));
                }
                this.currentDataBlockEntry = Option.of(floorEntry.getValue());
                this.currentDataBlock = Option.of(this.instantiateHFileDataBlock(this.currentDataBlockEntry.get()));
                this.cursor.setOffset((int)this.currentDataBlockEntry.get().getOffset() + 33);
            }
            if (!this.currentDataBlockEntry.get().getNextBlockFirstKey().isPresent() && this.fileInfo.getLastKey().isPresent() && (comparedLastKey = key.compareTo(this.fileInfo.getLastKey().get())) > 0) {
                this.currentDataBlockEntry = Option.empty();
                this.currentDataBlock = Option.empty();
                this.cursor.setEof();
                return 2;
            }
            if (!this.currentDataBlock.isPresent()) {
                this.currentDataBlock = Option.of(this.instantiateHFileDataBlock(this.currentDataBlockEntry.get()));
            }
            return this.currentDataBlock.get().seekTo(this.cursor, key, (int)this.currentDataBlockEntry.get().getOffset());
        }
        if (compareCurrent == 0) {
            return 0;
        }
        if (this.isAtFirstKeyOfBlock(this.currentDataBlockEntry.get()) && key.compareTo(this.currentDataBlockEntry.get().getFirstKey()) >= 0) {
            return -2;
        }
        if (!this.dataBlockIndexEntryMap.isEmpty() && this.isAtFirstKeyOfBlock(this.dataBlockIndexEntryMap.firstEntry().getValue())) {
            return -1;
        }
        throw new IllegalStateException("The current lookup key is less than the current position of the cursor, i.e., backward seekTo, which is not supported and should be avoided. key=" + key + " cursor=" + this.cursor);
    }

    @Override
    public boolean seekTo() throws IOException {
        this.initializeMetadata();
        if (this.trailer.getNumKeyValueEntries() == 0L) {
            this.cursor.setEof();
            return false;
        }
        this.cursor.setOffset(this.dataBlockIndexEntryMap.firstKey().getOffset() + 33);
        this.cursor.unsetEof();
        this.currentDataBlockEntry = Option.of(this.dataBlockIndexEntryMap.firstEntry().getValue());
        this.currentDataBlock = Option.empty();
        return true;
    }

    @Override
    public boolean next() throws IOException {
        if (this.cursor.isValid()) {
            if (!this.currentDataBlock.isPresent()) {
                this.currentDataBlock = Option.of(this.instantiateHFileDataBlock(this.currentDataBlockEntry.get()));
            }
            if (this.currentDataBlock.get().next(this.cursor, (int)this.currentDataBlockEntry.get().getOffset())) {
                return true;
            }
            this.currentDataBlockEntry = this.getNextBlockIndexEntry(this.currentDataBlockEntry.get());
            this.currentDataBlock = Option.empty();
            if (!this.currentDataBlockEntry.isPresent()) {
                this.cursor.setEof();
                return false;
            }
            this.cursor.setOffset((int)this.currentDataBlockEntry.get().getOffset() + 33);
            return true;
        }
        return false;
    }

    @Override
    public Option<KeyValue> getKeyValue() throws IOException {
        if (this.cursor.isValid()) {
            Option<KeyValue> keyValue = this.cursor.getKeyValue();
            if (!keyValue.isPresent()) {
                if (!this.currentDataBlock.isPresent()) {
                    this.currentDataBlock = Option.of(this.instantiateHFileDataBlock(this.currentDataBlockEntry.get()));
                }
                keyValue = Option.of(this.currentDataBlock.get().readKeyValue(this.cursor.getOffset() - (int)this.currentDataBlockEntry.get().getOffset()));
                this.cursor.setKeyValue(keyValue.get());
            }
            return keyValue;
        }
        return Option.empty();
    }

    @Override
    public boolean isSeeked() {
        return this.cursor.isSeeked();
    }

    @Override
    public void close() throws IOException {
        this.currentDataBlockEntry = Option.empty();
        this.currentDataBlock = Option.empty();
        this.cursor.setEof();
        this.stream.close();
    }

    private static HFileTrailer readTrailer(SeekableDataInputStream stream, long fileSize) throws IOException {
        int bufferSize = HFileTrailer.getTrailerSize();
        long seekPos = fileSize - (long)bufferSize;
        if (seekPos < 0L) {
            seekPos = 0L;
            bufferSize = (int)fileSize;
        }
        stream.seek(seekPos);
        byte[] byteBuff = new byte[bufferSize];
        stream.readFully(byteBuff);
        int majorVersion = HFileUtils.readMajorVersion(byteBuff, bufferSize - 3);
        byte minorVersion = byteBuff[bufferSize - 4];
        HFileTrailer trailer = new HFileTrailer(majorVersion, minorVersion);
        trailer.deserialize(new DataInputStream(new ByteArrayInputStream(byteBuff)));
        return trailer;
    }

    private Option<BlockIndexEntry> getNextBlockIndexEntry(BlockIndexEntry entry) {
        Map.Entry<Key, BlockIndexEntry> keyBlockIndexEntryEntry = this.dataBlockIndexEntryMap.higherEntry(entry.getFirstKey());
        if (keyBlockIndexEntryEntry == null) {
            return Option.empty();
        }
        return Option.of(keyBlockIndexEntryEntry.getValue());
    }

    private HFileDataBlock instantiateHFileDataBlock(BlockIndexEntry blockToRead) throws IOException {
        HFileBlockReader blockReader = new HFileBlockReader(this.context, this.stream, blockToRead.getOffset(), blockToRead.getOffset() + (long)blockToRead.getSize());
        return (HFileDataBlock)blockReader.nextBlock(HFileBlockType.DATA);
    }

    private boolean isAtFirstKeyOfBlock(BlockIndexEntry indexEntry) {
        if (this.cursor.isValid()) {
            return (long)this.cursor.getOffset() == indexEntry.getOffset() + 33L;
        }
        return false;
    }

    private TreeMap<Key, BlockIndexEntry> readDataBlockIndex(HFileBlockReader rootBlockReader, int numEntries, int levels) throws IOException {
        ValidationUtils.checkArgument(levels > 0, "levels of data block index must be greater than 0");
        HFileRootIndexBlock rootDataIndexBlock = (HFileRootIndexBlock)rootBlockReader.nextBlock(HFileBlockType.ROOT_INDEX);
        if (levels == 1) {
            return rootDataIndexBlock.readBlockIndex(numEntries, false);
        }
        List<BlockIndexEntry> indexEntryList = rootDataIndexBlock.readBlockIndexEntry(numEntries, false);
        --levels;
        LinkedList<BlockIndexEntry> queue = new LinkedList<BlockIndexEntry>();
        while (levels >= 1) {
            queue.addAll(indexEntryList);
            indexEntryList.clear();
            while (!queue.isEmpty()) {
                BlockIndexEntry indexEntry = (BlockIndexEntry)queue.poll();
                HFileBlockReader blockReader = new HFileBlockReader(this.context, this.stream, indexEntry.getOffset(), indexEntry.getOffset() + (long)indexEntry.getSize());
                HFileBlockType blockType = levels > 1 ? HFileBlockType.INTERMEDIATE_INDEX : HFileBlockType.LEAF_INDEX;
                HFileBlock tempBlock = blockReader.nextBlock(blockType);
                indexEntryList.addAll(((HFileLeafIndexBlock)tempBlock).readBlockIndex());
            }
            --levels;
        }
        TreeMap<Key, BlockIndexEntry> blockIndexEntryMap = new TreeMap<Key, BlockIndexEntry>();
        for (int i = 0; i < indexEntryList.size(); ++i) {
            Key key = indexEntryList.get(i).getFirstKey();
            blockIndexEntryMap.put(key, new BlockIndexEntry(key, i < indexEntryList.size() - 1 ? Option.of(indexEntryList.get(i + 1).getFirstKey()) : Option.empty(), indexEntryList.get(i).getOffset(), indexEntryList.get(i).getSize()));
        }
        return blockIndexEntryMap;
    }
}

