/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.HoodieHiveRecord;
import org.apache.hudi.hadoop.HoodieHiveRecordMerger;

public class DefaultHiveRecordMerger
extends HoodieHiveRecordMerger {
    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        HoodieHiveRecord newHiveRecord;
        ValidationUtils.checkArgument((older.getRecordType() == HoodieRecord.HoodieRecordType.HIVE ? 1 : 0) != 0);
        ValidationUtils.checkArgument((newer.getRecordType() == HoodieRecord.HoodieRecordType.HIVE ? 1 : 0) != 0);
        if (newer instanceof HoodieHiveRecord ? (newHiveRecord = (HoodieHiveRecord)newer).isDeleted() : newer.getData() == null) {
            return Option.empty();
        }
        if (older instanceof HoodieHiveRecord) {
            HoodieHiveRecord oldHiveRecord = (HoodieHiveRecord)older;
            if (oldHiveRecord.isDeleted()) {
                return Option.of((Object)Pair.of((Object)newer, (Object)newSchema));
            }
        } else if (older.getData() == null) {
            return Option.empty();
        }
        if (older.getOrderingValue(oldSchema, (Properties)props).compareTo(newer.getOrderingValue(newSchema, (Properties)props)) > 0) {
            return Option.of((Object)Pair.of((Object)older, (Object)oldSchema));
        }
        return Option.of((Object)Pair.of((Object)newer, (Object)newSchema));
    }

    public String getMergingStrategy() {
        return "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    }
}

