/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.HadoopConfigUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieRealtimeRecordReaderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieRealtimeRecordReaderUtils.class);

    public static long getMaxCompactionMemoryInBytes(JobConf jobConf) {
        return (long)Math.ceil(Double.parseDouble((String)HadoopConfigUtils.getRawValueWithAltKeys((Configuration)jobConf, (ConfigProperty)HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION).orElse((Object)"0.75")) * (double)jobConf.getMemoryForMapTask() * 1024.0 * 1024.0);
    }

    public static String arrayWritableToString(ArrayWritable writable) {
        if (writable == null) {
            return "null";
        }
        Random random = new Random(2L);
        StringBuilder builder = new StringBuilder();
        Writable[] values = writable.get();
        builder.append("\"values_" + random.nextDouble() + "_" + values.length + "\": {");
        int i = 0;
        for (Writable w : values) {
            if (w instanceof ArrayWritable) {
                builder.append(HoodieRealtimeRecordReaderUtils.arrayWritableToString((ArrayWritable)w)).append(",");
            } else {
                builder.append("\"value" + i + "\":\"" + w + "\"").append(",");
                if (w == null) {
                    builder.append("\"type" + i + "\":\"unknown\"").append(",");
                } else {
                    builder.append("\"type" + i + "\":\"" + w.getClass().getSimpleName() + "\"").append(",");
                }
            }
            ++i;
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("}");
        return builder.toString();
    }

    public static Schema generateProjectionSchema(Schema writeSchema, Map<String, Schema.Field> schemaFieldsMap, List<String> fieldNames) {
        ArrayList<Schema.Field> projectedFields = new ArrayList<Schema.Field>();
        for (String fn : fieldNames) {
            Schema.Field field = schemaFieldsMap.get(fn.toLowerCase());
            if (field == null) {
                throw new HoodieException("Field " + fn + " not found in log schema. Query cannot proceed! Derived Schema Fields: " + new ArrayList<String>(schemaFieldsMap.keySet()));
            }
            projectedFields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal()));
        }
        Schema projectedSchema = Schema.createRecord((String)writeSchema.getName(), (String)writeSchema.getDoc(), (String)writeSchema.getNamespace(), (boolean)writeSchema.isError());
        projectedSchema.setFields(projectedFields);
        return projectedSchema;
    }

    public static Map<String, Schema.Field> getNameToFieldMap(Schema schema) {
        return schema.getFields().stream().map(r -> Pair.of((Object)r.name().toLowerCase(), (Object)r)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    public static Writable avroToArrayWritable(Object value, Schema schema) {
        return HoodieRealtimeRecordReaderUtils.avroToArrayWritable(value, schema, false);
    }

    public static Writable avroToArrayWritable(Object value, Schema schema, boolean supportTimestamp) {
        if (value == null) {
            return null;
        }
        switch (schema.getType()) {
            case STRING: {
                return new Text(value.toString());
            }
            case BYTES: {
                if (schema.getLogicalType() != null && schema.getLogicalType().getName().equals("decimal")) {
                    return HoodieRealtimeRecordReaderUtils.toHiveDecimalWritable(((ByteBuffer)value).array(), schema);
                }
                return new BytesWritable(((ByteBuffer)value).array());
            }
            case INT: {
                if (schema.getLogicalType() != null && schema.getLogicalType().getName().equals("date")) {
                    return HoodieHiveUtils.getDateWriteable((Integer)value);
                }
                return new IntWritable(Integer.parseInt(value.toString()));
            }
            case LONG: {
                LogicalType logicalType = schema.getLogicalType();
                if (supportTimestamp) {
                    if (LogicalTypes.timestampMillis().equals(logicalType)) {
                        return HoodieHiveUtils.getTimestampWriteable((Long)value, true);
                    }
                    if (LogicalTypes.timestampMicros().equals(logicalType)) {
                        return HoodieHiveUtils.getTimestampWriteable((Long)value, false);
                    }
                }
                return new LongWritable(Long.parseLong(value.toString()));
            }
            case FLOAT: {
                return new FloatWritable(Float.parseFloat(value.toString()));
            }
            case DOUBLE: {
                return new DoubleWritable(Double.parseDouble(value.toString()));
            }
            case BOOLEAN: {
                return new BooleanWritable(Boolean.parseBoolean(value.toString()));
            }
            case NULL: {
                return null;
            }
            case RECORD: {
                GenericRecord record = (GenericRecord)value;
                Writable[] recordValues = new Writable[schema.getFields().size()];
                int recordValueIndex = 0;
                for (Schema.Field field : schema.getFields()) {
                    Object fieldValue = null;
                    if (record.getSchema().getField(field.name()) != null) {
                        fieldValue = record.get(field.name());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Field:" + field.name() + "not found in Schema:" + schema);
                    }
                    recordValues[recordValueIndex++] = HoodieRealtimeRecordReaderUtils.avroToArrayWritable(fieldValue, field.schema(), supportTimestamp);
                }
                return new ArrayWritable(Writable.class, recordValues);
            }
            case ENUM: {
                return new BytesWritable(value.toString().getBytes());
            }
            case ARRAY: {
                GenericArray arrayValue = (GenericArray)value;
                Writable[] arrayValues = new Writable[arrayValue.size()];
                int arrayValueIndex = 0;
                for (Object obj : arrayValue) {
                    arrayValues[arrayValueIndex++] = HoodieRealtimeRecordReaderUtils.avroToArrayWritable(obj, schema.getElementType(), supportTimestamp);
                }
                return new ArrayWritable(Writable.class, arrayValues);
            }
            case MAP: {
                Map mapValue = (Map)value;
                Writable[] mapValues = new Writable[mapValue.size()];
                int mapValueIndex = 0;
                Iterator iterator = mapValue.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry mapEntry = entry = iterator.next();
                    Writable[] nestedMapValues = new Writable[]{new Text(mapEntry.getKey().toString()), HoodieRealtimeRecordReaderUtils.avroToArrayWritable(mapEntry.getValue(), schema.getValueType(), supportTimestamp)};
                    mapValues[mapValueIndex++] = new ArrayWritable(Writable.class, nestedMapValues);
                }
                return new ArrayWritable(Writable.class, mapValues);
            }
            case UNION: {
                List types = schema.getTypes();
                if (types.size() != 2) {
                    throw new IllegalArgumentException("Only support union with 2 fields");
                }
                Schema s1 = (Schema)types.get(0);
                Schema s2 = (Schema)types.get(1);
                if (s1.getType() == Schema.Type.NULL) {
                    return HoodieRealtimeRecordReaderUtils.avroToArrayWritable(value, s2, supportTimestamp);
                }
                if (s2.getType() == Schema.Type.NULL) {
                    return HoodieRealtimeRecordReaderUtils.avroToArrayWritable(value, s1, supportTimestamp);
                }
                throw new IllegalArgumentException("Only support union with null");
            }
            case FIXED: {
                if (schema.getLogicalType() != null && schema.getLogicalType().getName().equals("decimal")) {
                    return HoodieRealtimeRecordReaderUtils.toHiveDecimalWritable(((GenericFixed)value).bytes(), schema);
                }
                return new BytesWritable(((GenericFixed)value).bytes());
            }
        }
        return null;
    }

    public static List<String> orderFields(String fieldNameCsv, String fieldOrderCsv, List<String> partitioningFields) {
        String[] fieldOrdersWithDups = fieldOrderCsv.isEmpty() ? new String[]{} : fieldOrderCsv.split(",");
        LinkedHashSet<String> fieldOrdersSet = new LinkedHashSet<String>(Arrays.asList(fieldOrdersWithDups));
        String[] fieldOrders = fieldOrdersSet.toArray(new String[0]);
        List<Object> fieldNames = fieldNameCsv.isEmpty() ? new ArrayList() : Arrays.stream(fieldNameCsv.split(",")).collect(Collectors.toList());
        LinkedHashSet fieldNamesSet = new LinkedHashSet(fieldNames);
        if (fieldNamesSet.size() != fieldOrders.length) {
            throw new HoodieException(String.format("Error ordering fields for storage read. #fieldNames: %d, #fieldPositions: %d", fieldNames.size(), fieldOrders.length));
        }
        TreeMap<Integer, String> orderedFieldMap = new TreeMap<Integer, String>();
        String[] fieldNamesArray = fieldNamesSet.toArray(new String[0]);
        for (int ox = 0; ox < fieldOrders.length; ++ox) {
            orderedFieldMap.put(Integer.parseInt(fieldOrders[ox]), fieldNamesArray[ox]);
        }
        return new ArrayList<String>(orderedFieldMap.values());
    }

    public static Schema addPartitionFields(Schema schema, List<String> partitioningFields) {
        Set firstLevelFieldNames = schema.getFields().stream().map(Schema.Field::name).map(String::toLowerCase).collect(Collectors.toSet());
        List<String> fieldsToAdd = partitioningFields.stream().map(String::toLowerCase).filter(x -> !firstLevelFieldNames.contains(x)).collect(Collectors.toList());
        return HoodieRealtimeRecordReaderUtils.appendNullSchemaFields(schema, fieldsToAdd);
    }

    public static HoodieFileReader getBaseFileReader(Path path, JobConf conf) throws IOException {
        StorageConfiguration storageConf = HadoopFSUtils.getStorageConf((Configuration)conf);
        HoodieConfig hoodieConfig = ConfigUtils.getReaderConfigs((StorageConfiguration)storageConf);
        return HoodieIOFactory.getIOFactory((HoodieStorage)new HoodieHadoopStorage(path, (Configuration)conf)).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(hoodieConfig, HadoopFSUtils.convertToStoragePath((Path)path));
    }

    private static Schema appendNullSchemaFields(Schema schema, List<String> newFieldNames) {
        ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
        for (String newField : newFieldNames) {
            newFields.add(new Schema.Field(newField, AvroSchemaUtils.createNullableSchema((Schema.Type)Schema.Type.STRING), "", (Object)JsonProperties.NULL_VALUE));
        }
        return AvroSchemaUtils.appendFieldsToSchema((Schema)schema, newFields);
    }

    private static HiveDecimalWritable toHiveDecimalWritable(byte[] bytes, Schema schema) {
        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)LogicalTypes.fromSchema((Schema)schema);
        HiveDecimalWritable writable = new HiveDecimalWritable(bytes, decimal.getScale());
        return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)writable, (DecimalTypeInfo)new DecimalTypeInfo(decimal.getPrecision(), decimal.getScale()));
    }
}

