/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.core;

import io.hops.hudi.org.apache.htrace.core.SpanId;
import io.hops.hudi.org.apache.htrace.core.TraceScope;
import io.hops.hudi.org.apache.htrace.core.Tracer;
import java.util.concurrent.Callable;

public class TraceCallable<V>
implements Callable<V> {
    private final Tracer tracer;
    private final Callable<V> impl;
    private final SpanId parentId;
    private final String description;

    public TraceCallable(Tracer tracer, SpanId parentId, Callable<V> impl, String description) {
        this.tracer = tracer;
        this.impl = impl;
        this.parentId = parentId;
        this.description = description;
    }

    @Override
    public V call() throws Exception {
        String description = this.description;
        if (description == null) {
            description = Thread.currentThread().getName();
        }
        try (TraceScope chunk = this.tracer.newScope(description, this.parentId);){
            V v = this.impl.call();
            return v;
        }
    }

    public Callable<V> getImpl() {
        return this.impl;
    }
}

