/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifier;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FileArchiverNotifierImpl
implements FileArchiverNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(FileArchiverNotifierImpl.class);
    private final Connection conn;
    private final Configuration conf;
    private final FileSystem fs;
    private final TableName tn;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private volatile long lastFullCompute = Long.MIN_VALUE;
    private List<String> currentSnapshots = Collections.emptyList();
    private static final Map<String, Object> NAMESPACE_LOCKS = new HashMap<String, Object>();

    public FileArchiverNotifierImpl(Connection conn, Configuration conf, FileSystem fs, TableName tn) {
        this.conn = conn;
        this.conf = conf;
        this.fs = fs;
        this.tn = tn;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    static synchronized Object getLockForNamespace(String namespace) {
        return NAMESPACE_LOCKS.computeIfAbsent(namespace, ns -> new Object());
    }

    long getLastFullCompute() {
        return this.lastFullCompute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addArchivedFiles(Set<Map.Entry<String, Long>> fileSizes) throws IOException {
        long start = System.nanoTime();
        this.readLock.lock();
        try {
            if (this.lastFullCompute != Long.MIN_VALUE && start - this.lastFullCompute < 0L) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("A full computation was performed after this request was received. Ignoring requested updates: " + fileSizes);
                }
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("currentSnapshots: " + this.currentSnapshots + " fileSize: " + fileSizes);
            }
            if (!this.currentSnapshots.isEmpty() && !fileSizes.isEmpty()) {
                this.groupArchivedFiledBySnapshotAndRecordSize(this.currentSnapshots, fileSizes);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    void groupArchivedFiledBySnapshotAndRecordSize(List<String> snapshots, Set<Map.Entry<String, Long>> fileSizes) throws IOException {
        HashMap<String, Long> filesToUpdate = new HashMap<String, Long>(fileSizes.size());
        for (Map.Entry<String, Long> entry : fileSizes) {
            filesToUpdate.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, Long> snapshotSizeChanges = new HashMap<String, Long>();
        for (String snapshot : snapshots) {
            this.bucketFilesToSnapshot(snapshot, filesToUpdate, snapshotSizeChanges);
            if (!filesToUpdate.isEmpty()) continue;
            break;
        }
        if (!snapshotSizeChanges.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Writing snapshot size changes for: " + snapshotSizeChanges);
            }
            this.persistSnapshotSizeChanges(snapshotSizeChanges);
        }
    }

    void bucketFilesToSnapshot(String snapshotName, Map<String, Long> filesToUpdate, Map<String, Long> snapshotSizeChanges) throws IOException {
        if (filesToUpdate.isEmpty()) {
            return;
        }
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, CommonFSUtils.getRootDir(this.conf));
        SnapshotProtos.SnapshotDescription sd = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
        SnapshotManifest manifest = SnapshotManifest.open(this.conf, this.fs, snapshotDir, sd);
        for (SnapshotProtos.SnapshotRegionManifest rm : manifest.getRegionManifests()) {
            for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles ff : rm.getFamilyFilesList()) {
                for (SnapshotProtos.SnapshotRegionManifest.StoreFile sf : ff.getStoreFilesList()) {
                    Long valueOrNull = filesToUpdate.remove(sf.getName());
                    if (valueOrNull != null) {
                        snapshotSizeChanges.merge(snapshotName, valueOrNull, Long::sum);
                    }
                    if (!filesToUpdate.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistSnapshotSizeChanges(Map<String, Long> snapshotSizeChanges) throws IOException {
        try (Table quotaTable = this.conn.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            ArrayList<Map.Entry<String, Long>> snapshotSizeEntries = new ArrayList<Map.Entry<String, Long>>(snapshotSizeChanges.entrySet());
            List<Get> snapshotSizeGets = snapshotSizeEntries.stream().map(e -> QuotaTableUtil.makeGetForSnapshotSize(this.tn, (String)e.getKey())).collect(Collectors.toList());
            Iterator iterator = snapshotSizeEntries.iterator();
            ArrayList<Put> updates = new ArrayList<Put>(snapshotSizeEntries.size());
            Object object = FileArchiverNotifierImpl.getLockForNamespace(this.tn.getNamespaceAsString());
            synchronized (object) {
                Result[] existingSnapshotSizes = quotaTable.get(snapshotSizeGets);
                long totalSizeChange = 0L;
                for (Result result : existingSnapshotSizes) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String snapshot = (String)entry.getKey();
                    Long size = (Long)entry.getValue();
                    totalSizeChange += size.longValue();
                    long previousSize = this.getSnapshotSizeFromResult(result);
                    updates.add(QuotaTableUtil.createPutForSnapshotSize(this.tn, snapshot, previousSize + size));
                }
                if (totalSizeChange != 0L) {
                    long previousSize = this.getPreviousNamespaceSnapshotSize(quotaTable, this.tn.getNamespaceAsString());
                    updates.add(QuotaTableUtil.createPutForNamespaceSnapshotSize(this.tn.getNamespaceAsString(), previousSize + totalSizeChange));
                }
                ArrayList<Object> failures = new ArrayList<Object>();
                Object[] results = new Object[updates.size()];
                quotaTable.batch(updates, results);
                for (Object result : results) {
                    if (result instanceof Result) continue;
                    failures.add(result);
                }
                if (!failures.isEmpty()) {
                    throw new QuotaSnapshotSizeSerializationException("Failed to write some snapshot size updates: " + failures);
                }
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    long getPreviousNamespaceSnapshotSize(Table quotaTable, String namespace) throws IOException {
        Result r = quotaTable.get(QuotaTableUtil.createGetNamespaceSnapshotSize(namespace));
        return this.getSnapshotSizeFromResult(r);
    }

    long getSnapshotSizeFromResult(Result r) throws InvalidProtocolBufferException {
        if (!r.isEmpty() && r.advance()) {
            return QuotaTableUtil.parseSnapshotSize(r.current());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeAndStoreSnapshotSizes(Collection<String> currentSnapshots) throws IOException {
        this.currentSnapshots = new ArrayList<String>(currentSnapshots);
        Collections.sort(this.currentSnapshots);
        List<SnapshotWithSize> snapshotSizes = this.computeSnapshotSizes(this.currentSnapshots);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed snapshot sizes for " + this.tn + " of " + snapshotSizes);
        }
        long totalSnapshotSize = snapshotSizes.stream().mapToLong(sws -> sws.getSize()).sum();
        this.writeLock.lock();
        try {
            try (Table quotaTable = this.conn.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
                this.persistSnapshotSizes(quotaTable, snapshotSizes);
            }
            this.lastFullCompute = System.nanoTime();
            long l = totalSnapshotSize;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("tableName=").append(this.tn).append(", currentSnapshots=");
        sb.append(this.currentSnapshots).append(", lastFullCompute=").append(this.lastFullCompute);
        return sb.append("]").toString();
    }

    List<SnapshotWithSize> computeSnapshotSizes(List<String> snapshots) throws IOException {
        Set<String> tableReferencedStoreFiles;
        ArrayList<SnapshotWithSize> snapshotSizes = new ArrayList<SnapshotWithSize>(snapshots.size());
        Path rootDir = CommonFSUtils.getRootDir(this.conf);
        try {
            tableReferencedStoreFiles = FSUtils.getTableStoreFilePathMap(this.fs, rootDir).keySet();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Paths for " + this.tn + ": " + tableReferencedStoreFiles);
        }
        HashSet<String> snapshotReferencedFiles = new HashSet<String>();
        for (String snapshotName : snapshots) {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir);
            SnapshotProtos.SnapshotDescription sd = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
            SnapshotManifest manifest = SnapshotManifest.open(this.conf, this.fs, snapshotDir, sd);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Files referenced by other snapshots: " + snapshotReferencedFiles);
            }
            Set<StoreFileReference> unreferencedStoreFileNames = this.getStoreFilesFromSnapshot(manifest, sfn -> !tableReferencedStoreFiles.contains(sfn) && !snapshotReferencedFiles.contains(sfn));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Snapshot " + snapshotName + " solely references the files: " + unreferencedStoreFileNames);
            }
            long size = this.getSizeOfStoreFiles(this.tn, unreferencedStoreFileNames);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Computed size of " + snapshotName + " to be " + size);
            }
            snapshotSizes.add(new SnapshotWithSize(snapshotName, size));
            for (StoreFileReference ref : unreferencedStoreFileNames) {
                for (String fileNames : ref.getFamilyToFilesMapping().values()) {
                    snapshotReferencedFiles.add(fileNames);
                }
            }
        }
        return snapshotSizes;
    }

    long getSizeOfStoreFiles(TableName tn, Set<StoreFileReference> storeFileNames) {
        return storeFileNames.stream().collect(Collectors.summingLong(sfr -> this.getSizeOfStoreFile(tn, (StoreFileReference)sfr)));
    }

    long getSizeOfStoreFile(TableName tn, StoreFileReference storeFileName) {
        String regionName = storeFileName.getRegionName();
        return storeFileName.getFamilyToFilesMapping().entries().stream().collect(Collectors.summingLong(e -> this.getSizeOfStoreFile(tn, regionName, (String)e.getKey(), (String)e.getValue())));
    }

    long getSizeOfStoreFile(TableName tn, String regionName, String family, String storeFile) {
        Path familyArchivePath;
        try {
            familyArchivePath = HFileArchiveUtil.getStoreArchivePath(this.conf, tn, regionName, family);
        }
        catch (IOException e) {
            LOG.warn("Could not compute path for the archive directory for the region", (Throwable)e);
            return 0L;
        }
        Path fileArchivePath = new Path(familyArchivePath, storeFile);
        try {
            if (this.fs.exists(fileArchivePath)) {
                FileStatus[] status = this.fs.listStatus(fileArchivePath);
                if (1 != status.length) {
                    LOG.warn("Expected " + fileArchivePath + " to be a file but was a directory, ignoring reference");
                    return 0L;
                }
                return status[0].getLen();
            }
        }
        catch (IOException e) {
            LOG.warn("Could not obtain the status of " + fileArchivePath, (Throwable)e);
            return 0L;
        }
        LOG.warn("Expected " + fileArchivePath + " to exist but does not, ignoring reference.");
        return 0L;
    }

    Set<StoreFileReference> getStoreFilesFromSnapshot(SnapshotManifest manifest, Predicate<String> filter) {
        HashSet<StoreFileReference> references = new HashSet<StoreFileReference>();
        for (SnapshotProtos.SnapshotRegionManifest rm : manifest.getRegionManifests()) {
            StoreFileReference regionReference = new StoreFileReference(ProtobufUtil.toRegionInfo(rm.getRegionInfo()).getEncodedName());
            for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles ff : rm.getFamilyFilesList()) {
                String familyName = ff.getFamilyName().toStringUtf8();
                for (SnapshotProtos.SnapshotRegionManifest.StoreFile sf : ff.getStoreFilesList()) {
                    String storeFileName = sf.getName();
                    if (!filter.test(storeFileName)) continue;
                    regionReference.addFamilyStoreFile(familyName, storeFileName);
                }
            }
            if (regionReference.getFamilyToFilesMapping().isEmpty()) continue;
            references.add(regionReference);
        }
        return references;
    }

    void persistSnapshotSizes(Table table, List<SnapshotWithSize> snapshotSizes) throws IOException {
        table.put(snapshotSizes.stream().map(sws -> QuotaTableUtil.createPutForSnapshotSize(this.tn, sws.getName(), sws.getSize())).collect(Collectors.toList()));
    }

    static class StoreFileReference {
        private final String regionName;
        private final Multimap<String, String> familyToFiles;

        StoreFileReference(String regionName) {
            this.regionName = Objects.requireNonNull(regionName);
            this.familyToFiles = HashMultimap.create();
        }

        String getRegionName() {
            return this.regionName;
        }

        Multimap<String, String> getFamilyToFilesMapping() {
            return this.familyToFiles;
        }

        void addFamilyStoreFile(String family, String storeFileName) {
            this.familyToFiles.put(family, storeFileName);
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.regionName).append(this.familyToFiles).toHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StoreFileReference)) {
                return false;
            }
            StoreFileReference other = (StoreFileReference)o;
            return this.regionName.equals(other.regionName) && this.familyToFiles.equals(other.familyToFiles);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            return sb.append("StoreFileReference[region=").append(this.regionName).append(", files=").append(this.familyToFiles).append("]").toString();
        }
    }

    static class SnapshotWithSize {
        private final String name;
        private final long size;

        SnapshotWithSize(String name, long size) {
            this.name = Objects.requireNonNull(name);
            this.size = size;
        }

        String getName() {
            return this.name;
        }

        long getSize() {
            return this.size;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.name).append(this.size).toHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SnapshotWithSize)) {
                return false;
            }
            SnapshotWithSize other = (SnapshotWithSize)o;
            return this.name.equals(other.name) && this.size == other.size;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            return sb.append("SnapshotWithSize:[").append(this.name).append(" ").append(StringUtils.byteDesc((long)this.size)).append("]").toString();
        }
    }

    @InterfaceAudience.Private
    public static class QuotaSnapshotSizeSerializationException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public QuotaSnapshotSizeSerializationException(String msg) {
            super(msg);
        }
    }
}

