/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.access.AuthManager;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZKPermissionWatcher
extends ZKListener
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ZKPermissionWatcher.class);
    static final String ACL_NODE = "acl";
    private final AuthManager authManager;
    private final String aclZNode;
    private final CountDownLatch initialized = new CountDownLatch(1);
    private final ExecutorService executor;
    private Future<?> childrenChangedFuture;

    public ZKPermissionWatcher(ZKWatcher watcher, AuthManager authManager, Configuration conf) {
        super(watcher);
        this.authManager = authManager;
        String aclZnodeParent = conf.get("zookeeper.znode.acl.parent", ACL_NODE);
        this.aclZNode = ZNodePaths.joinZNode(watcher.getZNodePaths().baseZNode, aclZnodeParent);
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("zk-permission-watcher-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
    }

    public void start() throws KeeperException {
        block7: {
            try {
                this.watcher.registerListener((ZKListener)this);
                if (!ZKUtil.watchAndCheckExists((ZKWatcher)this.watcher, (String)this.aclZNode)) break block7;
                try {
                    this.executor.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws KeeperException {
                            List existing = ZKUtil.getChildDataAndWatchForNewChildren((ZKWatcher)ZKPermissionWatcher.this.watcher, (String)ZKPermissionWatcher.this.aclZNode);
                            if (existing != null) {
                                ZKPermissionWatcher.this.refreshNodes(existing);
                            }
                            return null;
                        }
                    }).get();
                }
                catch (ExecutionException ex) {
                    if (ex.getCause() instanceof KeeperException) {
                        throw (KeeperException)ex.getCause();
                    }
                    throw new RuntimeException(ex.getCause());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                this.initialized.countDown();
            }
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    private void waitUntilStarted() {
        try {
            this.initialized.await();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for start", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void nodeCreated(String path) {
        this.waitUntilStarted();
        if (path.equals(this.aclZNode)) {
            this.asyncProcessNodeUpdate(new Runnable(){

                @Override
                public void run() {
                    try {
                        List nodes = ZKUtil.getChildDataAndWatchForNewChildren((ZKWatcher)ZKPermissionWatcher.this.watcher, (String)ZKPermissionWatcher.this.aclZNode);
                        ZKPermissionWatcher.this.refreshNodes(nodes);
                    }
                    catch (KeeperException ke) {
                        LOG.error("Error reading data from zookeeper", (Throwable)ke);
                        ZKPermissionWatcher.this.watcher.abort("ZooKeeper error obtaining acl node children", (Throwable)ke);
                    }
                }
            });
        }
    }

    public void nodeDeleted(final String path) {
        this.waitUntilStarted();
        if (this.aclZNode.equals(ZKUtil.getParent((String)path))) {
            this.asyncProcessNodeUpdate(new Runnable(){

                @Override
                public void run() {
                    String table = ZKUtil.getNodeName((String)path);
                    if (PermissionStorage.isNamespaceEntry(table)) {
                        ZKPermissionWatcher.this.authManager.removeNamespace(Bytes.toBytes(table));
                    } else {
                        ZKPermissionWatcher.this.authManager.removeTable(TableName.valueOf(table));
                    }
                }
            });
        }
    }

    public void nodeDataChanged(final String path) {
        this.waitUntilStarted();
        if (this.aclZNode.equals(ZKUtil.getParent((String)path))) {
            this.asyncProcessNodeUpdate(new Runnable(){

                @Override
                public void run() {
                    String entry = ZKUtil.getNodeName((String)path);
                    try {
                        byte[] data = ZKUtil.getDataAndWatch((ZKWatcher)ZKPermissionWatcher.this.watcher, (String)path);
                        ZKPermissionWatcher.this.refreshAuthManager(entry, data);
                    }
                    catch (KeeperException ke) {
                        LOG.error("Error reading data from zookeeper for node " + entry, (Throwable)ke);
                        ZKPermissionWatcher.this.watcher.abort("ZooKeeper error getting data for node " + entry, (Throwable)ke);
                    }
                    catch (IOException ioe) {
                        LOG.error("Error reading permissions writables", (Throwable)ioe);
                    }
                }
            });
        }
    }

    public void nodeChildrenChanged(String path) {
        this.waitUntilStarted();
        if (path.equals(this.aclZNode)) {
            boolean cancelled;
            if (!(this.childrenChangedFuture == null || this.childrenChangedFuture.isDone() || (cancelled = this.childrenChangedFuture.cancel(true)) || this.childrenChangedFuture.isDone())) {
                LOG.warn("Could not cancel processing node children changed event, please file a JIRA and attach logs if possible.");
            }
            this.childrenChangedFuture = this.asyncProcessNodeUpdate(() -> {
                try {
                    List nodeList = ZKUtil.getChildDataAndWatchForNewChildren((ZKWatcher)this.watcher, (String)this.aclZNode, (boolean)false);
                    this.refreshNodes(nodeList);
                }
                catch (KeeperException ke) {
                    String msg = "ZooKeeper error while reading node children data for path " + path;
                    LOG.error(msg, (Throwable)ke);
                    this.watcher.abort(msg, (Throwable)ke);
                }
            });
        }
    }

    private Future<?> asyncProcessNodeUpdate(Runnable runnable) {
        if (!this.executor.isShutdown()) {
            try {
                return this.executor.submit(runnable);
            }
            catch (RejectedExecutionException e) {
                if (this.executor.isShutdown()) {
                    LOG.warn("aclZNode changed after ZKPermissionWatcher was shutdown");
                }
                throw e;
            }
        }
        return null;
    }

    private void refreshNodes(List<ZKUtil.NodeAndData> nodes) {
        for (ZKUtil.NodeAndData n : nodes) {
            if (Thread.interrupted()) break;
            if (n.isEmpty()) continue;
            String path = n.getNode();
            String entry = ZKUtil.getNodeName((String)path);
            try {
                this.refreshAuthManager(entry, n.getData());
            }
            catch (IOException ioe) {
                LOG.error("Failed parsing permissions for table '" + entry + "' from zk", (Throwable)ioe);
            }
        }
    }

    private void refreshAuthManager(String entry, byte[] nodeData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating permissions cache from {} with data {}", (Object)entry, (Object)Bytes.toStringBinary(nodeData));
        }
        if (PermissionStorage.isNamespaceEntry(entry)) {
            this.authManager.refreshNamespaceCacheFromWritable(PermissionStorage.fromNamespaceEntry(entry), nodeData);
        } else {
            this.authManager.refreshTableCacheFromWritable(TableName.valueOf(entry), nodeData);
        }
    }

    public void writeToZookeeper(byte[] entry, byte[] permsData) {
        String entryName = Bytes.toString(entry);
        String zkNode = ZNodePaths.joinZNode(this.watcher.getZNodePaths().baseZNode, ACL_NODE);
        zkNode = ZNodePaths.joinZNode(zkNode, entryName);
        try {
            ZKUtil.createWithParents((ZKWatcher)this.watcher, (String)zkNode);
            ZKUtil.updateExistingNodeData((ZKWatcher)this.watcher, (String)zkNode, (byte[])permsData, (int)-1);
        }
        catch (KeeperException e) {
            LOG.error("Failed updating permissions for entry '" + entryName + "'", (Throwable)e);
            this.watcher.abort("Failed writing node " + zkNode + " to zookeeper", (Throwable)e);
        }
    }

    public void deleteTableACLNode(TableName tableName) {
        String zkNode = ZNodePaths.joinZNode(this.watcher.getZNodePaths().baseZNode, ACL_NODE);
        zkNode = ZNodePaths.joinZNode(zkNode, tableName.getNameAsString());
        try {
            ZKUtil.deleteNode((ZKWatcher)this.watcher, (String)zkNode);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn("No acl notify node of table '" + tableName + "'");
        }
        catch (KeeperException e) {
            LOG.error("Failed deleting acl node of table '" + tableName + "'", (Throwable)e);
            this.watcher.abort("Failed deleting node " + zkNode, (Throwable)e);
        }
    }

    public void deleteNamespaceACLNode(String namespace) {
        String zkNode = ZNodePaths.joinZNode(this.watcher.getZNodePaths().baseZNode, ACL_NODE);
        zkNode = ZNodePaths.joinZNode(zkNode, '@' + namespace);
        try {
            ZKUtil.deleteNode((ZKWatcher)this.watcher, (String)zkNode);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn("No acl notify node of namespace '" + namespace + "'");
        }
        catch (KeeperException e) {
            LOG.error("Failed deleting acl node of namespace '" + namespace + "'", (Throwable)e);
            this.watcher.abort("Failed deleting node " + zkNode, (Throwable)e);
        }
    }
}

