/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.hudi.common.util.StringUtils;

public class GenericAvroSerializer<D extends GenericContainer>
extends Serializer<D> {
    private final HashMap<Schema, DatumWriter<D>> writerCache = new HashMap();
    private final HashMap<Schema, DatumReader<D>> readerCache = new HashMap();
    private final HashMap<Schema, byte[]> encodeCache = new HashMap();
    private final HashMap<ByteBuffer, Schema> schemaCache = new HashMap();

    private byte[] getSchemaBytes(Schema schema) {
        if (this.encodeCache.containsKey(schema)) {
            return this.encodeCache.get(schema);
        }
        byte[] schemaBytes = StringUtils.getUTF8Bytes(schema.toString());
        this.encodeCache.put(schema, schemaBytes);
        return schemaBytes;
    }

    private Schema getSchema(byte[] schemaBytes) {
        ByteBuffer schemaByteBuffer = ByteBuffer.wrap(schemaBytes);
        if (this.schemaCache.containsKey(schemaByteBuffer)) {
            return this.schemaCache.get(schemaByteBuffer);
        }
        String schema = StringUtils.fromUTF8Bytes(schemaBytes);
        Schema parsedSchema = new Schema.Parser().parse(schema);
        this.schemaCache.put(schemaByteBuffer, parsedSchema);
        return parsedSchema;
    }

    private DatumWriter<D> getDatumWriter(Schema schema) {
        DatumWriter writer;
        if (this.writerCache.containsKey(schema)) {
            writer = this.writerCache.get(schema);
        } else {
            writer = new GenericDatumWriter(schema);
            this.writerCache.put(schema, writer);
        }
        return writer;
    }

    private DatumReader<D> getDatumReader(Schema schema) {
        DatumReader reader;
        if (this.readerCache.containsKey(schema)) {
            reader = this.readerCache.get(schema);
        } else {
            reader = new GenericDatumReader(schema);
            this.readerCache.put(schema, reader);
        }
        return reader;
    }

    private void serializeDatum(D datum, Output output) throws IOException {
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder(output, null);
        Schema schema = datum.getSchema();
        byte[] schemaBytes = this.getSchemaBytes(schema);
        output.writeInt(schemaBytes.length);
        output.writeBytes(schemaBytes);
        this.getDatumWriter(schema).write(datum, encoder);
        encoder.flush();
    }

    private D deserializeDatum(Input input) throws IOException {
        int schemaBytesLen = input.readInt();
        byte[] schemaBytes = input.readBytes(schemaBytesLen);
        Schema schema = this.getSchema(schemaBytes);
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(input, null);
        return (D)((GenericContainer)this.getDatumReader(schema).read(null, decoder));
    }

    @Override
    public void write(Kryo kryo, Output output, D datum) {
        try {
            this.serializeDatum(datum, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public D read(Kryo kryo, Input input, Class<D> datumClass) {
        try {
            return this.deserializeDatum(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

