/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.hudi.avro.model.HoodieMetadataBloomFilter;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieMetadataFileInfo;
import org.apache.hudi.avro.model.HoodieRecordIndexInfo;
import org.apache.hudi.avro.model.HoodieSecondaryIndexInfo;

@AvroGenerated
public class HoodieMetadataRecord
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 8428100175700986534L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieMetadataRecord\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"A record saved within the Metadata Table\",\"fields\":[{\"name\":\"key\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"type\",\"type\":\"int\",\"doc\":\"Type of the metadata record\"},{\"name\":\"filesystemMetadata\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"HoodieMetadataFileInfo\",\"fields\":[{\"name\":\"size\",\"type\":\"long\",\"doc\":\"Size of the file\"},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"True if this file has been deleted\"}]},\"avro.java.string\":\"String\"}],\"doc\":\"Contains information about partitions and files within the dataset\"},{\"name\":\"BloomFilterMetadata\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieMetadataBloomFilter\",\"doc\":\"Data file bloom filter details\",\"fields\":[{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Bloom filter type code\"},{\"name\":\"timestamp\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Instant timestamp when this metadata was created/updated\"},{\"name\":\"bloomFilter\",\"type\":\"bytes\",\"doc\":\"Bloom filter binary byte array\"},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"Bloom filter entry valid/deleted flag\"}]}],\"doc\":\"Metadata Index of bloom filters for all data files in the user table\",\"default\":null},{\"name\":\"ColumnStatsMetadata\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieMetadataColumnStats\",\"doc\":\"Data file column statistics\",\"fields\":[{\"name\":\"fileName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"File name for which this column statistics applies\",\"default\":null},{\"name\":\"columnName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Column name for which this column statistics applies\",\"default\":null},{\"name\":\"minValue\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"BooleanWrapper\",\"doc\":\"A record wrapping boolean type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"boolean\"}]},{\"type\":\"record\",\"name\":\"IntWrapper\",\"doc\":\"A record wrapping int type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"LongWrapper\",\"doc\":\"A record wrapping long type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"FloatWrapper\",\"doc\":\"A record wrapping float type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"float\"}]},{\"type\":\"record\",\"name\":\"DoubleWrapper\",\"doc\":\"A record wrapping double type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]},{\"type\":\"record\",\"name\":\"BytesWrapper\",\"doc\":\"A record wrapping bytes type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"bytes\"}]},{\"type\":\"record\",\"name\":\"StringWrapper\",\"doc\":\"A record wrapping string type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},{\"type\":\"record\",\"name\":\"DateWrapper\",\"doc\":\"A record wrapping Date logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"DecimalWrapper\",\"doc\":\"A record wrapping Decimal logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":30,\"scale\":15}}]},{\"type\":\"record\",\"name\":\"TimeMicrosWrapper\",\"doc\":\"A record wrapping Time-micros logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"long\",\"logicalType\":\"time-micros\"}}]},{\"type\":\"record\",\"name\":\"TimestampMicrosWrapper\",\"doc\":\"A record wrapping Timestamp-micros logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"LocalDateWrapper\",\"doc\":\"A record wrapping Local Date type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]}],\"doc\":\"Minimum value in the range. Based on user data table schema, we can convert this to appropriate type\",\"default\":null},{\"name\":\"maxValue\",\"type\":[\"null\",\"BooleanWrapper\",\"IntWrapper\",\"LongWrapper\",\"FloatWrapper\",\"DoubleWrapper\",\"BytesWrapper\",\"StringWrapper\",\"DateWrapper\",\"DecimalWrapper\",\"TimeMicrosWrapper\",\"TimestampMicrosWrapper\",\"LocalDateWrapper\"],\"doc\":\"Maximum value in the range. Based on user data table schema, we can convert it to appropriate type\",\"default\":null},{\"name\":\"valueCount\",\"type\":[\"null\",\"long\"],\"doc\":\"Total count of values\",\"default\":null},{\"name\":\"nullCount\",\"type\":[\"null\",\"long\"],\"doc\":\"Total count of null values\",\"default\":null},{\"name\":\"totalSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Total storage size on disk\",\"default\":null},{\"name\":\"totalUncompressedSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Total uncompressed storage size on disk\",\"default\":null},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"Column range entry valid/deleted flag\"},{\"name\":\"isTightBound\",\"type\":\"boolean\",\"doc\":\"Whether the min/max range of a column is tight bound or not\",\"default\":false}]}],\"doc\":\"Metadata Index of column statistics for all data files in the user table\",\"default\":null},{\"name\":\"recordIndexMetadata\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieRecordIndexInfo\",\"fields\":[{\"name\":\"partitionName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Refers to the partition name the record belongs to\",\"default\":null},{\"name\":\"fileIdHighBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to high 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIdLowBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to low 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIndex\",\"type\":[\"null\",\"int\"],\"doc\":\"Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.\",\"default\":null},{\"name\":\"instantTime\",\"type\":[\"null\",\"long\"],\"doc\":\"Epoch time in millisecond representing the commit time at which record was added\",\"default\":null},{\"name\":\"fileIdEncoding\",\"type\":\"int\",\"doc\":\"Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. \\nWhen the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdHighBits and fileIndex.\",\"default\":0},{\"name\":\"position\",\"type\":[\"null\",\"long\"],\"doc\":\"Represents position of record within a file group for easier access. It will be used for index lookup.\",\"default\":null}]}],\"doc\":\"Metadata Index that contains information about record keys and their location in the dataset\",\"default\":null},{\"name\":\"SecondaryIndexMetadata\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieSecondaryIndexInfo\",\"fields\":[{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"True if this entry has been deleted\"}]}],\"doc\":\"Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieMetadataRecord> ENCODER;
    private static final BinaryMessageDecoder<HoodieMetadataRecord> DECODER;
    private String key;
    private int type;
    private Map<String, HoodieMetadataFileInfo> filesystemMetadata;
    private HoodieMetadataBloomFilter BloomFilterMetadata;
    private HoodieMetadataColumnStats ColumnStatsMetadata;
    private HoodieRecordIndexInfo recordIndexMetadata;
    private HoodieSecondaryIndexInfo SecondaryIndexMetadata;
    private static final DatumWriter<HoodieMetadataRecord> WRITER$;
    private static final DatumReader<HoodieMetadataRecord> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieMetadataRecord> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieMetadataRecord> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieMetadataRecord> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<HoodieMetadataRecord>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static HoodieMetadataRecord fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieMetadataRecord)DECODER.decode(b);
    }

    public HoodieMetadataRecord() {
    }

    public HoodieMetadataRecord(String key, Integer type, Map<String, HoodieMetadataFileInfo> filesystemMetadata, HoodieMetadataBloomFilter BloomFilterMetadata, HoodieMetadataColumnStats ColumnStatsMetadata, HoodieRecordIndexInfo recordIndexMetadata, HoodieSecondaryIndexInfo SecondaryIndexMetadata) {
        this.key = key;
        this.type = type;
        this.filesystemMetadata = filesystemMetadata;
        this.BloomFilterMetadata = BloomFilterMetadata;
        this.ColumnStatsMetadata = ColumnStatsMetadata;
        this.recordIndexMetadata = recordIndexMetadata;
        this.SecondaryIndexMetadata = SecondaryIndexMetadata;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.key;
            }
            case 1: {
                return this.type;
            }
            case 2: {
                return this.filesystemMetadata;
            }
            case 3: {
                return this.BloomFilterMetadata;
            }
            case 4: {
                return this.ColumnStatsMetadata;
            }
            case 5: {
                return this.recordIndexMetadata;
            }
            case 6: {
                return this.SecondaryIndexMetadata;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.key = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.type = (Integer)value$;
                break;
            }
            case 2: {
                this.filesystemMetadata = (Map)value$;
                break;
            }
            case 3: {
                this.BloomFilterMetadata = (HoodieMetadataBloomFilter)value$;
                break;
            }
            case 4: {
                this.ColumnStatsMetadata = (HoodieMetadataColumnStats)value$;
                break;
            }
            case 5: {
                this.recordIndexMetadata = (HoodieRecordIndexInfo)value$;
                break;
            }
            case 6: {
                this.SecondaryIndexMetadata = (HoodieSecondaryIndexInfo)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String value) {
        this.key = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int value) {
        this.type = value;
    }

    public Map<String, HoodieMetadataFileInfo> getFilesystemMetadata() {
        return this.filesystemMetadata;
    }

    public void setFilesystemMetadata(Map<String, HoodieMetadataFileInfo> value) {
        this.filesystemMetadata = value;
    }

    public HoodieMetadataBloomFilter getBloomFilterMetadata() {
        return this.BloomFilterMetadata;
    }

    public void setBloomFilterMetadata(HoodieMetadataBloomFilter value) {
        this.BloomFilterMetadata = value;
    }

    public HoodieMetadataColumnStats getColumnStatsMetadata() {
        return this.ColumnStatsMetadata;
    }

    public void setColumnStatsMetadata(HoodieMetadataColumnStats value) {
        this.ColumnStatsMetadata = value;
    }

    public HoodieRecordIndexInfo getRecordIndexMetadata() {
        return this.recordIndexMetadata;
    }

    public void setRecordIndexMetadata(HoodieRecordIndexInfo value) {
        this.recordIndexMetadata = value;
    }

    public HoodieSecondaryIndexInfo getSecondaryIndexMetadata() {
        return this.SecondaryIndexMetadata;
    }

    public void setSecondaryIndexMetadata(HoodieSecondaryIndexInfo value) {
        this.SecondaryIndexMetadata = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieMetadataRecord other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    static {
        MODEL$.addLogicalTypeConversion(new TimeConversions.TimeMicrosConversion());
        MODEL$.addLogicalTypeConversion(new Conversions.DecimalConversion());
        ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieMetadataRecord>
    implements RecordBuilder<HoodieMetadataRecord> {
        private String key;
        private int type;
        private Map<String, HoodieMetadataFileInfo> filesystemMetadata;
        private HoodieMetadataBloomFilter BloomFilterMetadata;
        private HoodieMetadataBloomFilter.Builder BloomFilterMetadataBuilder;
        private HoodieMetadataColumnStats ColumnStatsMetadata;
        private HoodieMetadataColumnStats.Builder ColumnStatsMetadataBuilder;
        private HoodieRecordIndexInfo recordIndexMetadata;
        private HoodieRecordIndexInfo.Builder recordIndexMetadataBuilder;
        private HoodieSecondaryIndexInfo SecondaryIndexMetadata;
        private HoodieSecondaryIndexInfo.Builder SecondaryIndexMetadataBuilder;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.key)) {
                this.key = this.data().deepCopy(this.fields()[0].schema(), other.key);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.type)) {
                this.type = this.data().deepCopy(this.fields()[1].schema(), other.type);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.filesystemMetadata)) {
                this.filesystemMetadata = this.data().deepCopy(this.fields()[2].schema(), other.filesystemMetadata);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.BloomFilterMetadata)) {
                this.BloomFilterMetadata = this.data().deepCopy(this.fields()[3].schema(), other.BloomFilterMetadata);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (other.hasBloomFilterMetadataBuilder()) {
                this.BloomFilterMetadataBuilder = HoodieMetadataBloomFilter.newBuilder(other.getBloomFilterMetadataBuilder());
            }
            if (Builder.isValidValue(this.fields()[4], other.ColumnStatsMetadata)) {
                this.ColumnStatsMetadata = this.data().deepCopy(this.fields()[4].schema(), other.ColumnStatsMetadata);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (other.hasColumnStatsMetadataBuilder()) {
                this.ColumnStatsMetadataBuilder = HoodieMetadataColumnStats.newBuilder(other.getColumnStatsMetadataBuilder());
            }
            if (Builder.isValidValue(this.fields()[5], other.recordIndexMetadata)) {
                this.recordIndexMetadata = this.data().deepCopy(this.fields()[5].schema(), other.recordIndexMetadata);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (other.hasRecordIndexMetadataBuilder()) {
                this.recordIndexMetadataBuilder = HoodieRecordIndexInfo.newBuilder(other.getRecordIndexMetadataBuilder());
            }
            if (Builder.isValidValue(this.fields()[6], other.SecondaryIndexMetadata)) {
                this.SecondaryIndexMetadata = this.data().deepCopy(this.fields()[6].schema(), other.SecondaryIndexMetadata);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (other.hasSecondaryIndexMetadataBuilder()) {
                this.SecondaryIndexMetadataBuilder = HoodieSecondaryIndexInfo.newBuilder(other.getSecondaryIndexMetadataBuilder());
            }
        }

        private Builder(HoodieMetadataRecord other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.key)) {
                this.key = this.data().deepCopy(this.fields()[0].schema(), other.key);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.type)) {
                this.type = this.data().deepCopy(this.fields()[1].schema(), other.type);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.filesystemMetadata)) {
                this.filesystemMetadata = this.data().deepCopy(this.fields()[2].schema(), other.filesystemMetadata);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.BloomFilterMetadata)) {
                this.BloomFilterMetadata = this.data().deepCopy(this.fields()[3].schema(), other.BloomFilterMetadata);
                this.fieldSetFlags()[3] = true;
            }
            this.BloomFilterMetadataBuilder = null;
            if (Builder.isValidValue(this.fields()[4], other.ColumnStatsMetadata)) {
                this.ColumnStatsMetadata = this.data().deepCopy(this.fields()[4].schema(), other.ColumnStatsMetadata);
                this.fieldSetFlags()[4] = true;
            }
            this.ColumnStatsMetadataBuilder = null;
            if (Builder.isValidValue(this.fields()[5], other.recordIndexMetadata)) {
                this.recordIndexMetadata = this.data().deepCopy(this.fields()[5].schema(), other.recordIndexMetadata);
                this.fieldSetFlags()[5] = true;
            }
            this.recordIndexMetadataBuilder = null;
            if (Builder.isValidValue(this.fields()[6], other.SecondaryIndexMetadata)) {
                this.SecondaryIndexMetadata = this.data().deepCopy(this.fields()[6].schema(), other.SecondaryIndexMetadata);
                this.fieldSetFlags()[6] = true;
            }
            this.SecondaryIndexMetadataBuilder = null;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String value) {
            this.validate(this.fields()[0], value);
            this.key = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasKey() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearKey() {
            this.key = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public int getType() {
            return this.type;
        }

        public Builder setType(int value) {
            this.validate(this.fields()[1], value);
            this.type = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearType() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Map<String, HoodieMetadataFileInfo> getFilesystemMetadata() {
            return this.filesystemMetadata;
        }

        public Builder setFilesystemMetadata(Map<String, HoodieMetadataFileInfo> value) {
            this.validate(this.fields()[2], value);
            this.filesystemMetadata = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasFilesystemMetadata() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearFilesystemMetadata() {
            this.filesystemMetadata = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public HoodieMetadataBloomFilter getBloomFilterMetadata() {
            return this.BloomFilterMetadata;
        }

        public Builder setBloomFilterMetadata(HoodieMetadataBloomFilter value) {
            this.validate(this.fields()[3], value);
            this.BloomFilterMetadataBuilder = null;
            this.BloomFilterMetadata = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasBloomFilterMetadata() {
            return this.fieldSetFlags()[3];
        }

        public HoodieMetadataBloomFilter.Builder getBloomFilterMetadataBuilder() {
            if (this.BloomFilterMetadataBuilder == null) {
                if (this.hasBloomFilterMetadata()) {
                    this.setBloomFilterMetadataBuilder(HoodieMetadataBloomFilter.newBuilder(this.BloomFilterMetadata));
                } else {
                    this.setBloomFilterMetadataBuilder(HoodieMetadataBloomFilter.newBuilder());
                }
            }
            return this.BloomFilterMetadataBuilder;
        }

        public Builder setBloomFilterMetadataBuilder(HoodieMetadataBloomFilter.Builder value) {
            this.clearBloomFilterMetadata();
            this.BloomFilterMetadataBuilder = value;
            return this;
        }

        public boolean hasBloomFilterMetadataBuilder() {
            return this.BloomFilterMetadataBuilder != null;
        }

        public Builder clearBloomFilterMetadata() {
            this.BloomFilterMetadata = null;
            this.BloomFilterMetadataBuilder = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public HoodieMetadataColumnStats getColumnStatsMetadata() {
            return this.ColumnStatsMetadata;
        }

        public Builder setColumnStatsMetadata(HoodieMetadataColumnStats value) {
            this.validate(this.fields()[4], value);
            this.ColumnStatsMetadataBuilder = null;
            this.ColumnStatsMetadata = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasColumnStatsMetadata() {
            return this.fieldSetFlags()[4];
        }

        public HoodieMetadataColumnStats.Builder getColumnStatsMetadataBuilder() {
            if (this.ColumnStatsMetadataBuilder == null) {
                if (this.hasColumnStatsMetadata()) {
                    this.setColumnStatsMetadataBuilder(HoodieMetadataColumnStats.newBuilder(this.ColumnStatsMetadata));
                } else {
                    this.setColumnStatsMetadataBuilder(HoodieMetadataColumnStats.newBuilder());
                }
            }
            return this.ColumnStatsMetadataBuilder;
        }

        public Builder setColumnStatsMetadataBuilder(HoodieMetadataColumnStats.Builder value) {
            this.clearColumnStatsMetadata();
            this.ColumnStatsMetadataBuilder = value;
            return this;
        }

        public boolean hasColumnStatsMetadataBuilder() {
            return this.ColumnStatsMetadataBuilder != null;
        }

        public Builder clearColumnStatsMetadata() {
            this.ColumnStatsMetadata = null;
            this.ColumnStatsMetadataBuilder = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public HoodieRecordIndexInfo getRecordIndexMetadata() {
            return this.recordIndexMetadata;
        }

        public Builder setRecordIndexMetadata(HoodieRecordIndexInfo value) {
            this.validate(this.fields()[5], value);
            this.recordIndexMetadataBuilder = null;
            this.recordIndexMetadata = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasRecordIndexMetadata() {
            return this.fieldSetFlags()[5];
        }

        public HoodieRecordIndexInfo.Builder getRecordIndexMetadataBuilder() {
            if (this.recordIndexMetadataBuilder == null) {
                if (this.hasRecordIndexMetadata()) {
                    this.setRecordIndexMetadataBuilder(HoodieRecordIndexInfo.newBuilder(this.recordIndexMetadata));
                } else {
                    this.setRecordIndexMetadataBuilder(HoodieRecordIndexInfo.newBuilder());
                }
            }
            return this.recordIndexMetadataBuilder;
        }

        public Builder setRecordIndexMetadataBuilder(HoodieRecordIndexInfo.Builder value) {
            this.clearRecordIndexMetadata();
            this.recordIndexMetadataBuilder = value;
            return this;
        }

        public boolean hasRecordIndexMetadataBuilder() {
            return this.recordIndexMetadataBuilder != null;
        }

        public Builder clearRecordIndexMetadata() {
            this.recordIndexMetadata = null;
            this.recordIndexMetadataBuilder = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public HoodieSecondaryIndexInfo getSecondaryIndexMetadata() {
            return this.SecondaryIndexMetadata;
        }

        public Builder setSecondaryIndexMetadata(HoodieSecondaryIndexInfo value) {
            this.validate(this.fields()[6], value);
            this.SecondaryIndexMetadataBuilder = null;
            this.SecondaryIndexMetadata = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSecondaryIndexMetadata() {
            return this.fieldSetFlags()[6];
        }

        public HoodieSecondaryIndexInfo.Builder getSecondaryIndexMetadataBuilder() {
            if (this.SecondaryIndexMetadataBuilder == null) {
                if (this.hasSecondaryIndexMetadata()) {
                    this.setSecondaryIndexMetadataBuilder(HoodieSecondaryIndexInfo.newBuilder(this.SecondaryIndexMetadata));
                } else {
                    this.setSecondaryIndexMetadataBuilder(HoodieSecondaryIndexInfo.newBuilder());
                }
            }
            return this.SecondaryIndexMetadataBuilder;
        }

        public Builder setSecondaryIndexMetadataBuilder(HoodieSecondaryIndexInfo.Builder value) {
            this.clearSecondaryIndexMetadata();
            this.SecondaryIndexMetadataBuilder = value;
            return this;
        }

        public boolean hasSecondaryIndexMetadataBuilder() {
            return this.SecondaryIndexMetadataBuilder != null;
        }

        public Builder clearSecondaryIndexMetadata() {
            this.SecondaryIndexMetadata = null;
            this.SecondaryIndexMetadataBuilder = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        @Override
        public HoodieMetadataRecord build() {
            try {
                HoodieMetadataRecord record = new HoodieMetadataRecord();
                record.key = this.fieldSetFlags()[0] ? this.key : (String)this.defaultValue(this.fields()[0]);
                record.type = this.fieldSetFlags()[1] ? this.type : (Integer)this.defaultValue(this.fields()[1]);
                record.filesystemMetadata = this.fieldSetFlags()[2] ? this.filesystemMetadata : (Map)this.defaultValue(this.fields()[2]);
                if (this.BloomFilterMetadataBuilder != null) {
                    try {
                        record.BloomFilterMetadata = this.BloomFilterMetadataBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("BloomFilterMetadata"));
                        throw e;
                    }
                } else {
                    record.BloomFilterMetadata = this.fieldSetFlags()[3] ? this.BloomFilterMetadata : (HoodieMetadataBloomFilter)this.defaultValue(this.fields()[3]);
                }
                if (this.ColumnStatsMetadataBuilder != null) {
                    try {
                        record.ColumnStatsMetadata = this.ColumnStatsMetadataBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("ColumnStatsMetadata"));
                        throw e;
                    }
                } else {
                    record.ColumnStatsMetadata = this.fieldSetFlags()[4] ? this.ColumnStatsMetadata : (HoodieMetadataColumnStats)this.defaultValue(this.fields()[4]);
                }
                if (this.recordIndexMetadataBuilder != null) {
                    try {
                        record.recordIndexMetadata = this.recordIndexMetadataBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("recordIndexMetadata"));
                        throw e;
                    }
                } else {
                    record.recordIndexMetadata = this.fieldSetFlags()[5] ? this.recordIndexMetadata : (HoodieRecordIndexInfo)this.defaultValue(this.fields()[5]);
                }
                if (this.SecondaryIndexMetadataBuilder != null) {
                    try {
                        record.SecondaryIndexMetadata = this.SecondaryIndexMetadataBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("SecondaryIndexMetadata"));
                        throw e;
                    }
                } else {
                    record.SecondaryIndexMetadata = this.fieldSetFlags()[6] ? this.SecondaryIndexMetadata : (HoodieSecondaryIndexInfo)this.defaultValue(this.fields()[6]);
                }
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

