/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.util.LocalAvroSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public abstract class HoodieReaderContext<T>
implements Closeable {
    private FileGroupReaderSchemaHandler<T> schemaHandler = null;
    private String tablePath = null;
    private String latestCommitTime = null;
    private Option<HoodieRecordMerger> recordMerger = null;
    private Boolean hasLogFiles = null;
    private Boolean hasBootstrapBaseFile = null;
    private Boolean needsBootstrapMerge = null;
    private Boolean shouldMergeUseRecordPosition = null;
    private final LocalAvroSchemaCache localAvroSchemaCache = LocalAvroSchemaCache.getInstance();

    public FileGroupReaderSchemaHandler<T> getSchemaHandler() {
        return this.schemaHandler;
    }

    public void setSchemaHandler(FileGroupReaderSchemaHandler<T> schemaHandler) {
        this.schemaHandler = schemaHandler;
    }

    public String getTablePath() {
        if (this.tablePath == null) {
            throw new IllegalStateException("Table path not set in reader context.");
        }
        return this.tablePath;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public String getLatestCommitTime() {
        return this.latestCommitTime;
    }

    public void setLatestCommitTime(String latestCommitTime) {
        this.latestCommitTime = latestCommitTime;
    }

    public Option<HoodieRecordMerger> getRecordMerger() {
        return this.recordMerger;
    }

    public void setRecordMerger(Option<HoodieRecordMerger> recordMerger) {
        this.recordMerger = recordMerger;
    }

    public boolean getHasLogFiles() {
        return this.hasLogFiles;
    }

    public void setHasLogFiles(boolean hasLogFiles) {
        this.hasLogFiles = hasLogFiles;
    }

    public boolean getHasBootstrapBaseFile() {
        return this.hasBootstrapBaseFile;
    }

    public void setHasBootstrapBaseFile(boolean hasBootstrapBaseFile) {
        this.hasBootstrapBaseFile = hasBootstrapBaseFile;
    }

    public boolean getNeedsBootstrapMerge() {
        return this.needsBootstrapMerge;
    }

    public void setNeedsBootstrapMerge(boolean needsBootstrapMerge) {
        this.needsBootstrapMerge = needsBootstrapMerge;
    }

    public boolean getShouldMergeUseRecordPosition() {
        return this.shouldMergeUseRecordPosition;
    }

    public void setShouldMergeUseRecordPosition(boolean shouldMergeUseRecordPosition) {
        this.shouldMergeUseRecordPosition = shouldMergeUseRecordPosition;
    }

    public abstract ClosableIterator<T> getFileRecordIterator(StoragePath var1, long var2, long var4, Schema var6, Schema var7, HoodieStorage var8) throws IOException;

    public ClosableIterator<T> getFileRecordIterator(StoragePathInfo storagePathInfo, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        return this.getFileRecordIterator(storagePathInfo.getPath(), start, length, dataSchema, requiredSchema, storage);
    }

    public abstract T convertAvroRecord(IndexedRecord var1);

    public abstract GenericRecord convertToAvroRecord(T var1, Schema var2);

    public abstract Option<HoodieRecordMerger> getRecordMerger(RecordMergeMode var1, String var2, String var3);

    public abstract Object getValue(T var1, Schema var2, String var3);

    public boolean castToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Input value type " + value.getClass() + ", cannot be cast to boolean");
    }

    public String getRecordKey(T record, Schema schema) {
        Object val = this.getValue(record, schema, HoodieRecord.RECORD_KEY_METADATA_FIELD);
        return val.toString();
    }

    public Comparable getOrderingValue(T record, Schema schema, Option<String> orderingFieldName) {
        if (orderingFieldName.isEmpty()) {
            return Integer.valueOf(0);
        }
        Object value = this.getValue(record, schema, orderingFieldName.get());
        Integer finalOrderingVal = value != null ? this.convertValueToEngineType((Comparable)value) : Integer.valueOf(0);
        return finalOrderingVal;
    }

    public abstract HoodieRecord<T> constructHoodieRecord(BufferedRecord<T> var1);

    public abstract T seal(T var1);

    public abstract T toBinaryRow(Schema var1, T var2);

    public Schema getSchemaFromBufferRecord(BufferedRecord<T> record) {
        return this.decodeAvroSchema(record.getSchemaId());
    }

    public abstract ClosableIterator<T> mergeBootstrapReaders(ClosableIterator<T> var1, Schema var2, ClosableIterator<T> var3, Schema var4);

    public abstract UnaryOperator<T> projectRecord(Schema var1, Schema var2, Map<String, String> var3);

    public final UnaryOperator<T> projectRecord(Schema from, Schema to) {
        return this.projectRecord(from, to, Collections.emptyMap());
    }

    public Comparable convertValueToEngineType(Comparable value) {
        return value;
    }

    public long extractRecordPosition(T record, Schema schema, String fieldName, long providedPositionIfNeeded) {
        if (this.supportsParquetRowIndex()) {
            Object position = this.getValue(record, schema, fieldName);
            if (position != null) {
                return (Long)position;
            }
            throw new IllegalStateException("Record position extraction failed");
        }
        return providedPositionIfNeeded;
    }

    public boolean supportsParquetRowIndex() {
        return false;
    }

    public Integer encodeAvroSchema(Schema schema) {
        return this.localAvroSchemaCache.cacheSchema(schema);
    }

    @Nullable
    private Schema decodeAvroSchema(Object versionId) {
        return this.localAvroSchemaCache.getSchema((Integer)versionId).orElse(null);
    }

    @Override
    public void close() {
        if (this.localAvroSchemaCache != null) {
            this.localAvroSchemaCache.close();
        }
    }
}

