/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.avro.model.HoodieSavepointPartitionMetadata;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.StoragePathInfo;

public class TimelineMetadataUtils {
    private static final Integer DEFAULT_VERSION = 1;

    @Deprecated
    public static <T> byte[] convertMetadataToByteArray(T metadata, CommitMetadataSerDe serDe) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            serDe.getInstantWriter(metadata).get().writeToStream(outputStream);
            return outputStream.toByteArray();
        }
        catch (Exception ex) {
            throw new HoodieException(ex);
        }
    }

    public static HoodieRestoreMetadata convertRestoreMetadata(String startRestoreTime, long durationInMs, List<HoodieInstant> instants, Map<String, List<HoodieRollbackMetadata>> instantToRollbackMetadata) {
        return new HoodieRestoreMetadata(startRestoreTime, durationInMs, instants.stream().map(HoodieInstant::requestedTime).collect(Collectors.toList()), Collections.unmodifiableMap(instantToRollbackMetadata), DEFAULT_VERSION, instants.stream().map(instant -> new HoodieInstantInfo(instant.requestedTime(), instant.getAction())).collect(Collectors.toList()));
    }

    public static HoodieRollbackMetadata convertRollbackMetadata(String startRollbackTime, Option<Long> durationInMs, List<HoodieInstant> instants, List<HoodieRollbackStat> rollbackStats) {
        HashMap<String, HoodieRollbackPartitionMetadata> partitionMetadataBuilder = new HashMap<String, HoodieRollbackPartitionMetadata>();
        int totalDeleted = 0;
        for (HoodieRollbackStat stat : rollbackStats) {
            Map<String, Long> rollbackLogFiles = stat.getCommandBlocksCount().keySet().stream().collect(Collectors.toMap(f -> f.getPath().toString(), StoragePathInfo::getLength));
            HoodieRollbackPartitionMetadata metadata = new HoodieRollbackPartitionMetadata(stat.getPartitionPath(), stat.getSuccessDeleteFiles(), stat.getFailedDeleteFiles(), rollbackLogFiles, stat.getLogFilesFromFailedCommit());
            partitionMetadataBuilder.put(stat.getPartitionPath(), metadata);
            totalDeleted += stat.getSuccessDeleteFiles().size();
        }
        return new HoodieRollbackMetadata(startRollbackTime, durationInMs.orElseGet(() -> -1L), totalDeleted, instants.stream().map(HoodieInstant::requestedTime).collect(Collectors.toList()), Collections.unmodifiableMap(partitionMetadataBuilder), DEFAULT_VERSION, instants.stream().map(instant -> new HoodieInstantInfo(instant.requestedTime(), instant.getAction())).collect(Collectors.toList()));
    }

    public static HoodieSavepointMetadata convertSavepointMetadata(String user, String comment, Map<String, List<String>> latestFiles) {
        HashMap<String, HoodieSavepointPartitionMetadata> partitionMetadataBuilder = new HashMap<String, HoodieSavepointPartitionMetadata>();
        for (Map.Entry<String, List<String>> stat : latestFiles.entrySet()) {
            HoodieSavepointPartitionMetadata metadata = new HoodieSavepointPartitionMetadata(stat.getKey(), stat.getValue());
            partitionMetadataBuilder.put(stat.getKey(), metadata);
        }
        return new HoodieSavepointMetadata(user, System.currentTimeMillis(), comment, Collections.unmodifiableMap(partitionMetadataBuilder), DEFAULT_VERSION);
    }

    public static <T extends SpecificRecordBase> Option<byte[]> serializeAvroMetadata(T metadata, Class<T> clazz) throws IOException {
        SpecificDatumWriter<T> datumWriter = new SpecificDatumWriter<T>(clazz);
        try (DataFileWriter<T> fileWriter = new DataFileWriter<T>(datumWriter);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            fileWriter.create(metadata.getSchema(), baos);
            fileWriter.append(metadata);
            fileWriter.flush();
            Option<byte[]> option = Option.of(baos.toByteArray());
            return option;
        }
    }

    public static <T extends SpecificRecordBase> T deserializeAvroMetadataLegacy(byte[] bytes, Class<T> clazz) throws IOException {
        SpecificDatumReader<T> reader = new SpecificDatumReader<T>(clazz);
        FileReader<T> fileReader = DataFileReader.openReader(new SeekableByteArrayInput(bytes), reader);
        ValidationUtils.checkArgument(fileReader.hasNext(), "Could not deserialize metadata of type " + clazz);
        return (T)((SpecificRecordBase)fileReader.next());
    }

    public static <T extends SpecificRecordBase> T deserializeAvroMetadata(InputStream inputStream, Class<T> clazz) throws IOException {
        SpecificDatumReader<T> reader = new SpecificDatumReader<T>(clazz);
        try (DataFileStream<T> fileReader = new DataFileStream<T>(inputStream, reader);){
            ValidationUtils.checkArgument(fileReader.hasNext(), "Could not deserialize metadata of type " + clazz);
            SpecificRecordBase specificRecordBase = (SpecificRecordBase)fileReader.next();
            return (T)specificRecordBase;
        }
    }
}

