/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.avro.InstanceCache;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAvroSerializer {
    private final List<String> columnNames;
    private final List<TypeInfo> columnTypes;
    private final ObjectInspector objectInspector;
    private static final Logger LOG = LoggerFactory.getLogger(HiveAvroSerializer.class);
    private static final Schema STRING_SCHEMA = Schema.create(Schema.Type.STRING);
    final InstanceCache<Schema, InstanceCache<Object, GenericEnumSymbol>> enums = new InstanceCache<Schema, InstanceCache<Object, GenericEnumSymbol>>(){

        protected InstanceCache<Object, GenericEnumSymbol> makeInstance(final Schema schema, Set<Schema> seenSchemas) {
            return new InstanceCache<Object, GenericEnumSymbol>(){

                protected GenericEnumSymbol makeInstance(Object seed, Set<Object> seenSchemas) {
                    return new GenericData.EnumSymbol(schema, seed.toString());
                }
            };
        }
    };

    public HiveAvroSerializer(ObjectInspector objectInspector, List<String> columnNames, List<TypeInfo> columnTypes) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.objectInspector = objectInspector;
    }

    public GenericRecord serialize(Object o, Schema schema) {
        StructObjectInspector soi = (StructObjectInspector)this.objectInspector;
        GenericData.Record record = new GenericData.Record(schema);
        List outputFieldRefs = soi.getAllStructFieldRefs();
        if (outputFieldRefs.size() != this.columnNames.size()) {
            throw new HoodieException("Number of input columns was different than output columns (in = " + this.columnNames.size() + " vs out = " + outputFieldRefs.size());
        }
        int size = schema.getFields().size();
        List allStructFieldRefs = soi.getAllStructFieldRefs();
        List structFieldsDataAsList = soi.getStructFieldsDataAsList(o);
        for (int i = 0; i < size; ++i) {
            Schema.Field field = schema.getFields().get(i);
            if (i >= this.columnTypes.size()) break;
            try {
                this.setUpRecordFieldFromWritable(this.columnTypes.get(i), structFieldsDataAsList.get(i), ((StructField)allStructFieldRefs.get(i)).getFieldObjectInspector(), record, field);
                continue;
            }
            catch (Exception e) {
                LOG.error(String.format("current columnNames: %s", this.columnNames.stream().collect(Collectors.joining(","))));
                LOG.error(String.format("current type: %s", this.columnTypes.stream().map(f -> f.getTypeName()).collect(Collectors.joining(","))));
                LOG.error(String.format("current value: %s", HoodieRealtimeRecordReaderUtils.arrayWritableToString((ArrayWritable)o)));
                throw e;
            }
        }
        return record;
    }

    private void setUpRecordFieldFromWritable(TypeInfo typeInfo, Object structFieldData, ObjectInspector fieldOI, GenericData.Record record, Schema.Field field) {
        Object val = this.serialize(typeInfo, fieldOI, structFieldData, field.schema());
        if (val == null) {
            if (field.defaultVal() instanceof JsonProperties.Null) {
                record.put(field.name(), null);
            } else {
                record.put(field.name(), field.defaultVal());
            }
        } else {
            record.put(field.name(), val);
        }
    }

    public static boolean isNullableType(Schema schema) {
        if (!schema.getType().equals((Object)Schema.Type.UNION)) {
            return false;
        }
        List<Schema> itemSchemas = schema.getTypes();
        if (itemSchemas.size() < 2) {
            return false;
        }
        for (Schema itemSchema : itemSchemas) {
            if (!Schema.Type.NULL.equals((Object)itemSchema.getType())) continue;
            return true;
        }
        return false;
    }

    public static Schema getOtherTypeFromNullableType(Schema unionSchema) {
        List<Schema> types = unionSchema.getTypes();
        if (types.size() == 2) {
            if (types.get(0).getType() == Schema.Type.NULL) {
                return types.get(1);
            }
            if (types.get(1).getType() == Schema.Type.NULL) {
                return types.get(0);
            }
            return unionSchema;
        }
        ArrayList<Schema> itemSchemas = new ArrayList<Schema>();
        for (Schema itemSchema : types) {
            if (Schema.Type.NULL.equals((Object)itemSchema.getType())) continue;
            itemSchemas.add(itemSchema);
        }
        if (itemSchemas.size() > 1) {
            return Schema.createUnion(itemSchemas);
        }
        return (Schema)itemSchemas.get(0);
    }

    private Object serialize(TypeInfo typeInfo, ObjectInspector fieldOI, Object structFieldData, Schema schema) throws HoodieException {
        if (null == structFieldData) {
            return null;
        }
        if (HiveAvroSerializer.isNullableType(schema)) {
            schema = HiveAvroSerializer.getOtherTypeFromNullableType(schema);
        }
        if (Schema.Type.ENUM.equals((Object)schema.getType())) {
            assert (fieldOI instanceof PrimitiveObjectInspector);
            return this.serializeEnum((PrimitiveObjectInspector)fieldOI, structFieldData, schema);
        }
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                assert (fieldOI instanceof PrimitiveObjectInspector);
                return this.serializePrimitive((PrimitiveObjectInspector)fieldOI, structFieldData, schema);
            }
            case MAP: {
                assert (fieldOI instanceof MapObjectInspector);
                assert (typeInfo instanceof MapTypeInfo);
                return this.serializeMap((MapTypeInfo)typeInfo, (MapObjectInspector)fieldOI, structFieldData, schema);
            }
            case LIST: {
                assert (fieldOI instanceof ListObjectInspector);
                assert (typeInfo instanceof ListTypeInfo);
                return this.serializeList((ListTypeInfo)typeInfo, (ListObjectInspector)fieldOI, structFieldData, schema);
            }
            case UNION: {
                assert (fieldOI instanceof UnionObjectInspector);
                assert (typeInfo instanceof UnionTypeInfo);
                return this.serializeUnion((UnionTypeInfo)typeInfo, (UnionObjectInspector)fieldOI, structFieldData, schema);
            }
            case STRUCT: {
                assert (fieldOI instanceof StructObjectInspector);
                assert (typeInfo instanceof StructTypeInfo);
                return this.serializeStruct((StructTypeInfo)typeInfo, (StructObjectInspector)fieldOI, structFieldData, schema);
            }
        }
        throw new HoodieException("Ran out of TypeInfo Categories: " + typeInfo.getCategory());
    }

    private Object serializeEnum(PrimitiveObjectInspector fieldOI, Object structFieldData, Schema schema) throws HoodieException {
        try {
            return ((InstanceCache)this.enums.retrieve((Object)schema)).retrieve(this.serializePrimitive(fieldOI, structFieldData, schema));
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
    }

    private Object serializeStruct(StructTypeInfo typeInfo, StructObjectInspector ssoi, Object o, Schema schema) {
        int size = schema.getFields().size();
        List allStructFieldRefs = ssoi.getAllStructFieldRefs();
        List structFieldsDataAsList = ssoi.getStructFieldsDataAsList(o);
        GenericData.Record record = new GenericData.Record(schema);
        ArrayList allStructFieldTypeInfos = typeInfo.getAllStructFieldTypeInfos();
        for (int i = 0; i < size; ++i) {
            Schema.Field field = schema.getFields().get(i);
            this.setUpRecordFieldFromWritable((TypeInfo)allStructFieldTypeInfos.get(i), structFieldsDataAsList.get(i), ((StructField)allStructFieldRefs.get(i)).getFieldObjectInspector(), record, field);
        }
        return record;
    }

    private Object serializePrimitive(PrimitiveObjectInspector fieldOI, Object structFieldData, Schema schema) throws HoodieException {
        switch (fieldOI.getPrimitiveCategory()) {
            case BINARY: {
                if (schema.getType() == Schema.Type.BYTES) {
                    return AvroSerdeUtils.getBufferFromBytes((byte[])((byte[])fieldOI.getPrimitiveJavaObject(structFieldData)));
                }
                if (schema.getType() == Schema.Type.FIXED) {
                    GenericData.Fixed fixed = new GenericData.Fixed(schema, (byte[])fieldOI.getPrimitiveJavaObject(structFieldData));
                    return fixed;
                }
                throw new HoodieException("Unexpected Avro schema for Binary TypeInfo: " + (Object)((Object)schema.getType()));
            }
            case DECIMAL: {
                HiveDecimal dec = (HiveDecimal)fieldOI.getPrimitiveJavaObject(structFieldData);
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)schema.getLogicalType();
                BigDecimal bd = new BigDecimal(dec.toString()).setScale(decimal.getScale());
                if (schema.getType() == Schema.Type.BYTES) {
                    return HoodieAvroUtils.DECIMAL_CONVERSION.toBytes(bd, schema, (LogicalType)decimal);
                }
                return HoodieAvroUtils.DECIMAL_CONVERSION.toFixed(bd, schema, (LogicalType)decimal);
            }
            case CHAR: {
                HiveChar ch = (HiveChar)fieldOI.getPrimitiveJavaObject(structFieldData);
                return new Utf8(ch.getStrippedValue());
            }
            case VARCHAR: {
                HiveVarchar vc = (HiveVarchar)fieldOI.getPrimitiveJavaObject(structFieldData);
                return new Utf8(vc.getValue());
            }
            case STRING: {
                String string = (String)fieldOI.getPrimitiveJavaObject(structFieldData);
                return new Utf8(string);
            }
            case DATE: {
                return HoodieHiveUtils.getDays(structFieldData);
            }
            case TIMESTAMP: {
                return HoodieHiveUtils.getMills(structFieldData);
            }
            case INT: {
                if (schema.getLogicalType() != null && schema.getLogicalType().getName().equals("date")) {
                    return new WritableDateObjectInspector().getPrimitiveWritableObject(structFieldData).getDays();
                }
                return fieldOI.getPrimitiveJavaObject(structFieldData);
            }
            case UNKNOWN: {
                throw new HoodieException("Received UNKNOWN primitive category.");
            }
            case VOID: {
                return null;
            }
        }
        return fieldOI.getPrimitiveJavaObject(structFieldData);
    }

    private Object serializeUnion(UnionTypeInfo typeInfo, UnionObjectInspector fieldOI, Object structFieldData, Schema schema) throws HoodieException {
        byte tag = fieldOI.getTag(structFieldData);
        return this.serialize((TypeInfo)typeInfo.getAllUnionObjectTypeInfos().get(tag), (ObjectInspector)fieldOI.getObjectInspectors().get(tag), fieldOI.getField(structFieldData), schema.getTypes().get(tag));
    }

    private Object serializeList(ListTypeInfo typeInfo, ListObjectInspector fieldOI, Object structFieldData, Schema schema) throws HoodieException {
        List list = fieldOI.getList(structFieldData);
        GenericData.Array deserialized = new GenericData.Array(list.size(), schema);
        TypeInfo listElementTypeInfo = typeInfo.getListElementTypeInfo();
        ObjectInspector listElementObjectInspector = fieldOI.getListElementObjectInspector();
        Schema arrayNestedType = AvroSchemaUtils.resolveNullableSchema(schema.getElementType());
        Schema elementType = listElementObjectInspector.getCategory() == ObjectInspector.Category.PRIMITIVE ? arrayNestedType : (arrayNestedType.getField("element") == null ? arrayNestedType : arrayNestedType.getField("element").schema());
        for (int i = 0; i < list.size(); ++i) {
            Object childFieldData = list.get(i);
            if (childFieldData instanceof ArrayWritable && ((ArrayWritable)childFieldData).get().length != ((StructTypeInfo)listElementTypeInfo).getAllStructFieldNames().size()) {
                deserialized.add(i, this.serialize(listElementTypeInfo, listElementObjectInspector, ((ArrayWritable)childFieldData).get()[0], elementType));
                continue;
            }
            deserialized.add(i, this.serialize(listElementTypeInfo, listElementObjectInspector, childFieldData, elementType));
        }
        return deserialized;
    }

    private Object serializeMap(MapTypeInfo typeInfo, MapObjectInspector fieldOI, Object structFieldData, Schema schema) throws HoodieException {
        if (!this.mapHasStringKey(fieldOI.getMapKeyObjectInspector())) {
            throw new HoodieException("Avro only supports maps with keys as Strings.  Current Map is: " + typeInfo.toString());
        }
        ObjectInspector mapKeyObjectInspector = fieldOI.getMapKeyObjectInspector();
        ObjectInspector mapValueObjectInspector = fieldOI.getMapValueObjectInspector();
        TypeInfo mapKeyTypeInfo = typeInfo.getMapKeyTypeInfo();
        TypeInfo mapValueTypeInfo = typeInfo.getMapValueTypeInfo();
        Map map = fieldOI.getMap(structFieldData);
        Schema valueType = schema.getValueType();
        LinkedHashMap<Object, Object> deserialized = new LinkedHashMap<Object, Object>(fieldOI.getMapSize(structFieldData));
        for (Map.Entry entry : map.entrySet()) {
            deserialized.put(this.serialize(mapKeyTypeInfo, mapKeyObjectInspector, entry.getKey(), STRING_SCHEMA), this.serialize(mapValueTypeInfo, mapValueObjectInspector, entry.getValue(), valueType));
        }
        return deserialized;
    }

    private boolean mapHasStringKey(ObjectInspector mapKeyObjectInspector) {
        return mapKeyObjectInspector instanceof PrimitiveObjectInspector && ((PrimitiveObjectInspector)mapKeyObjectInspector).getPrimitiveCategory().equals((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING);
    }

    public static GenericRecord rewriteRecordIgnoreResultCheck(GenericRecord oldRecord, Schema newSchema) {
        GenericData.Record newRecord = new GenericData.Record(newSchema);
        boolean isSpecificRecord = oldRecord instanceof SpecificRecordBase;
        for (Schema.Field f : newSchema.getFields()) {
            if (isSpecificRecord && HoodieAvroUtils.isMetadataField(f.name())) continue;
            HiveAvroSerializer.copyOldValueOrSetDefault(oldRecord, newRecord, f);
        }
        return newRecord;
    }

    private static void copyOldValueOrSetDefault(GenericRecord oldRecord, GenericRecord newRecord, Schema.Field field) {
        Object fieldValue;
        Schema oldSchema = oldRecord.getSchema();
        Object object = fieldValue = oldSchema.getField(field.name()) == null ? null : oldRecord.get(field.name());
        if (fieldValue != null) {
            Object newFieldValue;
            if (fieldValue instanceof GenericRecord) {
                GenericRecord record = (GenericRecord)fieldValue;
                newFieldValue = HiveAvroSerializer.rewriteRecordIgnoreResultCheck(record, AvroSchemaUtils.resolveUnionSchema(field.schema(), record.getSchema().getFullName()));
            } else {
                newFieldValue = fieldValue;
            }
            newRecord.put(field.name(), newFieldValue);
        } else if (field.defaultVal() instanceof JsonProperties.Null) {
            newRecord.put(field.name(), null);
        } else {
            newRecord.put(field.name(), field.defaultVal());
        }
    }
}

