/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataBloomFilter;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieMetadataFileInfo;
import org.apache.hudi.avro.model.HoodieRecordIndexInfo;
import org.apache.hudi.avro.model.HoodieSecondaryIndexInfo;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;

public enum MetadataPartitionType {
    FILES("files", "files-", 2){

        @Override
        public boolean isMetadataPartitionEnabled(HoodieMetadataConfig metadataConfig) {
            return metadataConfig.isEnabled();
        }

        @Override
        public void constructMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
            MetadataPartitionType.constructFilesMetadataPayload(payload, record);
        }

        @Override
        public HoodieMetadataPayload combineMetadataPayloads(HoodieMetadataPayload older, HoodieMetadataPayload newer) {
            return new HoodieMetadataPayload(newer.key, newer.type, HoodieTableMetadataUtil.combineFileSystemMetadata(older, newer));
        }
    }
    ,
    COLUMN_STATS("column_stats", "col-stats-", 3){

        @Override
        public boolean isMetadataPartitionEnabled(HoodieMetadataConfig metadataConfig) {
            return metadataConfig.isColumnStatsIndexEnabled();
        }

        @Override
        public void constructMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
            MetadataPartitionType.constructColumnStatsMetadataPayload(payload, record);
        }

        @Override
        public HoodieMetadataPayload combineMetadataPayloads(HoodieMetadataPayload older, HoodieMetadataPayload newer) {
            ValidationUtils.checkArgument(older.getColumnStatMetadata().isPresent());
            ValidationUtils.checkArgument(newer.getColumnStatMetadata().isPresent());
            HoodieMetadataColumnStats previousColStatsRecord = older.getColumnStatMetadata().get();
            HoodieMetadataColumnStats newColumnStatsRecord = newer.getColumnStatMetadata().get();
            return new HoodieMetadataPayload(newer.key, HoodieTableMetadataUtil.mergeColumnStatsRecords(previousColStatsRecord, newColumnStatsRecord), this.getRecordType());
        }
    }
    ,
    BLOOM_FILTERS("bloom_filters", "bloom-filters-", 4){

        @Override
        public boolean isMetadataPartitionEnabled(HoodieMetadataConfig metadataConfig) {
            return metadataConfig.isBloomFilterIndexEnabled();
        }

        @Override
        public void constructMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
            GenericRecord bloomFilterRecord = (GenericRecord)MetadataPartitionType.getNestedFieldValue(record, "BloomFilterMetadata");
            if (bloomFilterRecord == null) {
                ValidationUtils.checkArgument(record.getSchema().getField("BloomFilterMetadata") == null, String.format("Valid %s record expected for type: %s", "BloomFilterMetadata", BLOOM_FILTERS.getRecordType()));
            } else {
                payload.bloomFilterMetadata = new HoodieMetadataBloomFilter((String)bloomFilterRecord.get("type"), (String)bloomFilterRecord.get("timestamp"), (ByteBuffer)bloomFilterRecord.get("bloomFilter"), (Boolean)bloomFilterRecord.get("isDeleted"));
            }
        }

        @Override
        public HoodieMetadataPayload combineMetadataPayloads(HoodieMetadataPayload older, HoodieMetadataPayload newer) {
            return new HoodieMetadataPayload(newer.key, newer.bloomFilterMetadata);
        }
    }
    ,
    RECORD_INDEX("record_index", "record-index-", 5){

        @Override
        public boolean isMetadataPartitionEnabled(HoodieMetadataConfig metadataConfig) {
            return metadataConfig.isRecordIndexEnabled();
        }

        @Override
        public void constructMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
            GenericRecord recordIndexRecord = (GenericRecord)MetadataPartitionType.getNestedFieldValue(record, "recordIndexMetadata");
            Object recordIndexPosition = null;
            if (recordIndexRecord.hasField("position")) {
                recordIndexPosition = recordIndexRecord.get("position");
            }
            payload.recordIndexMetadata = new HoodieRecordIndexInfo(recordIndexRecord.get("partitionName").toString(), Long.parseLong(recordIndexRecord.get("fileIdHighBits").toString()), Long.parseLong(recordIndexRecord.get("fileIdLowBits").toString()), Integer.parseInt(recordIndexRecord.get("fileIndex").toString()), recordIndexRecord.get("fileId").toString(), Long.parseLong(recordIndexRecord.get("instantTime").toString()), Integer.parseInt(recordIndexRecord.get("fileIdEncoding").toString()), recordIndexPosition != null ? Long.valueOf(Long.parseLong(recordIndexPosition.toString())) : null);
        }
    }
    ,
    EXPRESSION_INDEX("expr_index_", "expr-index-", -1){

        @Override
        public boolean isMetadataPartitionEnabled(HoodieMetadataConfig metadataConfig) {
            return metadataConfig.isExpressionIndexEnabled();
        }

        @Override
        public boolean isMetadataPartitionAvailable(HoodieTableMetaClient metaClient) {
            if (metaClient.getIndexMetadata().isPresent()) {
                return metaClient.getIndexMetadata().get().getIndexDefinitions().values().stream().anyMatch(indexDef -> indexDef.getIndexName().startsWith("expr_index_"));
            }
            return false;
        }

        @Override
        public String getPartitionPath(HoodieTableMetaClient metaClient, String indexName) {
            ValidationUtils.checkArgument(metaClient.getIndexMetadata().isPresent(), "Index definition is not present for index: " + indexName);
            return metaClient.getIndexMetadata().get().getIndexDefinitions().get(indexName).getIndexName();
        }
    }
    ,
    SECONDARY_INDEX("secondary_index_", "secondary-index-", 7){

        @Override
        public boolean isMetadataPartitionEnabled(HoodieMetadataConfig metadataConfig) {
            return metadataConfig.isSecondaryIndexEnabled();
        }

        @Override
        public boolean isMetadataPartitionAvailable(HoodieTableMetaClient metaClient) {
            if (metaClient.getIndexMetadata().isPresent()) {
                return metaClient.getIndexMetadata().get().getIndexDefinitions().values().stream().anyMatch(indexDef -> indexDef.getIndexName().startsWith("secondary_index_"));
            }
            return false;
        }

        @Override
        public void constructMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
            GenericRecord secondaryIndexRecord = (GenericRecord)MetadataPartitionType.getNestedFieldValue(record, "SecondaryIndexMetadata");
            ValidationUtils.checkState(secondaryIndexRecord != null, "Valid SecondaryIndexMetadata record expected for type: " + SECONDARY_INDEX.getRecordType());
            payload.secondaryIndexMetadata = new HoodieSecondaryIndexInfo((Boolean)secondaryIndexRecord.get("isDeleted"));
        }

        @Override
        public String getPartitionPath(HoodieTableMetaClient metaClient, String indexName) {
            ValidationUtils.checkArgument(metaClient.getIndexMetadata().isPresent(), "Index definition is not present for index: " + indexName);
            return metaClient.getIndexMetadata().get().getIndexDefinitions().get(indexName).getIndexName();
        }
    }
    ,
    PARTITION_STATS("partition_stats", "partition-stats-", 6){

        @Override
        public boolean isMetadataPartitionEnabled(HoodieMetadataConfig metadataConfig) {
            return metadataConfig.isPartitionStatsIndexEnabled();
        }

        @Override
        public void constructMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
            MetadataPartitionType.constructColumnStatsMetadataPayload(payload, record);
        }

        @Override
        public HoodieMetadataPayload combineMetadataPayloads(HoodieMetadataPayload older, HoodieMetadataPayload newer) {
            ValidationUtils.checkArgument(older.getColumnStatMetadata().isPresent());
            ValidationUtils.checkArgument(newer.getColumnStatMetadata().isPresent());
            HoodieMetadataColumnStats previousColStatsRecord = older.getColumnStatMetadata().get();
            HoodieMetadataColumnStats newColumnStatsRecord = newer.getColumnStatMetadata().get();
            return new HoodieMetadataPayload(newer.key, HoodieTableMetadataUtil.mergeColumnStatsRecords(previousColStatsRecord, newColumnStatsRecord), this.getRecordType());
        }
    }
    ,
    ALL_PARTITIONS("files", "files-", 1){

        @Override
        public boolean isMetadataPartitionEnabled(HoodieMetadataConfig metadataConfig) {
            return metadataConfig.isEnabled();
        }

        @Override
        public void constructMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
            MetadataPartitionType.constructFilesMetadataPayload(payload, record);
        }

        @Override
        public HoodieMetadataPayload combineMetadataPayloads(HoodieMetadataPayload older, HoodieMetadataPayload newer) {
            return new HoodieMetadataPayload(newer.key, newer.type, HoodieTableMetadataUtil.combineFileSystemMetadata(older, newer));
        }
    };

    private final String partitionPath;
    private final String fileIdPrefix;
    private final int recordType;

    private static <T> T getNestedFieldValue(GenericRecord record, String fieldName) {
        if (record.getSchema().getField(fieldName) == null) {
            return null;
        }
        return TypeUtils.unsafeCast(record.get(fieldName));
    }

    private static void constructFilesMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
        Map metadata = (Map)MetadataPartitionType.getNestedFieldValue(record, "filesystemMetadata");
        if (metadata != null) {
            payload.filesystemMetadata = metadata;
            payload.filesystemMetadata.keySet().forEach(k -> {
                GenericRecord v = payload.filesystemMetadata.get(k);
                payload.filesystemMetadata.put((String)k, new HoodieMetadataFileInfo((Long)v.get("size"), (Boolean)v.get("isDeleted")));
            });
        }
    }

    private static void constructColumnStatsMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
        GenericRecord columnStatsRecord = (GenericRecord)MetadataPartitionType.getNestedFieldValue(record, "ColumnStatsMetadata");
        if (columnStatsRecord == null) {
            ValidationUtils.checkArgument(record.getSchema().getField("ColumnStatsMetadata") == null, String.format("Valid %s record expected for type: %s", "ColumnStatsMetadata", COLUMN_STATS.getRecordType()));
        } else {
            HoodieMetadataColumnStats.Builder columnStatsBuilder = HoodieMetadataColumnStats.newBuilder(HoodieMetadataPayload.METADATA_COLUMN_STATS_BUILDER_STUB.get()).setFileName(columnStatsRecord.get("fileName").toString()).setColumnName(columnStatsRecord.get("columnName").toString()).setMinValue(HoodieAvroUtils.wrapValueIntoAvro(HoodieAvroUtils.unwrapAvroValueWrapper(columnStatsRecord.get("minValue")))).setMaxValue(HoodieAvroUtils.wrapValueIntoAvro(HoodieAvroUtils.unwrapAvroValueWrapper(columnStatsRecord.get("maxValue")))).setValueCount((Long)columnStatsRecord.get("valueCount")).setNullCount((Long)columnStatsRecord.get("nullCount")).setTotalSize((Long)columnStatsRecord.get("totalSize")).setTotalUncompressedSize((Long)columnStatsRecord.get("totalUncompressedSize")).setIsDeleted((Boolean)columnStatsRecord.get("isDeleted"));
            if (columnStatsRecord.hasField("isTightBound")) {
                columnStatsBuilder.setIsTightBound((Boolean)columnStatsRecord.get("isTightBound"));
            }
            payload.columnStatMetadata = columnStatsBuilder.build();
        }
    }

    public String getIndexNameWithoutPrefix(HoodieIndexDefinition indexDefinition) {
        String indexName = indexDefinition.getIndexName();
        ValidationUtils.checkArgument(indexName.startsWith(this.partitionPath), String.format("Index Name %s does not start with partition path %s", indexName, this.partitionPath));
        if (indexDefinition.getIndexName().length() > this.partitionPath.length()) {
            return indexDefinition.getIndexName().substring(this.partitionPath.length());
        }
        return "";
    }

    public static boolean isExpressionOrSecondaryIndex(String metadataPartitionPath) {
        MetadataPartitionType partitionType = MetadataPartitionType.fromPartitionPath(metadataPartitionPath);
        return partitionType.equals((Object)SECONDARY_INDEX) || partitionType.equals((Object)EXPRESSION_INDEX);
    }

    public abstract boolean isMetadataPartitionEnabled(HoodieMetadataConfig var1);

    public boolean isMetadataPartitionAvailable(HoodieTableMetaClient metaClient) {
        return metaClient.getTableConfig().isMetadataPartitionAvailable(this);
    }

    private MetadataPartitionType(String partitionPath, String fileIdPrefix, int recordType) {
        this.partitionPath = partitionPath;
        this.fileIdPrefix = fileIdPrefix;
        this.recordType = recordType;
    }

    public String getPartitionPath(HoodieTableMetaClient metaClient, String indexName) {
        return this.partitionPath;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public String getFileIdPrefix() {
        return this.fileIdPrefix;
    }

    public int getRecordType() {
        return this.recordType;
    }

    public void constructMetadataPayload(HoodieMetadataPayload payload, GenericRecord record) {
        throw new UnsupportedOperationException("MetadataPayload construction not supported for partition type: " + (Object)((Object)this));
    }

    public HoodieMetadataPayload combineMetadataPayloads(HoodieMetadataPayload older, HoodieMetadataPayload newer) {
        return newer;
    }

    public static boolean shouldDeletePartitionOnRestore(String partitionPath) {
        return MetadataPartitionType.fromPartitionPath(partitionPath) != FILES && MetadataPartitionType.fromPartitionPath(partitionPath) != RECORD_INDEX;
    }

    public static MetadataPartitionType get(int type) {
        for (MetadataPartitionType partitionType : MetadataPartitionType.values()) {
            if (partitionType.getRecordType() != type) continue;
            return partitionType;
        }
        throw new IllegalArgumentException("No MetadataPartitionType for record type: " + type);
    }

    public static List<MetadataPartitionType> getMetadataPartitionsNeedingWriteStatusTracking() {
        return Collections.singletonList(RECORD_INDEX);
    }

    public static Set<String> getAllPartitionPaths() {
        return Arrays.stream(MetadataPartitionType.getValidValues()).map(MetadataPartitionType::getPartitionPath).collect(Collectors.toSet());
    }

    public static MetadataPartitionType[] getValidValues() {
        return EnumSet.complementOf(EnumSet.of(ALL_PARTITIONS)).toArray(new MetadataPartitionType[0]);
    }

    public static List<MetadataPartitionType> getEnabledPartitions(HoodieMetadataConfig dataMetadataConfig, HoodieTableMetaClient metaClient) {
        if (!dataMetadataConfig.isEnabled()) {
            return Collections.emptyList();
        }
        return Arrays.stream(MetadataPartitionType.getValidValues()).filter(partitionType -> partitionType.isMetadataPartitionEnabled(dataMetadataConfig) || partitionType.isMetadataPartitionAvailable(metaClient)).collect(Collectors.toList());
    }

    public static MetadataPartitionType fromPartitionPath(String partitionPath) {
        for (MetadataPartitionType partitionType : MetadataPartitionType.getValidValues()) {
            if (!partitionPath.equals(partitionType.getPartitionPath()) && !partitionPath.startsWith(partitionType.getPartitionPath())) continue;
            return partitionType;
        }
        throw new IllegalArgumentException("No MetadataPartitionType for partition path: " + partitionPath);
    }

    public static boolean isNewSecondaryIndexDefinitionRequired(HoodieMetadataConfig metadataConfig, HoodieTableMetaClient dataMetaClient) {
        String secondaryIndexColumn = metadataConfig.getSecondaryIndexColumn();
        if (StringUtils.isNullOrEmpty(secondaryIndexColumn)) {
            return false;
        }
        List<HoodieIndexDefinition> indexDefinitions = MetadataPartitionType.getIndexDefinitions(secondaryIndexColumn, "secondary_index", dataMetaClient);
        return indexDefinitions.isEmpty();
    }

    public static boolean isNewExpressionIndexDefinitionRequired(HoodieMetadataConfig metadataConfig, HoodieTableMetaClient dataMetaClient) {
        String expressionIndexColumn = metadataConfig.getExpressionIndexColumn();
        if (StringUtils.isNullOrEmpty(expressionIndexColumn)) {
            return false;
        }
        Map<String, String> expressionIndexOptions = metadataConfig.getExpressionIndexOptions();
        if (expressionIndexOptions.isEmpty()) {
            return false;
        }
        List<HoodieIndexDefinition> indexDefinitions = MetadataPartitionType.getIndexDefinitions(expressionIndexColumn, "expr_index", dataMetaClient);
        return indexDefinitions.isEmpty() || indexDefinitions.stream().noneMatch(indexDefinition -> indexDefinition.getIndexFunction().equals(expressionIndexOptions.get("expr")));
    }

    private static List<HoodieIndexDefinition> getIndexDefinitions(String indexType, String sourceField, HoodieTableMetaClient metaClient) {
        ArrayList<HoodieIndexDefinition> indexDefinitions = new ArrayList<HoodieIndexDefinition>();
        if (metaClient.getIndexMetadata().isPresent()) {
            metaClient.getIndexMetadata().get().getIndexDefinitions().values().stream().filter(indexDefinition -> indexDefinition.getSourceFields().contains(sourceField) && indexDefinition.getIndexType().equals(indexType)).forEach(indexDefinitions::add);
        }
        return indexDefinitions;
    }

    private static boolean isIndexDefinitionPresentForColumn(String indexedColumn, String indexType, HoodieTableMetaClient dataMetaClient) {
        return dataMetaClient.getIndexMetadata().isPresent() && dataMetaClient.getIndexMetadata().get().getIndexDefinitions().values().stream().anyMatch(indexDefinition -> indexDefinition.getSourceFields().contains(indexedColumn) && indexDefinition.getIndexType().equals(indexType));
    }

    public String toString() {
        return "Metadata partition {name: " + this.getPartitionPath() + ", prefix: " + this.getFileIdPrefix() + "}";
    }
}

