/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.io.IOException;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.testutils.NetworkTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.hive.HoodieHiveSyncClient;
import org.apache.hudi.hive.MultiPartKeysValueExtractor;
import org.apache.hudi.hive.NonPartitionedExtractor;
import org.apache.hudi.hive.ddl.HiveSyncMode;
import org.apache.hudi.hive.testutils.HiveTestUtil;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.model.PartitionEvent;
import org.apache.hudi.sync.common.util.ConfigUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHiveSyncTool {
    private static final List<Object> SYNC_MODES = Arrays.asList("hiveql", "hms", "jdbc");
    private HiveSyncTool hiveSyncTool;
    private HoodieHiveSyncClient hiveClient;

    private static Iterable<Object> syncMode() {
        return SYNC_MODES;
    }

    private static Iterable<Object[]> syncModeAndSchemaFromCommitMetadata() {
        ArrayList<Object[]> opts = new ArrayList<Object[]>();
        for (Object mode : SYNC_MODES) {
            opts.add(new Object[]{true, mode});
            opts.add(new Object[]{false, mode});
        }
        return opts;
    }

    @AfterAll
    public static void cleanUpClass() throws IOException {
        HiveTestUtil.shutdown();
    }

    private static Iterable<Object[]> syncModeAndSchemaFromCommitMetadataAndManagedTable() {
        ArrayList<Object[]> opts = new ArrayList<Object[]>();
        for (Object mode : SYNC_MODES) {
            opts.add(new Object[]{true, true, mode});
            opts.add(new Object[]{false, false, mode});
        }
        return opts;
    }

    private static Iterable<Object[]> syncDataSourceTableParams() {
        ArrayList<Object[]> opts = new ArrayList<Object[]>();
        for (Object mode : SYNC_MODES) {
            opts.add(new Object[]{true, true, mode});
            opts.add(new Object[]{false, false, mode});
        }
        return opts;
    }

    @BeforeEach
    public void setUp() throws Exception {
        HiveTestUtil.setUp();
    }

    @AfterEach
    public void teardown() throws Exception {
        HiveTestUtil.clear();
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadata"})
    public void testBasicSync(boolean useSchemaFromCommitMetadata, String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, useSchemaFromCommitMetadata);
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 1), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        List<String> newPartition = Arrays.asList("2050/01/01", "2040/02/01");
        this.hiveClient.addPartitionsToTable("test1", Collections.emptyList());
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"No new partition should be added");
        this.hiveClient.addPartitionsToTable("test1", newPartition);
        Assertions.assertEquals((int)7, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"New partition should be added");
        this.hiveClient.updatePartitionsToTable("test1", Collections.emptyList());
        Assertions.assertEquals((int)7, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Partition count should remain the same");
        this.hiveClient.updatePartitionsToTable("test1", newPartition);
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        Set relativePartitionPaths = hivePartitions.stream().map(p -> FSUtils.getRelativePartitionPath((Path)new Path(HiveTestUtil.basePath), (Path)new Path(p.getStorageLocation()))).collect(Collectors.toSet());
        Assertions.assertEquals((int)7, (int)hivePartitions.size(), (String)"Partition count should remain the same");
        Assertions.assertEquals((int)hivePartitions.size(), (int)relativePartitionPaths.size());
        Assertions.assertTrue((boolean)relativePartitionPaths.containsAll(newPartition));
        HiveTestUtil.ddlExecutor.runSQL("ALTER TABLE `test1` PARTITION (`datestr`='2050-01-01') SET LOCATION '/some/new/location'");
        hivePartitions = this.hiveClient.getAllPartitions("test1");
        List writtenPartitionsSince = this.hiveClient.getWrittenPartitionsSince(Option.empty());
        List partitionEvents = this.hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince, Collections.emptySet());
        Assertions.assertEquals((int)1, (int)partitionEvents.size(), (String)"There should be only one partition event");
        Assertions.assertEquals((Object)PartitionEvent.PartitionEventType.UPDATE, (Object)((PartitionEvent)partitionEvents.iterator().next()).eventType, (String)"The one partition event must of type UPDATE");
        this.reSyncHiveTable();
        List tablePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)7, (int)tablePartitions.size(), (String)"The one partition we wrote should be added to hive");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 100");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncDataBase(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "testdb");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key(), "false");
        this.reinitHiveSyncClient();
        Assertions.assertThrows(Exception.class, this::reSyncHiveTable);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key(), "true");
        this.reinitHiveSyncClient();
        Assertions.assertDoesNotThrow(this::reSyncHiveTable);
        Assertions.assertTrue((boolean)this.hiveClient.databaseExists("testdb"), (String)"DataBases testdb should exist after sync completes");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key(), "false");
        this.reinitHiveSyncClient();
        Assertions.assertDoesNotThrow(this::reSyncHiveTable);
        Assertions.assertTrue((boolean)this.hiveClient.databaseExists("testdb"), (String)"DataBases testdb should exist after sync completes");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key(), "true");
        Assertions.assertDoesNotThrow(this::reSyncHiveTable);
        Assertions.assertTrue((boolean)this.hiveClient.databaseExists("testdb"), (String)"DataBases testdb should exist after sync completes");
    }

    @ParameterizedTest
    @MethodSource(value={"syncDataSourceTableParams"})
    public void testSyncCOWTableWithProperties(boolean useSchemaFromCommitMetadata, boolean syncAsDataSourceTable, String syncMode) throws Exception {
        HashMap<String, String> serdeProperties = new HashMap<String, String>(){
            {
                this.put("path", HiveTestUtil.basePath);
            }
        };
        HashMap<String, String> tableProperties = new HashMap<String, String>(){
            {
                this.put("tp_0", "p0");
                this.put("tp_1", "p1");
            }
        };
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE.key(), String.valueOf(syncAsDataSourceTable));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_TABLE_SERDE_PROPERTIES.key(), ConfigUtils.configToString((Map)serdeProperties));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES.key(), ConfigUtils.configToString((Map)tableProperties));
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, useSchemaFromCommitMetadata);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        SessionState.start((HiveConf)HiveTestUtil.getHiveConf());
        Driver hiveDriver = new Driver(HiveTestUtil.getHiveConf());
        String dbTableName = "testdb.test1";
        hiveDriver.run("SHOW TBLPROPERTIES " + dbTableName);
        ArrayList results = new ArrayList();
        hiveDriver.getResults(results);
        String tblPropertiesWithoutDdlTime = String.join((CharSequence)"\n", results.subList(0, results.size() - 1));
        String sparkTableProperties = this.getSparkTableProperties(syncAsDataSourceTable, useSchemaFromCommitMetadata);
        Assertions.assertEquals((Object)("EXTERNAL\tTRUE\nlast_commit_time_sync\t100\n" + sparkTableProperties + "tp_0\tp0\ntp_1\tp1"), (Object)tblPropertiesWithoutDdlTime);
        Assertions.assertTrue((boolean)((String)results.get(results.size() - 1)).startsWith("transient_lastDdlTime"));
        results.clear();
        hiveDriver.run("SHOW CREATE TABLE " + dbTableName);
        hiveDriver.getResults(results);
        String ddl = String.join((CharSequence)"\n", results);
        Assertions.assertTrue((boolean)ddl.contains(String.format("ROW FORMAT SERDE \n  '%s'", ParquetHiveSerDe.class.getName())));
        Assertions.assertTrue((boolean)ddl.contains("'path'='" + HiveTestUtil.basePath + "'"));
        if (syncAsDataSourceTable) {
            Assertions.assertTrue((boolean)ddl.contains("'hoodie.query.as.ro.table'='false'"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSyncCOWTableWithCreateManagedTable(boolean createManagedTable) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), HiveSyncMode.HMS.name());
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE.key(), Boolean.toString(createManagedTable));
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        SessionState.start((HiveConf)HiveTestUtil.getHiveConf());
        Driver hiveDriver = new Driver(HiveTestUtil.getHiveConf());
        hiveDriver.run(String.format("SHOW TBLPROPERTIES %s.%s", "testdb", "test1"));
        ArrayList results = new ArrayList();
        hiveDriver.getResults(results);
        Assertions.assertEquals((Object)String.format("%slast_commit_time_sync\t%s\n%s", createManagedTable ? "" : "EXTERNAL\tTRUE\n", instantTime, this.getSparkTableProperties(true, true)), (Object)String.format("%s\n", String.join((CharSequence)"\n", results.subList(0, results.size() - 1))));
    }

    private String getSparkTableProperties(boolean syncAsDataSourceTable, boolean useSchemaFromCommitMetadata) {
        if (syncAsDataSourceTable) {
            if (useSchemaFromCommitMetadata) {
                return "spark.sql.sources.provider\thudi\nspark.sql.sources.schema.numPartCols\t1\nspark.sql.sources.schema.numParts\t1\nspark.sql.sources.schema.part.0\t{\"type\":\"struct\",\"fields\":[{\"name\":\"_hoodie_commit_time\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_commit_seqno\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_record_key\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_partition_path\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_file_name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"name\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}},{\"name\":\"favorite_number\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"favorite_color\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}},{\"name\":\"datestr\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}}]}\nspark.sql.sources.schema.partCol.0\tdatestr\n";
            }
            return "spark.sql.sources.provider\thudi\nspark.sql.sources.schema.numPartCols\t1\nspark.sql.sources.schema.numParts\t1\nspark.sql.sources.schema.part.0\t{\"type\":\"struct\",\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}},{\"name\":\"favorite_number\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"favorite_color\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}}]}\n{\"name\":\"datestr\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}}]}\nspark.sql.sources.schema.partCol.0\tdatestr\n";
        }
        return "";
    }

    @ParameterizedTest
    @MethodSource(value={"syncDataSourceTableParams"})
    public void testSyncMORTableWithProperties(boolean useSchemaFromCommitMetadata, boolean syncAsDataSourceTable, String syncMode) throws Exception {
        HashMap<String, String> serdeProperties = new HashMap<String, String>(){
            {
                this.put("path", HiveTestUtil.basePath);
            }
        };
        HashMap<String, String> tableProperties = new HashMap<String, String>(){
            {
                this.put("tp_0", "p0");
                this.put("tp_1", "p1");
            }
        };
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE.key(), String.valueOf(syncAsDataSourceTable));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_TABLE_SERDE_PROPERTIES.key(), ConfigUtils.configToString((Map)serdeProperties));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES.key(), ConfigUtils.configToString((Map)tableProperties));
        String instantTime = "100";
        String deltaCommitTime = "101";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, useSchemaFromCommitMetadata);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        String roTableName = "test1_ro";
        String rtTableName = "test1_rt";
        String[] tableNames = new String[]{roTableName, rtTableName};
        String[] readAsOptimizedResults = new String[]{"true", "false"};
        SessionState.start((HiveConf)HiveTestUtil.getHiveConf());
        Driver hiveDriver = new Driver(HiveTestUtil.getHiveConf());
        String sparkTableProperties = this.getSparkTableProperties(syncAsDataSourceTable, useSchemaFromCommitMetadata);
        for (int i = 0; i < 2; ++i) {
            String dbTableName = "testdb." + tableNames[i];
            String readAsOptimized = readAsOptimizedResults[i];
            hiveDriver.run("SHOW TBLPROPERTIES " + dbTableName);
            ArrayList results = new ArrayList();
            hiveDriver.getResults(results);
            String tblPropertiesWithoutDdlTime = String.join((CharSequence)"\n", results.subList(0, results.size() - 1));
            Assertions.assertEquals((Object)("EXTERNAL\tTRUE\nlast_commit_time_sync\t101\n" + sparkTableProperties + "tp_0\tp0\ntp_1\tp1"), (Object)tblPropertiesWithoutDdlTime);
            Assertions.assertTrue((boolean)((String)results.get(results.size() - 1)).startsWith("transient_lastDdlTime"));
            results.clear();
            hiveDriver.run("SHOW CREATE TABLE " + dbTableName);
            hiveDriver.getResults(results);
            String ddl = String.join((CharSequence)"\n", results);
            Assertions.assertTrue((boolean)ddl.contains(String.format("ROW FORMAT SERDE \n  '%s'", ParquetHiveSerDe.class.getName())));
            Assertions.assertTrue((boolean)ddl.contains("'path'='" + HiveTestUtil.basePath + "'"));
            Assertions.assertTrue((boolean)ddl.toLowerCase().contains("create external table"));
            if (!syncAsDataSourceTable) continue;
            Assertions.assertTrue((boolean)ddl.contains("'hoodie.query.as.ro.table'='" + readAsOptimized + "'"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadataAndManagedTable"})
    public void testSyncManagedTable(boolean useSchemaFromCommitMetadata, boolean isManagedTable, String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE.key(), String.valueOf(isManagedTable));
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, useSchemaFromCommitMetadata);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        SessionState.start((HiveConf)HiveTestUtil.getHiveConf());
        Driver hiveDriver = new Driver(HiveTestUtil.getHiveConf());
        String dbTableName = "testdb.test1";
        hiveDriver.run("SHOW TBLPROPERTIES " + dbTableName);
        ArrayList results = new ArrayList();
        hiveDriver.run("SHOW CREATE TABLE " + dbTableName);
        hiveDriver.getResults(results);
        String ddl = String.join((CharSequence)"\n", results).toLowerCase();
        if (isManagedTable) {
            Assertions.assertTrue((boolean)ddl.contains("create table"));
        } else {
            Assertions.assertTrue((boolean)ddl.contains("create external table"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncWithSchema(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        HiveTestUtil.createCOWTableWithSchema(commitTime, "/complex.schema.avsc");
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)1, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)commitTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncIncremental(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime1 = "100";
        HiveTestUtil.createCOWTable(commitTime1, 5, true);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)commitTime1, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(1, true, true, dateTime, commitTime2);
        this.reSyncHiveTable();
        List writtenPartitionsSince = this.hiveClient.getWrittenPartitionsSince(Option.of((Object)commitTime1));
        Assertions.assertEquals((int)1, (int)writtenPartitionsSince.size(), (String)"We should have one partition written after 100 commit");
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        List partitionEvents = this.hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince, Collections.emptySet());
        Assertions.assertEquals((int)1, (int)partitionEvents.size(), (String)"There should be only one partition event");
        Assertions.assertEquals((Object)PartitionEvent.PartitionEventType.ADD, (Object)((PartitionEvent)partitionEvents.iterator().next()).eventType, (String)"The one partition event must of type ADD");
        this.reSyncHiveTable();
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"The one partition we wrote should be added to hive");
        Assertions.assertEquals((Object)commitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 101");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncIncrementalWithSchemaEvolution(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime1 = "100";
        HiveTestUtil.createCOWTable(commitTime1, 5, true);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        int fields = this.hiveClient.getMetastoreSchema("test1").size();
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(1, false, true, dateTime, commitTime2);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)(fields + 3), (int)this.hiveClient.getMetastoreSchema("test1").size(), (String)"Hive Schema has evolved and should not be 3 more field");
        Assertions.assertEquals((Object)"BIGINT", this.hiveClient.getMetastoreSchema("test1").get("favorite_number"), (String)"Hive Schema has evolved - Field favorite_number has evolved from int to long");
        Assertions.assertTrue((boolean)this.hiveClient.getMetastoreSchema("test1").containsKey("favorite_movie"), (String)"Hive Schema has evolved - Field favorite_movie was added");
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"The one partition we wrote should be added to hive");
        Assertions.assertEquals((Object)commitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 101");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testUpdateTableComments(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        HiveTestUtil.createCOWTableWithSchema(commitTime, "/simple-test.avsc");
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        HashMap<String, ImmutablePair> alterCommentSchema = new HashMap<String, ImmutablePair>();
        Schema schema = SchemaTestUtil.getSchemaFromResource(HiveTestUtil.class, (String)"/simple-test.avsc");
        Schema commentedSchema = SchemaTestUtil.getSchemaFromResource(HiveTestUtil.class, (String)"/simple-test-doced.avsc");
        Map<String, String> fieldsNameAndDoc = commentedSchema.getFields().stream().collect(Collectors.toMap(field -> field.name().toLowerCase(Locale.ROOT), field -> StringUtils.isNullOrEmpty((String)field.doc()) ? "" : field.doc()));
        for (Schema.Field field2 : schema.getFields()) {
            String name = field2.name().toLowerCase(Locale.ROOT);
            String comment = fieldsNameAndDoc.get(name);
            if (!fieldsNameAndDoc.containsKey(name) || comment.equals(field2.doc())) continue;
            alterCommentSchema.put(name, new ImmutablePair((Object)field2.schema().getType().name(), (Object)comment));
        }
        HiveTestUtil.ddlExecutor.updateTableComments("test1", alterCommentSchema);
        List fieldSchemas = this.hiveClient.getMetastoreFieldSchemas("test1");
        int commentCnt = 0;
        for (FieldSchema fieldSchema : fieldSchemas) {
            if (!StringUtils.nonEmpty((String)fieldSchema.getCommentOrEmpty())) continue;
            ++commentCnt;
        }
        Assertions.assertEquals((int)2, (int)commentCnt, (String)"hive schema field comment numbers should match the avro schema field doc numbers");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncWithCommentedSchema(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_COMMENT.key(), "false");
        String commitTime = "100";
        HiveTestUtil.createCOWTableWithSchema(commitTime, "/simple-test-doced.avsc");
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        List fieldSchemas = this.hiveClient.getMetastoreFieldSchemas("test1");
        int commentCnt = 0;
        for (FieldSchema fieldSchema : fieldSchemas) {
            if (!StringUtils.nonEmpty((String)fieldSchema.getCommentOrEmpty())) continue;
            ++commentCnt;
        }
        Assertions.assertEquals((int)0, (int)commentCnt, (String)"hive schema field comment numbers should match the avro schema field doc numbers");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_COMMENT.key(), "true");
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        fieldSchemas = this.hiveClient.getMetastoreFieldSchemas("test1");
        commentCnt = 0;
        for (FieldSchema fieldSchema : fieldSchemas) {
            if (!StringUtils.nonEmpty((String)fieldSchema.getCommentOrEmpty())) continue;
            ++commentCnt;
        }
        Assertions.assertEquals((int)2, (int)commentCnt, (String)"hive schema field comment numbers should match the avro schema field doc numbers");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadata"})
    public void testSyncMergeOnRead(boolean useSchemaFromCommitMetadata, String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String instantTime = "100";
        String deltaCommitTime = "101";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, useSchemaFromCommitMetadata);
        String roTableName = "test1_ro";
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(roTableName), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(roTableName), (String)("Table " + roTableName + " should exist after sync completes"));
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(roTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        } else {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(roTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize()), (String)"Hive Schema should match the table schema + partition field");
        }
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions(roTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)deltaCommitTime, (Object)this.hiveClient.getLastCommitTimeSynced(roTableName).get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addCOWPartitions(1, true, useSchemaFromCommitMetadata, dateTime, commitTime2);
        HiveTestUtil.addMORPartitions(1, true, false, useSchemaFromCommitMetadata, dateTime, commitTime2, deltaCommitTime2);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(roTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        } else {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(roTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize()), (String)"Hive Schema should match the evolved table schema + partition field");
        }
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions(roTableName).size(), (String)"The 2 partitions we wrote should be added to hive");
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced(roTableName).get(), (String)"The last commit that was synced should be 103");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadata"})
    public void testSyncMergeOnReadRT(boolean useSchemaFromCommitMetadata, String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String instantTime = "100";
        String deltaCommitTime = "101";
        String snapshotTableName = "test1_rt";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, useSchemaFromCommitMetadata);
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should exist after sync completes");
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        } else {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize()), (String)"Hive Schema should match the table schema + partition field");
        }
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)deltaCommitTime, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addCOWPartitions(1, true, useSchemaFromCommitMetadata, dateTime, commitTime2);
        HiveTestUtil.addMORPartitions(1, true, false, useSchemaFromCommitMetadata, dateTime, commitTime2, deltaCommitTime2);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        } else {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize()), (String)"Hive Schema should match the evolved table schema + partition field");
        }
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"The 2 partitions we wrote should be added to hive");
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be 103");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testMultiPartitionKeySync(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), MultiPartKeysValueExtractor.class.getCanonicalName());
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "year,month,day");
        HiveTestUtil.getCreatedTablesSet().add("testdb.test1");
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 3), (String)"Hive Schema should match the table schema + partition fields");
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartition("2010/01/02", true, true, commitTime2);
        this.reinitHiveSyncClient();
        List writtenPartitionsSince = this.hiveClient.getWrittenPartitionsSince(Option.of((Object)instantTime));
        Assertions.assertEquals((int)1, (int)writtenPartitionsSince.size(), (String)"We should have one partition written after 100 commit");
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        List partitionEvents = this.hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince, Collections.emptySet());
        Assertions.assertEquals((int)1, (int)partitionEvents.size(), (String)"There should be only one partition event");
        Assertions.assertEquals((Object)PartitionEvent.PartitionEventType.ADD, (Object)((PartitionEvent)partitionEvents.iterator().next()).eventType, (String)"The one partition event must of type ADD");
        this.reSyncHiveTable();
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)commitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 101");
        String commitTime3 = "102";
        HiveTestUtil.addCOWPartition("2010/02/01", true, true, commitTime3);
        HiveTestUtil.getCreatedTablesSet().add("testdb.test1");
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 3), (String)"Hive Schema should match the table schema + partition fields");
        Assertions.assertEquals((int)7, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)commitTime3, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        Assertions.assertEquals((int)1, (int)this.hiveClient.getWrittenPartitionsSince(Option.of((Object)commitTime2)).size());
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testDropPartitionKeySync(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 1, true);
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 1), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)1, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        List<String> newPartition = Collections.singletonList("2050/01/01");
        this.hiveClient.addPartitionsToTable("test1", Collections.emptyList());
        Assertions.assertEquals((int)1, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"No new partition should be added");
        this.hiveClient.addPartitionsToTable("test1", newPartition);
        Assertions.assertEquals((int)2, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"New partition should be added");
        this.reSyncHiveTable();
        HiveTestUtil.ddlExecutor.runSQL("ALTER TABLE `test1` DROP PARTITION (`datestr`='2050-01-01')");
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)1, (int)hivePartitions.size(), (String)"Table should have 1 partition because of the drop 1 partition");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testDropPartition(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 1, true);
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 1), (String)"Hive Schema should match the table schema + partition field");
        List partitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)1, (int)partitions.size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        String instantTime2 = "101";
        String newPartition = "2010/02/01";
        HiveTestUtil.addCOWPartition(newPartition, true, true, instantTime2);
        HiveTestUtil.getCreatedTablesSet().add("testdb.test1");
        partitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)1, (int)partitions.size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        String partitiontoDelete = ((String)((Partition)partitions.get(0)).getValues().get(0)).replace("-", "/");
        String instantTime3 = "102";
        HiveTestUtil.createReplaceCommit(instantTime3, partitiontoDelete, WriteOperationType.DELETE_PARTITION, true, true);
        String instantTime4 = "103";
        HiveTestUtil.createReplaceCommit(instantTime4, newPartition, WriteOperationType.DELETE_PARTITION, true, true);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)0, (int)hivePartitions.size(), (String)"Table should have no partitions");
        Assertions.assertEquals((Object)instantTime4, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testNonPartitionedSync(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), NonPartitionedExtractor.class.getCanonicalName());
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "");
        HiveTestUtil.getCreatedTablesSet().add("testdb.test1");
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)this.hiveClient.getStorageSchema().getColumns().size(), (String)"Hive Schema should match the table schema\uff0cignoring the partition fields");
        Assertions.assertEquals((int)0, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table should not have partitions because of the NonPartitionedExtractor");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testReadSchemaForMOR(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        String snapshotTableName = "test1_rt";
        HiveTestUtil.createMORTable(commitTime, "", 5, false, true);
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addMORPartitions(1, true, false, true, dateTime, commitTime2, deltaCommitTime2);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"The 1 partition we wrote should be added to hive");
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be 103");
    }

    @Test
    public void testConnectExceptionIgnoreConfigSet() throws IOException, URISyntaxException {
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, false);
        this.reinitHiveSyncClient();
        HoodieHiveSyncClient prevHiveClient = this.hiveClient;
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_IGNORE_EXCEPTIONS.key(), "true");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_URL.key(), HiveTestUtil.hiveSyncProps.getString(HiveSyncConfigHolder.HIVE_URL.key()).replace(String.valueOf(HiveTestUtil.hiveTestService.getHiveServerPort()), String.valueOf(NetworkTestUtils.nextFreePort())));
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertNull((Object)this.hiveClient);
        Assertions.assertFalse((boolean)prevHiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
    }

    private void verifyOldParquetFileTest(HoodieHiveSyncClient hiveClient, String emptyCommitTime) throws Exception {
        Assertions.assertTrue((boolean)hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)hiveClient.getMetastoreSchema("test1").size(), (int)(hiveClient.getStorageSchema().getColumns().size() + 1), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)1, (int)hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)emptyCommitTime, (Object)hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        Schema schema = SchemaTestUtil.getSimpleSchema();
        for (Schema.Field field : schema.getFields()) {
            Assertions.assertEquals((Object)field.schema().getType().getName(), (Object)((String)hiveClient.getMetastoreSchema("test1").get(field.name())).toLowerCase(), (String)String.format("Hive Schema Field %s was added", field));
        }
        Assertions.assertEquals((Object)"string", (Object)((String)hiveClient.getMetastoreSchema("test1").get("datestr")).toLowerCase(), (String)"Hive Schema Field datestr was added");
        Assertions.assertEquals((int)(schema.getFields().size() + 1 + HoodieRecord.HOODIE_META_COLUMNS.size()), (int)hiveClient.getMetastoreSchema("test1").size(), (String)"Hive Schema fields size");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testPickingOlderParquetFileIfLatestIsEmptyCommit(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        HiveTestUtil.createCOWTable("100", 1, true);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        String emptyCommitTime = "200";
        HiveTestUtil.createCommitFileWithSchema(commitMetadata, "200", true);
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        this.verifyOldParquetFileTest(this.hiveClient, "200");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testNotPickingOlderParquetFileWhenLatestCommitReadFails(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        HiveTestUtil.createCOWTable("100", 1, true);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(1, false, true, dateTime, commitTime2);
        String emptyCommitTime = "200";
        HiveTestUtil.createCommitFile(commitMetadata, "200", HiveTestUtil.basePath);
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        HiveSyncTool tool = new HiveSyncTool((Properties)HiveTestUtil.hiveSyncProps, (Configuration)HiveTestUtil.getHiveConf());
        Path fullPath = new Path(HiveTestUtil.basePath + "/" + ".hoodie" + "/" + this.hiveClient.getActiveTimeline().getInstants().filter(inst -> inst.getTimestamp().equals(commitTime2)).findFirst().get().getFileName());
        Assertions.assertTrue((boolean)HiveTestUtil.fileSystem.delete(fullPath, false));
        try {
            tool.syncHoodieTable();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist at all");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testNotPickingOlderParquetFileWhenLatestCommitReadFailsForExistingTable(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        HiveTestUtil.createCOWTable("100", 1, true);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        String emptyCommitTime = "200";
        HiveTestUtil.createCommitFileWithSchema(commitMetadata, "200", true);
        this.reinitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        this.verifyOldParquetFileTest(this.hiveClient, "200");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "301";
        HiveTestUtil.addCOWPartitions(1, false, true, dateTime, commitTime2);
        this.reinitHiveSyncClient();
        Path fullPath = new Path(HiveTestUtil.basePath + "/" + ".hoodie" + "/" + this.hiveClient.getActiveTimeline().getInstants().filter(inst -> inst.getTimestamp().equals(commitTime2)).findFirst().get().getFileName());
        Assertions.assertTrue((boolean)HiveTestUtil.fileSystem.delete(fullPath, false));
        try {
            this.reSyncHiveTable();
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            this.reinitHiveSyncClient();
        }
        this.verifyOldParquetFileTest(this.hiveClient, "200");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testTypeConverter(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.createCOWTable("100", 5, true);
        HiveTestUtil.ddlExecutor.runSQL("create database testdb");
        this.reinitHiveSyncClient();
        String tableName = "test1";
        String tableAbsoluteName = String.format(" `%s.%s` ", "testdb", tableName);
        String dropTableSql = String.format("DROP TABLE IF EXISTS %s ", tableAbsoluteName);
        String createTableSqlPrefix = String.format("CREATE TABLE IF NOT EXISTS %s ", tableAbsoluteName);
        String errorMsg = "An error occurred in decimal type converting.";
        HiveTestUtil.ddlExecutor.runSQL(dropTableSql);
        String oneTargetColumnSql = createTableSqlPrefix + "(`decimal_col` DECIMAL(9,8), `bigint_col` BIGINT)";
        HiveTestUtil.ddlExecutor.runSQL(oneTargetColumnSql);
        System.out.println(this.hiveClient.getMetastoreSchema(tableName));
        Assertions.assertTrue((boolean)this.hiveClient.getMetastoreSchema(tableName).containsValue("DECIMAL(9,8)"), (String)errorMsg);
        HiveTestUtil.ddlExecutor.runSQL(dropTableSql);
        String multipleTargetColumnSql = createTableSqlPrefix + "(`decimal_col1` DECIMAL(9,8), `bigint_col` BIGINT, `decimal_col2` DECIMAL(7,4))";
        HiveTestUtil.ddlExecutor.runSQL(multipleTargetColumnSql);
        System.out.println(this.hiveClient.getMetastoreSchema(tableName));
        Assertions.assertTrue((this.hiveClient.getMetastoreSchema(tableName).containsValue("DECIMAL(9,8)") && this.hiveClient.getMetastoreSchema(tableName).containsValue("DECIMAL(7,4)") ? 1 : 0) != 0, (String)errorMsg);
        HiveTestUtil.ddlExecutor.runSQL(dropTableSql);
        String noTargetColumnsSql = createTableSqlPrefix + "(`bigint_col` BIGINT)";
        HiveTestUtil.ddlExecutor.runSQL(noTargetColumnsSql);
        System.out.println(this.hiveClient.getMetastoreSchema(tableName));
        Assertions.assertTrue((this.hiveClient.getMetastoreSchema(tableName).size() == 1 && this.hiveClient.getMetastoreSchema(tableName).containsValue("BIGINT") ? 1 : 0) != 0, (String)errorMsg);
        HiveTestUtil.ddlExecutor.runSQL(dropTableSql);
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncWithoutDiffs(String syncMode) throws Exception {
        String tableName = "test1_rt";
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_CONDITIONAL_SYNC.key(), "true");
        String commitTime0 = "100";
        String commitTime1 = "101";
        String commitTime2 = "102";
        HiveTestUtil.createMORTable(commitTime0, commitTime1, 2, true, true);
        this.reinitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(tableName));
        Assertions.assertEquals((Object)commitTime1, (Object)this.hiveClient.getLastCommitTimeSynced(tableName).get());
        HiveTestUtil.addMORPartitions(0, true, true, true, ZonedDateTime.now().plusDays(2L), commitTime1, commitTime2);
        this.reSyncHiveTable();
        Assertions.assertEquals((Object)commitTime1, (Object)this.hiveClient.getLastCommitTimeSynced(tableName).get());
    }

    private void reSyncHiveTable() {
        this.hiveSyncTool.syncHoodieTable();
        this.reinitHiveSyncClient();
    }

    private void reinitHiveSyncClient() {
        this.hiveSyncTool = new HiveSyncTool((Properties)HiveTestUtil.hiveSyncProps, (Configuration)HiveTestUtil.getHiveConf());
        this.hiveClient = (HoodieHiveSyncClient)this.hiveSyncTool.syncClient;
    }

    private int getPartitionFieldSize() {
        return HiveTestUtil.hiveSyncProps.getString(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key()).split(",").length;
    }
}

