/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.hudi.hive.HiveStylePartitionValueExtractor;
import org.apache.hudi.hive.SinglePartPartitionValueExtractor;
import org.apache.hudi.hive.SlashEncodedHourPartitionValueExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartitionValueExtractor {
    @Test
    public void testHourPartition() {
        SlashEncodedHourPartitionValueExtractor hourPartition = new SlashEncodedHourPartitionValueExtractor();
        ArrayList<String> list = new ArrayList<String>();
        list.add("2020-12-20-01");
        Assertions.assertEquals((Object)hourPartition.extractPartitionValuesInPath("2020/12/20/01"), list);
        Assertions.assertThrows(IllegalArgumentException.class, () -> hourPartition.extractPartitionValuesInPath("2020/12/20"));
        Assertions.assertEquals((Object)hourPartition.extractPartitionValuesInPath("update_time=2020/12/20/01"), list);
    }

    @Test
    public void testHiveStylePartition() {
        HiveStylePartitionValueExtractor hiveStylePartition = new HiveStylePartitionValueExtractor();
        ArrayList<String> list = new ArrayList<String>();
        list.add("2021-04-02");
        Assertions.assertEquals((Object)hiveStylePartition.extractPartitionValuesInPath("datestr=2021-04-02"), list);
        Assertions.assertThrows(IllegalArgumentException.class, () -> hiveStylePartition.extractPartitionValuesInPath("2021/04/02"));
    }

    @Test
    public void testSinglePartPartition() {
        SinglePartPartitionValueExtractor extractor = new SinglePartPartitionValueExtractor();
        Assertions.assertEquals(Collections.singletonList("202210-01-20"), (Object)extractor.extractPartitionValuesInPath("202210/01/20"));
    }
}

