/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.hive.util.HiveSchemaUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveSchemaUtil {
    @Test
    public void testSchemaConvertArray() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().optional(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("list")).named("int_list")).named("ArrayOfInts");
        String schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`int_list` ARRAY< int>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().requiredGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("list")).named("element")).named("list")).named("int_list_list")).named("ArrayOfArrayOfInts");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`int_list_list` ARRAY< ARRAY< int>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeated(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("int_list")).named("ArrayOfInts");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`int_list` ARRAY< int>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).required(PrimitiveType.PrimitiveTypeName.INT32).named("num")).named("element")).named("tuple_list")).named("ArrayOfTuples");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`tuple_list` ARRAY< STRUCT< `str` : binary, `num` : int>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).named("array")).named("one_tuple_list")).named("ArrayOfOneTuples");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`one_tuple_list` ARRAY< STRUCT< `str` : binary>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).named("one_tuple_list_tuple")).named("one_tuple_list")).named("ArrayOfOneTuples2");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`one_tuple_list` ARRAY< STRUCT< `str` : binary>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).named("one_tuple_list")).named("one_tuple_list")).named("ArrayOfOneTuples3");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`one_tuple_list` ARRAY< binary>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().as(OriginalType.MAP)).repeatedGroup().as(OriginalType.MAP_KEY_VALUE)).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("string_key")).required(PrimitiveType.PrimitiveTypeName.INT32).named("int_value")).named("key_value")).named("array")).named("map_list")).named("ArrayOfMaps");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`map_list` ARRAY< MAP< string, int>>", (Object)schemaString);
    }

    @Test
    public void testSchemaConvertTimestampMicros() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().optional(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.TIMESTAMP_MICROS)).named("my_element")).named("my_timestamp");
        String schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`my_element` bigint", (Object)schemaString);
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema, Collections.emptyList(), (boolean)true);
        Assertions.assertEquals((Object)"`my_element` TIMESTAMP", (Object)schemaString);
    }

    @Test
    public void testSchemaDiffForTimestampMicros() {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().optional(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.TIMESTAMP_MICROS)).named("my_element")).named("my_timestamp");
        SchemaDifference schemaDifference = HiveSchemaUtil.getSchemaDifference((MessageType)schema, Collections.emptyMap(), Collections.emptyList(), (boolean)false);
        Assertions.assertEquals((Object)"bigint", schemaDifference.getAddColumnTypes().get("`my_element`"));
        schemaDifference = HiveSchemaUtil.getSchemaDifference((MessageType)schema, (Map)schemaDifference.getAddColumnTypes(), Collections.emptyList(), (boolean)false);
        Assertions.assertTrue((boolean)schemaDifference.isEmpty());
        schemaDifference = HiveSchemaUtil.getSchemaDifference((MessageType)schema, Collections.emptyMap(), Collections.emptyList(), (boolean)true);
        Assertions.assertEquals((Object)"TIMESTAMP", schemaDifference.getAddColumnTypes().get("`my_element`"));
        schemaDifference = HiveSchemaUtil.getSchemaDifference((MessageType)schema, (Map)schemaDifference.getAddColumnTypes(), Collections.emptyList(), (boolean)true);
        Assertions.assertTrue((boolean)schemaDifference.isEmpty());
    }
}

