/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import com.beust.jcommander.JCommander;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveSyncToolArgs {
    @Test
    public void testArgsParse() {
        HiveSyncConfig.HiveSyncConfigParams params = new HiveSyncConfig.HiveSyncConfigParams();
        JCommander cmd = JCommander.newBuilder().addObject((Object)params).build();
        String[] args = new String[]{"--sync-mode", "hms", "--base-path", "/table_path", "--table", "table_name", "--spark-datasource"};
        cmd.parse(args);
        TypedProperties props = params.toProps();
        Assertions.assertEquals((Object)"hms", (Object)props.getProperty(HiveSyncConfig.HIVE_SYNC_MODE.key()));
        Assertions.assertEquals((Object)"/table_path", (Object)props.getProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key()));
        Assertions.assertEquals((Object)"table_name", (Object)props.getProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key()));
        Assertions.assertTrue((boolean)props.getBoolean(HiveSyncConfig.HIVE_SYNC_AS_DATA_SOURCE_TABLE.key()), (String)"should be true because present in args");
        Assertions.assertFalse((boolean)props.contains((Object)HiveSyncConfig.HIVE_USE_JDBC.key()), (String)"should be not present due to not in args");
        Assertions.assertFalse((boolean)props.contains((Object)HiveSyncConfig.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE.key()), (String)"should be not present due to not in args");
    }
}

