/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.functional;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.hive.testutils.HiveSyncFunctionalTestHarness;
import org.apache.hudi.hive.transaction.lock.HiveMetastoreBasedLockProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestHiveMetastoreBasedLockProvider
extends HiveSyncFunctionalTestHarness {
    private static final String TEST_DB_NAME = "testdb";
    private static final String TEST_TABLE_NAME = "testtable";
    private LockComponent lockComponent = new LockComponent(LockType.EXCLUSIVE, LockLevel.TABLE, "testdb");
    private LockConfiguration lockConfiguration;

    @BeforeEach
    public void init() throws Exception {
        TypedProperties properties = new TypedProperties();
        properties.setProperty("hoodie.write.lock.hivemetastore.database", TEST_DB_NAME);
        properties.setProperty("hoodie.write.lock.hivemetastore.table", TEST_TABLE_NAME);
        properties.setProperty("hoodie.write.lock.num_retries", LockConfiguration.DEFAULT_LOCK_ACQUIRE_NUM_RETRIES);
        properties.setProperty("hoodie.write.lock.wait_time_ms_between_retry", LockConfiguration.DEFAULT_LOCK_ACQUIRE_RETRY_WAIT_TIME_IN_MILLIS);
        properties.setProperty("hoodie.write.lock.zookeeper.url", this.zkService().connectString());
        properties.setProperty("hoodie.write.lock.zookeeper.port", this.hiveConf().get("hive.zookeeper.client.port"));
        properties.setProperty("hoodie.write.lock.zookeeper.session_timeout_ms", this.hiveConf().get("hive.zookeeper.session.timeout"));
        properties.setProperty("hoodie.write.lock.zookeeper.connection_timeout_ms", String.valueOf(15000));
        properties.setProperty("hoodie.write.lock.wait_time_ms", String.valueOf(1000));
        this.lockConfiguration = new LockConfiguration((Properties)properties);
        this.lockComponent.setTablename(TEST_TABLE_NAME);
    }

    @Test
    public void testAcquireLock() throws Exception {
        HiveMetastoreBasedLockProvider lockProvider = new HiveMetastoreBasedLockProvider(this.lockConfiguration, (Configuration)this.hiveConf());
        this.lockComponent.setOperationType(DataOperationType.NO_TXN);
        Assertions.assertTrue((boolean)lockProvider.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent));
        try {
            Assertions.assertTrue((boolean)lockProvider.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent));
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        lockProvider.unlock();
        Assertions.assertTrue((boolean)lockProvider.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent));
        lockProvider.close();
    }

    @Test
    public void testUnlock() throws Exception {
        HiveMetastoreBasedLockProvider lockProvider = new HiveMetastoreBasedLockProvider(this.lockConfiguration, (Configuration)this.hiveConf());
        this.lockComponent.setOperationType(DataOperationType.NO_TXN);
        Assertions.assertTrue((boolean)lockProvider.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent));
        lockProvider.unlock();
        Assertions.assertTrue((boolean)lockProvider.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent));
        lockProvider.close();
    }

    @Test
    public void testReentrantLock() throws Exception {
        HiveMetastoreBasedLockProvider lockProvider = new HiveMetastoreBasedLockProvider(this.lockConfiguration, (Configuration)this.hiveConf());
        this.lockComponent.setOperationType(DataOperationType.NO_TXN);
        Assertions.assertTrue((boolean)lockProvider.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent));
        try {
            lockProvider.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        lockProvider.unlock();
        HiveMetastoreBasedLockProvider lockProvider1 = new HiveMetastoreBasedLockProvider(this.lockConfiguration, (Configuration)this.hiveConf());
        HiveMetastoreBasedLockProvider lockProvider2 = new HiveMetastoreBasedLockProvider(this.lockConfiguration, (Configuration)this.hiveConf());
        this.lockComponent.setOperationType(DataOperationType.NO_TXN);
        Assertions.assertTrue((boolean)lockProvider1.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent));
        try {
            boolean acquireStatus = lockProvider2.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent);
            Assertions.assertFalse((boolean)acquireStatus);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        lockProvider1.unlock();
        Assertions.assertTrue((boolean)lockProvider2.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent));
        lockProvider2.unlock();
        lockProvider.close();
        lockProvider1.close();
        lockProvider2.close();
    }

    @Test
    public void testWaitingLock() throws Exception {
        HiveMetastoreBasedLockProvider lockProvider1 = new HiveMetastoreBasedLockProvider(this.lockConfiguration, (Configuration)this.hiveConf());
        HiveMetastoreBasedLockProvider lockProvider2 = new HiveMetastoreBasedLockProvider(this.lockConfiguration, (Configuration)this.hiveConf());
        this.lockComponent.setOperationType(DataOperationType.NO_TXN);
        Assertions.assertTrue((boolean)lockProvider1.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent));
        try {
            boolean acquireStatus = lockProvider2.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent);
            Assertions.assertFalse((boolean)acquireStatus);
        }
        catch (IllegalArgumentException acquireStatus) {
            // empty catch block
        }
        lockProvider1.unlock();
        HiveMetastoreBasedLockProvider lockProvider3 = new HiveMetastoreBasedLockProvider(this.lockConfiguration, (Configuration)this.hiveConf());
        boolean acquireStatus = lockProvider3.acquireLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS, this.lockComponent);
        Assertions.assertTrue((boolean)acquireStatus);
        lockProvider3.unlock();
        lockProvider1.close();
        lockProvider2.close();
        lockProvider3.close();
    }

    @Test
    public void testUnlockWithoutLock() {
        HiveMetastoreBasedLockProvider lockProvider = new HiveMetastoreBasedLockProvider(this.lockConfiguration, (Configuration)this.hiveConf());
        this.lockComponent.setOperationType(DataOperationType.NO_TXN);
        lockProvider.unlock();
    }
}

