/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import org.apache.hadoop.fs.Path;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor;
import org.apache.hudi.hive.replication.GlobalHiveSyncConfig;
import org.apache.hudi.hive.replication.HiveSyncGlobalCommitParams;
import org.apache.hudi.hive.replication.HiveSyncGlobalCommitTool;
import org.apache.hudi.hive.replication.ReplicationStateSync;
import org.apache.hudi.hive.testutils.HiveTestCluster;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestHiveSyncGlobalCommitTool {
    @RegisterExtension
    public static HiveTestCluster localCluster = new HiveTestCluster();
    @RegisterExtension
    public static HiveTestCluster remoteCluster = new HiveTestCluster();
    private static final String DB_NAME = "foo";
    private static final String TBL_NAME = "bar";

    private HiveSyncGlobalCommitParams getGlobalCommitConfig(String commitTime) throws Exception {
        HiveSyncGlobalCommitParams params = new HiveSyncGlobalCommitParams();
        params.loadedProps.setProperty(HiveSyncGlobalCommitParams.LOCAL_HIVE_SITE_URI, localCluster.getHiveSiteXmlLocation());
        params.loadedProps.setProperty(HiveSyncGlobalCommitParams.REMOTE_HIVE_SITE_URI, remoteCluster.getHiveSiteXmlLocation());
        params.loadedProps.setProperty(HiveSyncGlobalCommitParams.LOCAL_HIVE_SERVER_JDBC_URLS, localCluster.getHiveJdBcUrl());
        params.loadedProps.setProperty(HiveSyncGlobalCommitParams.REMOTE_HIVE_SERVER_JDBC_URLS, remoteCluster.getHiveJdBcUrl());
        params.loadedProps.setProperty(HiveSyncGlobalCommitParams.LOCAL_BASE_PATH, localCluster.tablePath(DB_NAME, TBL_NAME));
        params.loadedProps.setProperty(HiveSyncGlobalCommitParams.REMOTE_BASE_PATH, remoteCluster.tablePath(DB_NAME, TBL_NAME));
        params.loadedProps.setProperty(GlobalHiveSyncConfig.META_SYNC_GLOBAL_REPLICATE_TIMESTAMP.key(), commitTime);
        params.loadedProps.setProperty(HiveSyncConfigHolder.HIVE_USER.key(), System.getProperty("user.name"));
        params.loadedProps.setProperty(HiveSyncConfigHolder.HIVE_PASS.key(), "");
        params.loadedProps.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), DB_NAME);
        params.loadedProps.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), TBL_NAME);
        params.loadedProps.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), localCluster.tablePath(DB_NAME, TBL_NAME));
        params.loadedProps.setProperty(HoodieSyncConfig.META_SYNC_ASSUME_DATE_PARTITION.key(), "true");
        params.loadedProps.setProperty(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT.key(), "false");
        params.loadedProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "datestr");
        params.loadedProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), SlashEncodedDayPartitionValueExtractor.class.getName());
        return params;
    }

    private void compareEqualLastReplicatedTimeStamp(HiveSyncGlobalCommitParams config) throws Exception {
        Assertions.assertEquals(localCluster.getHMSClient().getTable(DB_NAME, TBL_NAME).getParameters().get("last_replication_timestamp"), remoteCluster.getHMSClient().getTable(DB_NAME, TBL_NAME).getParameters().get("last_replication_timestamp"), (String)"compare replicated timestamps");
    }

    @BeforeEach
    public void setUp() throws Exception {
        localCluster.forceCreateDb(DB_NAME);
        remoteCluster.forceCreateDb(DB_NAME);
        TestHiveSyncGlobalCommitTool.localCluster.dfsCluster.getFileSystem().delete(new Path(localCluster.tablePath(DB_NAME, TBL_NAME)), true);
        TestHiveSyncGlobalCommitTool.remoteCluster.dfsCluster.getFileSystem().delete(new Path(remoteCluster.tablePath(DB_NAME, TBL_NAME)), true);
    }

    @AfterEach
    public void clear() throws Exception {
        localCluster.getHMSClient().dropTable(DB_NAME, TBL_NAME);
        remoteCluster.getHMSClient().dropTable(DB_NAME, TBL_NAME);
    }

    @Test
    public void testHiveConfigShouldMatchClusterConf() throws Exception {
        String commitTime = "100";
        localCluster.createCOWTable(commitTime, 5, DB_NAME, TBL_NAME);
        remoteCluster.createCOWTable(commitTime, 5, DB_NAME, TBL_NAME);
        HiveSyncGlobalCommitParams params = this.getGlobalCommitConfig(commitTime);
        HiveSyncGlobalCommitTool tool = new HiveSyncGlobalCommitTool(params);
        ReplicationStateSync localReplicationStateSync = tool.getReplicatedState(false);
        ReplicationStateSync remoteReplicationStateSync = tool.getReplicatedState(true);
        Assertions.assertEquals((Object)localReplicationStateSync.globalHiveSyncTool.config.getHiveConf().get("hive.metastore.uris"), (Object)localCluster.getHiveConf().get("hive.metastore.uris"));
        Assertions.assertEquals((Object)remoteReplicationStateSync.globalHiveSyncTool.config.getHiveConf().get("hive.metastore.uris"), (Object)remoteCluster.getHiveConf().get("hive.metastore.uris"));
    }

    @Test
    public void testBasicGlobalCommit() throws Exception {
        String commitTime = "100";
        localCluster.createCOWTable(commitTime, 5, DB_NAME, TBL_NAME);
        remoteCluster.createCOWTable(commitTime, 5, DB_NAME, TBL_NAME);
        HiveSyncGlobalCommitParams params = this.getGlobalCommitConfig(commitTime);
        HiveSyncGlobalCommitTool tool = new HiveSyncGlobalCommitTool(params);
        Assertions.assertTrue((boolean)tool.commit());
        this.compareEqualLastReplicatedTimeStamp(params);
    }

    @Test
    public void testBasicRollback() throws Exception {
        String commitTime = "100";
        localCluster.createCOWTable(commitTime, 5, DB_NAME, TBL_NAME);
        remoteCluster.createCOWTable(commitTime, 5, DB_NAME, TBL_NAME);
        HiveSyncGlobalCommitParams params = this.getGlobalCommitConfig(commitTime);
        HiveSyncGlobalCommitTool tool = new HiveSyncGlobalCommitTool(params);
        Assertions.assertFalse((boolean)localCluster.getHMSClient().tableExists(DB_NAME, TBL_NAME));
        Assertions.assertFalse((boolean)remoteCluster.getHMSClient().tableExists(DB_NAME, TBL_NAME));
        remoteCluster.stopHiveServer2();
        Assertions.assertFalse((boolean)tool.commit());
        Assertions.assertEquals((Object)commitTime, localCluster.getHMSClient().getTable(DB_NAME, TBL_NAME).getParameters().get("last_replication_timestamp"));
        Assertions.assertTrue((boolean)tool.rollback());
        Assertions.assertNotEquals((Object)commitTime, localCluster.getHMSClient().getTable(DB_NAME, TBL_NAME).getParameters().get("last_replication_timestamp"));
        Assertions.assertFalse((boolean)remoteCluster.getHMSClient().tableExists(DB_NAME, TBL_NAME));
        remoteCluster.startHiveServer2();
    }
}

