/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.testutils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.minicluster.ZookeeperTestService;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor;
import org.apache.hudi.hive.ddl.HiveQueryDDLExecutor;
import org.apache.hudi.hive.ddl.QueryBasedDDLExecutor;
import org.apache.hudi.hive.testutils.HiveTestService;
import org.apache.hudi.hive.util.IMetaStoreClientUtil;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.junit.jupiter.api.Assertions;
import org.junit.platform.commons.JUnitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTestUtil.class);
    public static final String DB_NAME = "testdb";
    public static final String TABLE_NAME = "test1";
    public static String basePath;
    public static TypedProperties hiveSyncProps;
    public static HiveTestService hiveTestService;
    public static FileSystem fileSystem;
    public static QueryBasedDDLExecutor ddlExecutor;
    private static ZooKeeperServer zkServer;
    private static HiveServer2 hiveServer;
    private static ZookeeperTestService zkService;
    private static Configuration configuration;
    public static HiveSyncConfig hiveSyncConfig;
    private static DateTimeFormatter dtfOut;
    private static Set<String> createdTablesSet;

    public static void setUp() throws IOException, InterruptedException, HiveException, MetaException {
        configuration = new Configuration();
        if (zkServer == null) {
            zkService = new ZookeeperTestService(configuration);
            zkServer = zkService.start();
        }
        if (hiveServer == null) {
            hiveTestService = new HiveTestService(configuration);
            hiveServer = hiveTestService.start();
        }
        basePath = Files.createTempDirectory("hivesynctest" + Instant.now().toEpochMilli(), new FileAttribute[0]).toUri().toString();
        hiveSyncProps = new TypedProperties();
        hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_URL.key(), hiveTestService.getJdbcHive2Url());
        hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_USER.key(), "");
        hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_PASS.key(), "");
        hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), DB_NAME);
        hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), TABLE_NAME);
        hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), basePath);
        hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_ASSUME_DATE_PARTITION.key(), "true");
        hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT.key(), "false");
        hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "datestr");
        hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), SlashEncodedDayPartitionValueExtractor.class.getName());
        hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_BATCH_SYNC_PARTITION_NUM.key(), "3");
        hiveSyncConfig = new HiveSyncConfig((Properties)hiveSyncProps, (Configuration)hiveTestService.getHiveConf());
        fileSystem = hiveSyncConfig.getHadoopFileSystem();
        dtfOut = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        ddlExecutor = new HiveQueryDDLExecutor(hiveSyncConfig, IMetaStoreClientUtil.getMSC((HiveConf)hiveSyncConfig.getHiveConf()));
        HiveTestUtil.clear();
    }

    public static void clear() throws IOException, HiveException, MetaException {
        fileSystem.delete(new Path(basePath), true);
        HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(TABLE_NAME).setPayloadClass(HoodieAvroPayload.class).initTable(configuration, basePath);
        for (String tableName : createdTablesSet) {
            ddlExecutor.runSQL("drop table if exists " + tableName);
        }
        createdTablesSet.clear();
        ddlExecutor.runSQL("drop database if exists testdb cascade");
    }

    public static HiveConf getHiveConf() {
        return hiveServer.getHiveConf();
    }

    public static void shutdown() throws IOException {
        if (hiveServer != null) {
            hiveServer.stop();
        }
        if (hiveTestService != null) {
            hiveTestService.stop();
        }
        if (zkServer != null) {
            zkServer.shutdown(true);
        }
        if (fileSystem != null) {
            fileSystem.close();
        }
    }

    public static void createCOWTable(String instantTime, int numberOfPartitions, boolean useSchemaFromCommitMetadata, String basePath, String databaseName, String tableName) throws IOException, URISyntaxException {
        Path path = new Path(basePath);
        if (fileSystem.exists(path)) {
            fileSystem.delete(path, true);
        }
        HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(tableName).setPayloadClass(HoodieAvroPayload.class).initTable(configuration, basePath);
        boolean result = fileSystem.mkdirs(path);
        HiveTestUtil.checkResult(result);
        HiveTestUtil.commitToTable(instantTime, numberOfPartitions, useSchemaFromCommitMetadata, basePath, databaseName, tableName);
    }

    public static void commitToTable(String instantTime, int numberOfPartitions, boolean useSchemaFromCommitMetadata) throws IOException, URISyntaxException {
        HiveTestUtil.commitToTable(instantTime, numberOfPartitions, useSchemaFromCommitMetadata, basePath, DB_NAME, TABLE_NAME);
    }

    public static void commitToTable(String instantTime, int numberOfPartitions, boolean useSchemaFromCommitMetadata, String basePath, String databaseName, String tableName) throws IOException, URISyntaxException {
        ZonedDateTime dateTime = ZonedDateTime.now();
        HoodieCommitMetadata commitMetadata = HiveTestUtil.createPartitions(numberOfPartitions, true, useSchemaFromCommitMetadata, dateTime, instantTime, basePath);
        createdTablesSet.add(databaseName + "." + tableName);
        HiveTestUtil.createCommitFile(commitMetadata, instantTime, basePath);
    }

    public static void removeCommitFromActiveTimeline(String instantTime, String actionType) {
        ArrayList<Path> pathsToDelete = new ArrayList<Path>();
        Path metaFolderPath = new Path(basePath, ".hoodie");
        String actionSuffix = "." + actionType;
        pathsToDelete.add(new Path(metaFolderPath, instantTime + actionSuffix));
        pathsToDelete.add(new Path(metaFolderPath, instantTime + actionSuffix + ".requested"));
        pathsToDelete.add(new Path(metaFolderPath, instantTime + actionSuffix + ".inflight"));
        pathsToDelete.forEach(path -> {
            try {
                if (fileSystem.exists(path)) {
                    fileSystem.delete(path, false);
                }
            }
            catch (IOException e) {
                LOG.warn("Error deleting file: ", (Throwable)e);
            }
        });
    }

    public static void createCOWTable(String instantTime, int numberOfPartitions, boolean useSchemaFromCommitMetadata) throws IOException, URISyntaxException {
        HiveTestUtil.createCOWTable(instantTime, numberOfPartitions, useSchemaFromCommitMetadata, basePath, DB_NAME, TABLE_NAME);
    }

    public static void createReplaceCommit(String instantTime, String partitions, WriteOperationType type, boolean isParquetSchemaSimple, boolean useSchemaFromCommitMetadata) throws IOException {
        HoodieReplaceCommitMetadata replaceCommitMetadata = new HoodieReplaceCommitMetadata();
        HiveTestUtil.addSchemaToCommitMetadata((HoodieCommitMetadata)replaceCommitMetadata, isParquetSchemaSimple, useSchemaFromCommitMetadata);
        replaceCommitMetadata.setOperationType(type);
        HashMap partitionToReplaceFileIds = new HashMap();
        partitionToReplaceFileIds.put(partitions, new ArrayList());
        replaceCommitMetadata.setPartitionToReplaceFileIds(partitionToReplaceFileIds);
        HiveTestUtil.createReplaceCommitFile(replaceCommitMetadata, instantTime);
    }

    public static void addRollbackInstantToTable(String instantTime, String commitToRollback) throws IOException {
        HoodieRollbackMetadata rollbackMetadata = HoodieRollbackMetadata.newBuilder().setVersion(Integer.valueOf(1)).setStartRollbackTime(instantTime).setTotalFilesDeleted(1).setTimeTakenInMillis(1000L).setCommitsRollback(Collections.singletonList(commitToRollback)).setPartitionMetadata(Collections.emptyMap()).setInstantsRollback(Collections.emptyList()).build();
        HiveTestUtil.createMetaFile(basePath, HoodieTimeline.makeRequestedRollbackFileName((String)instantTime), "".getBytes());
        HiveTestUtil.createMetaFile(basePath, HoodieTimeline.makeInflightRollbackFileName((String)instantTime), "".getBytes());
        HiveTestUtil.createMetaFile(basePath, HoodieTimeline.makeRollbackFileName((String)instantTime), (byte[])TimelineMetadataUtils.serializeRollbackMetadata((HoodieRollbackMetadata)rollbackMetadata).get());
    }

    public static void createCOWTableWithSchema(String instantTime, String schemaFileName) throws IOException, URISyntaxException {
        Path path = new Path(basePath);
        FileIOUtils.deleteDirectory((File)new File(basePath));
        HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(TABLE_NAME).setPayloadClass(HoodieAvroPayload.class).initTable(configuration, basePath);
        boolean result = fileSystem.mkdirs(path);
        HiveTestUtil.checkResult(result);
        ZonedDateTime dateTime = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        String partitionPath = dateTime.format(dtfOut);
        Path partPath = new Path(basePath + "/" + partitionPath);
        fileSystem.makeQualified(partPath);
        fileSystem.mkdirs(partPath);
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        String fileId = UUID.randomUUID().toString();
        Path filePath = new Path(partPath.toString() + "/" + FSUtils.makeBaseFileName((String)instantTime, (String)"1-0-1", (String)fileId));
        Schema schema = SchemaTestUtil.getSchemaFromResource(HiveTestUtil.class, (String)schemaFileName);
        HiveTestUtil.generateParquetDataWithSchema(filePath, schema);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId(fileId);
        writeStat.setPath(filePath.toString());
        writeStats.add(writeStat);
        writeStats.forEach(s -> commitMetadata.addWriteStat(partitionPath, s));
        commitMetadata.addMetadata("schema", schema.toString());
        createdTablesSet.add("testdb.test1");
        HiveTestUtil.createCommitFile(commitMetadata, instantTime, basePath);
    }

    public static void createMORTable(String commitTime, String deltaCommitTime, int numberOfPartitions, boolean createDeltaCommit, boolean useSchemaFromCommitMetadata) throws IOException, URISyntaxException, InterruptedException {
        Path path = new Path(basePath);
        FileIOUtils.deleteDirectory((File)new File(basePath));
        HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.MERGE_ON_READ).setTableName(TABLE_NAME).setPayloadClass(HoodieAvroPayload.class).initTable(configuration, basePath);
        boolean result = fileSystem.mkdirs(path);
        HiveTestUtil.checkResult(result);
        ZonedDateTime dateTime = ZonedDateTime.now();
        HoodieCommitMetadata commitMetadata = HiveTestUtil.createPartitions(numberOfPartitions, true, useSchemaFromCommitMetadata, dateTime, commitTime, basePath);
        createdTablesSet.add("testdb.test1_ro");
        createdTablesSet.add("testdb.test1_rt");
        HoodieCommitMetadata compactionMetadata = new HoodieCommitMetadata();
        commitMetadata.getPartitionToWriteStats().forEach((key, value) -> value.forEach(l -> compactionMetadata.addWriteStat(key, l)));
        HiveTestUtil.addSchemaToCommitMetadata(compactionMetadata, commitMetadata.getMetadata("schema"), useSchemaFromCommitMetadata);
        HiveTestUtil.createCompactionCommitFile(compactionMetadata, commitTime);
        if (createDeltaCommit) {
            HoodieCommitMetadata deltaMetadata = HiveTestUtil.createLogFiles(commitMetadata.getPartitionToWriteStats(), true, useSchemaFromCommitMetadata);
            HiveTestUtil.createDeltaCommitFile(deltaMetadata, deltaCommitTime);
        }
    }

    public static void addCOWPartitions(int numberOfPartitions, boolean isParquetSchemaSimple, boolean useSchemaFromCommitMetadata, ZonedDateTime startFrom, String instantTime) throws IOException, URISyntaxException {
        HoodieCommitMetadata commitMetadata = HiveTestUtil.createPartitions(numberOfPartitions, isParquetSchemaSimple, useSchemaFromCommitMetadata, startFrom, instantTime, basePath);
        createdTablesSet.add("testdb.test1");
        HiveTestUtil.createCommitFile(commitMetadata, instantTime, basePath);
    }

    public static void addCOWPartition(String partitionPath, boolean isParquetSchemaSimple, boolean useSchemaFromCommitMetadata, String instantTime) throws IOException, URISyntaxException {
        HoodieCommitMetadata commitMetadata = HiveTestUtil.createPartition(partitionPath, isParquetSchemaSimple, useSchemaFromCommitMetadata, instantTime);
        createdTablesSet.add("testdb.test1");
        HiveTestUtil.createCommitFile(commitMetadata, instantTime, basePath);
    }

    public static void addMORPartitions(int numberOfPartitions, boolean isParquetSchemaSimple, boolean isLogSchemaSimple, boolean useSchemaFromCommitMetadata, ZonedDateTime startFrom, String instantTime, String deltaCommitTime) throws IOException, URISyntaxException, InterruptedException {
        HoodieCommitMetadata commitMetadata = HiveTestUtil.createPartitions(numberOfPartitions, isParquetSchemaSimple, useSchemaFromCommitMetadata, startFrom, instantTime, basePath);
        createdTablesSet.add("testdb.test1_ro");
        createdTablesSet.add("testdb.test1_rt");
        HoodieCommitMetadata compactionMetadata = new HoodieCommitMetadata();
        commitMetadata.getPartitionToWriteStats().forEach((key, value) -> value.forEach(l -> compactionMetadata.addWriteStat(key, l)));
        HiveTestUtil.addSchemaToCommitMetadata(compactionMetadata, commitMetadata.getMetadata("schema"), useSchemaFromCommitMetadata);
        HiveTestUtil.createCompactionCommitFile(compactionMetadata, instantTime);
        HoodieCommitMetadata deltaMetadata = HiveTestUtil.createLogFiles(commitMetadata.getPartitionToWriteStats(), isLogSchemaSimple, useSchemaFromCommitMetadata);
        HiveTestUtil.createDeltaCommitFile(deltaMetadata, deltaCommitTime);
    }

    private static HoodieCommitMetadata createLogFiles(Map<String, List<HoodieWriteStat>> partitionWriteStats, boolean isLogSchemaSimple, boolean useSchemaFromCommitMetadata) throws InterruptedException, IOException, URISyntaxException {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        for (Map.Entry<String, List<HoodieWriteStat>> wEntry : partitionWriteStats.entrySet()) {
            String partitionPath = wEntry.getKey();
            for (HoodieWriteStat wStat : wEntry.getValue()) {
                Path path = new Path(wStat.getPath());
                HoodieBaseFile dataFile = new HoodieBaseFile(fileSystem.getFileStatus(path));
                HoodieLogFile logFile = HiveTestUtil.generateLogData(path, isLogSchemaSimple);
                HoodieDeltaWriteStat writeStat = new HoodieDeltaWriteStat();
                writeStat.setFileId(dataFile.getFileId());
                writeStat.setPath(logFile.getPath().toString());
                commitMetadata.addWriteStat(partitionPath, (HoodieWriteStat)writeStat);
            }
        }
        HiveTestUtil.addSchemaToCommitMetadata(commitMetadata, isLogSchemaSimple, useSchemaFromCommitMetadata);
        return commitMetadata;
    }

    private static HoodieCommitMetadata createPartitions(int numberOfPartitions, boolean isParquetSchemaSimple, boolean useSchemaFromCommitMetadata, ZonedDateTime startFrom, String instantTime, String basePath) throws IOException, URISyntaxException {
        startFrom = startFrom.truncatedTo(ChronoUnit.DAYS);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        for (int i = 0; i < numberOfPartitions; ++i) {
            String partitionPath = startFrom.format(dtfOut);
            Path partPath = new Path(basePath + "/" + partitionPath);
            fileSystem.makeQualified(partPath);
            fileSystem.mkdirs(partPath);
            List<HoodieWriteStat> writeStats = HiveTestUtil.createTestData(partPath, isParquetSchemaSimple, instantTime);
            startFrom = startFrom.minusDays(1L);
            writeStats.forEach(s -> commitMetadata.addWriteStat(partitionPath, s));
        }
        HiveTestUtil.addSchemaToCommitMetadata(commitMetadata, isParquetSchemaSimple, useSchemaFromCommitMetadata);
        return commitMetadata;
    }

    private static HoodieCommitMetadata createPartition(String partitionPath, boolean isParquetSchemaSimple, boolean useSchemaFromCommitMetadata, String instantTime) throws IOException, URISyntaxException {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        Path partPath = new Path(basePath + "/" + partitionPath);
        fileSystem.makeQualified(partPath);
        fileSystem.mkdirs(partPath);
        List<HoodieWriteStat> writeStats = HiveTestUtil.createTestData(partPath, isParquetSchemaSimple, instantTime);
        writeStats.forEach(s -> commitMetadata.addWriteStat(partitionPath, s));
        HiveTestUtil.addSchemaToCommitMetadata(commitMetadata, isParquetSchemaSimple, useSchemaFromCommitMetadata);
        return commitMetadata;
    }

    private static List<HoodieWriteStat> createTestData(Path partPath, boolean isParquetSchemaSimple, String instantTime) throws IOException, URISyntaxException {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        for (int i = 0; i < 5; ++i) {
            String fileId = UUID.randomUUID().toString();
            Path filePath = new Path(partPath.toString() + "/" + FSUtils.makeBaseFileName((String)instantTime, (String)"1-0-1", (String)fileId));
            HiveTestUtil.generateParquetData(filePath, isParquetSchemaSimple);
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setFileId(fileId);
            writeStat.setPath(filePath.toString());
            writeStats.add(writeStat);
        }
        return writeStats;
    }

    private static void generateParquetData(Path filePath, boolean isParquetSchemaSimple) throws IOException, URISyntaxException {
        Schema schema = HiveTestUtil.getTestDataSchema(isParquetSchemaSimple);
        MessageType parquetSchema = new AvroSchemaConverter().convert(schema);
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-4, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(parquetSchema, schema, Option.of((Object)filter), new Properties());
        ParquetWriter writer = new ParquetWriter(filePath, (WriteSupport)writeSupport, CompressionCodecName.GZIP, 0x7800000, 0x100000, 0x100000, true, false, ParquetWriter.DEFAULT_WRITER_VERSION, fileSystem.getConf());
        List testRecords = isParquetSchemaSimple ? SchemaTestUtil.generateTestRecords((int)0, (int)100) : SchemaTestUtil.generateEvolvedTestRecords((int)100, (int)100);
        testRecords.forEach(s -> {
            try {
                writer.write(s);
            }
            catch (IOException e) {
                Assertions.fail((String)("IOException while writing test records as parquet" + e.toString()));
            }
        });
        writer.close();
    }

    private static void generateParquetDataWithSchema(Path filePath, Schema schema) throws IOException {
        MessageType parquetSchema = new AvroSchemaConverter().convert(schema);
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-4, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(parquetSchema, schema, Option.of((Object)filter), new Properties());
        ParquetWriter writer = new ParquetWriter(filePath, (WriteSupport)writeSupport, CompressionCodecName.GZIP, 0x7800000, 0x100000, 0x100000, true, false, ParquetWriter.DEFAULT_WRITER_VERSION, fileSystem.getConf());
        List testRecords = SchemaTestUtil.generateTestRecordsForSchema((Schema)schema);
        testRecords.forEach(s -> {
            try {
                writer.write(s);
            }
            catch (IOException e) {
                Assertions.fail((String)("IOException while writing test records as parquet" + e.toString()));
            }
        });
        writer.close();
    }

    private static HoodieLogFile generateLogData(Path parquetFilePath, boolean isLogSchemaSimple) throws IOException, InterruptedException, URISyntaxException {
        Schema schema = HiveTestUtil.getTestDataSchema(isLogSchemaSimple);
        HoodieBaseFile dataFile = new HoodieBaseFile(fileSystem.getFileStatus(parquetFilePath));
        HoodieLogFormat.Writer logWriter = HoodieLogFormat.newWriterBuilder().onParentPath(parquetFilePath.getParent()).withFileExtension(".log").withFileId(dataFile.getFileId()).overBaseCommit(dataFile.getCommitTime()).withFs(fileSystem).build();
        List records = (isLogSchemaSimple ? SchemaTestUtil.generateTestRecords((int)0, (int)100) : SchemaTestUtil.generateEvolvedTestRecords((int)100, (int)100)).stream().map(HoodieAvroIndexedRecord::new).collect(Collectors.toList());
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(2);
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, dataFile.getCommitTime());
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, schema.toString());
        HoodieAvroDataBlock dataBlock = new HoodieAvroDataBlock(records, header, HoodieRecord.RECORD_KEY_METADATA_FIELD);
        logWriter.appendBlock((HoodieLogBlock)dataBlock);
        logWriter.close();
        return logWriter.getLogFile();
    }

    private static Schema getTestDataSchema(boolean isSimpleSchema) throws IOException {
        return isSimpleSchema ? SchemaTestUtil.getSimpleSchema() : SchemaTestUtil.getEvolvedSchema();
    }

    private static void addSchemaToCommitMetadata(HoodieCommitMetadata commitMetadata, boolean isSimpleSchema, boolean useSchemaFromCommitMetadata) throws IOException {
        if (useSchemaFromCommitMetadata) {
            Schema dataSchema = HiveTestUtil.getTestDataSchema(isSimpleSchema);
            commitMetadata.addMetadata("schema", dataSchema.toString());
        }
    }

    private static void addSchemaToCommitMetadata(HoodieCommitMetadata commitMetadata, String schema, boolean useSchemaFromCommitMetadata) {
        if (useSchemaFromCommitMetadata) {
            commitMetadata.addMetadata("schema", schema);
        }
    }

    private static void checkResult(boolean result) {
        if (!result) {
            throw new JUnitException("Could not initialize");
        }
    }

    public static void createCommitFile(HoodieCommitMetadata commitMetadata, String instantTime, String basePath) throws IOException {
        HiveTestUtil.createMetaFile(basePath, HoodieTimeline.makeCommitFileName((String)instantTime), commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8));
    }

    public static void createReplaceCommitFile(HoodieReplaceCommitMetadata commitMetadata, String instantTime) throws IOException {
        HiveTestUtil.createMetaFile(basePath, HoodieTimeline.makeReplaceFileName((String)instantTime), commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8));
    }

    public static void createCommitFileWithSchema(HoodieCommitMetadata commitMetadata, String instantTime, boolean isSimpleSchema) throws IOException {
        HiveTestUtil.addSchemaToCommitMetadata(commitMetadata, isSimpleSchema, true);
        HiveTestUtil.createCommitFile(commitMetadata, instantTime, basePath);
    }

    private static void createCompactionCommitFile(HoodieCommitMetadata commitMetadata, String instantTime) throws IOException {
        HiveTestUtil.createMetaFile(basePath, HoodieTimeline.makeCommitFileName((String)instantTime), commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8));
    }

    private static void createDeltaCommitFile(HoodieCommitMetadata deltaCommitMetadata, String deltaCommitTime) throws IOException {
        HiveTestUtil.createMetaFile(basePath, HoodieTimeline.makeDeltaFileName((String)deltaCommitTime), deltaCommitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8));
    }

    private static void createMetaFile(String basePath, String fileName, byte[] bytes) throws IOException {
        Path fullPath = new Path(basePath + "/" + ".hoodie" + "/" + fileName);
        FSDataOutputStream fsout = fileSystem.create(fullPath, true);
        fsout.write(bytes);
        fsout.close();
    }

    public static Set<String> getCreatedTablesSet() {
        return createdTablesSet;
    }

    static {
        createdTablesSet = new HashSet<String>();
    }
}

