/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.util.PartitionFilterGenerator;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartitionFilterGenerator {
    @Test
    public void testPushDownFilters() {
        Properties props = new Properties();
        HiveSyncConfig config = new HiveSyncConfig(props);
        ArrayList<FieldSchema> partitionFieldSchemas = new ArrayList<FieldSchema>(4);
        partitionFieldSchemas.add(new FieldSchema("date", "date"));
        partitionFieldSchemas.add(new FieldSchema("year", "string"));
        partitionFieldSchemas.add(new FieldSchema("month", "int"));
        partitionFieldSchemas.add(new FieldSchema("day", "bigint"));
        ArrayList<String> writtenPartitions = new ArrayList<String>();
        writtenPartitions.add("2022-09-01/2022/9/1");
        Assertions.assertEquals((Object)"(((date = 2022-09-01 AND year = \"2022\") AND month = 9) AND day = 1)", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        writtenPartitions.add("2022-09-02/2022/9/2");
        Assertions.assertEquals((Object)"((((date = 2022-09-01 AND year = \"2022\") AND month = 9) AND day = 1) OR (((date = 2022-09-02 AND year = \"2022\") AND month = 9) AND day = 2))", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        partitionFieldSchemas.clear();
        writtenPartitions.clear();
        partitionFieldSchemas.add(new FieldSchema("date", "date"));
        partitionFieldSchemas.add(new FieldSchema("finished", "boolean"));
        writtenPartitions.add("2022-09-01/true");
        Assertions.assertEquals((Object)"date = 2022-09-01", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        writtenPartitions.add("2022-09-02/true");
        Assertions.assertEquals((Object)"(date = 2022-09-01 OR date = 2022-09-02)", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        partitionFieldSchemas.clear();
        writtenPartitions.clear();
        partitionFieldSchemas.add(new FieldSchema("finished", "boolean"));
        writtenPartitions.add("true");
        Assertions.assertEquals((Object)"", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        writtenPartitions.add("false");
        Assertions.assertEquals((Object)"", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
    }

    @Test
    public void testPushDownFilterIfExceedLimit() {
        Properties props = new Properties();
        props.put(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_MAX_SIZE.key(), "0");
        HiveSyncConfig config = new HiveSyncConfig(props);
        ArrayList<FieldSchema> partitionFieldSchemas = new ArrayList<FieldSchema>(4);
        partitionFieldSchemas.add(new FieldSchema("date", "date"));
        partitionFieldSchemas.add(new FieldSchema("year", "string"));
        partitionFieldSchemas.add(new FieldSchema("month", "int"));
        partitionFieldSchemas.add(new FieldSchema("day", "bigint"));
        ArrayList<String> writtenPartitions = new ArrayList<String>();
        writtenPartitions.add("2022-09-01/2022/9/1");
        Assertions.assertEquals((Object)"(((date = 2022-09-01 AND year = \"2022\") AND month = 9) AND day = 1)", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        writtenPartitions.add("2022-09-02/2022/9/2");
        writtenPartitions.add("2022-09-03/2022/9/2");
        writtenPartitions.add("2022-09-04/2022/9/2");
        Assertions.assertEquals((Object)"((((date >= 2022-09-01 AND date <= 2022-09-04) AND year = \"2022\") AND month = 9) AND (day >= 1 AND day <= 2))", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        partitionFieldSchemas.clear();
        writtenPartitions.clear();
        partitionFieldSchemas.add(new FieldSchema("date", "date"));
        partitionFieldSchemas.add(new FieldSchema("finished", "boolean"));
        writtenPartitions.add("2022-09-01/true");
        Assertions.assertEquals((Object)"date = 2022-09-01", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        writtenPartitions.add("2022-09-02/true");
        writtenPartitions.add("2022-09-03/false");
        writtenPartitions.add("2022-09-04/false");
        Assertions.assertEquals((Object)"(date >= 2022-09-01 AND date <= 2022-09-04)", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        partitionFieldSchemas.clear();
        writtenPartitions.clear();
        partitionFieldSchemas.add(new FieldSchema("finished", "boolean"));
        writtenPartitions.add("true");
        Assertions.assertEquals((Object)"", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
        writtenPartitions.add("false");
        writtenPartitions.add("false");
        writtenPartitions.add("false");
        Assertions.assertEquals((Object)"", (Object)PartitionFilterGenerator.generatePushDownFilter(writtenPartitions, partitionFieldSchemas, (HiveSyncConfig)config));
    }
}

