/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.hive.HoodieHiveClient;
import org.apache.hudi.hive.MultiPartKeysValueExtractor;
import org.apache.hudi.hive.NonPartitionedExtractor;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.hive.testutils.HiveTestUtil;
import org.apache.hudi.hive.util.HiveSchemaUtil;
import org.apache.hudi.sync.common.AbstractSyncHoodieClient;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.joda.time.DateTime;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHiveSyncTool {
    private static Stream<Boolean> useJdbc() {
        return Stream.of(false, true);
    }

    private static Iterable<Object[]> useJdbcAndSchemaFromCommitMetadata() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    @BeforeEach
    public void setUp() throws IOException, InterruptedException {
        HiveTestUtil.setUp();
    }

    @AfterEach
    public void teardown() throws IOException {
        HiveTestUtil.clear();
    }

    @AfterAll
    public static void cleanUpClass() {
        HiveTestUtil.shutdown();
    }

    @Test
    public void testSchemaConvertArray() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().optional(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("list")).named("int_list")).named("ArrayOfInts");
        String schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`int_list` ARRAY< int>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().requiredGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("list")).named("element")).named("list")).named("int_list_list")).named("ArrayOfArrayOfInts");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`int_list_list` ARRAY< ARRAY< int>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeated(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("int_list")).named("ArrayOfInts");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`int_list` ARRAY< int>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).required(PrimitiveType.PrimitiveTypeName.INT32).named("num")).named("element")).named("tuple_list")).named("ArrayOfTuples");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`tuple_list` ARRAY< STRUCT< `str` : binary, `num` : int>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).named("array")).named("one_tuple_list")).named("ArrayOfOneTuples");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`one_tuple_list` ARRAY< STRUCT< `str` : binary>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).named("one_tuple_list_tuple")).named("one_tuple_list")).named("ArrayOfOneTuples2");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`one_tuple_list` ARRAY< STRUCT< `str` : binary>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).named("one_tuple_list")).named("one_tuple_list")).named("ArrayOfOneTuples3");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`one_tuple_list` ARRAY< binary>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().as(OriginalType.MAP)).repeatedGroup().as(OriginalType.MAP_KEY_VALUE)).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("string_key")).required(PrimitiveType.PrimitiveTypeName.INT32).named("int_value")).named("key_value")).named("array")).named("map_list")).named("ArrayOfMaps");
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`map_list` ARRAY< MAP< string, int>>", (Object)schemaString);
    }

    @Test
    public void testSchemaConvertTimestampMicros() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().optional(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.TIMESTAMP_MICROS)).named("my_element")).named("my_timestamp");
        String schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema);
        Assertions.assertEquals((Object)"`my_element` bigint", (Object)schemaString);
        schemaString = HiveSchemaUtil.generateSchemaString((MessageType)schema, Collections.emptyList(), (boolean)true);
        Assertions.assertEquals((Object)"`my_element` TIMESTAMP", (Object)schemaString);
    }

    @Test
    public void testSchemaDiffForTimestampMicros() {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().optional(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.TIMESTAMP_MICROS)).named("my_element")).named("my_timestamp");
        SchemaDifference schemaDifference = HiveSchemaUtil.getSchemaDifference((MessageType)schema, Collections.emptyMap(), Collections.emptyList(), (boolean)false);
        Assertions.assertEquals((Object)"bigint", schemaDifference.getAddColumnTypes().get("`my_element`"));
        schemaDifference = HiveSchemaUtil.getSchemaDifference((MessageType)schema, (Map)schemaDifference.getAddColumnTypes(), Collections.emptyList(), (boolean)false);
        Assertions.assertTrue((boolean)schemaDifference.isEmpty());
        schemaDifference = HiveSchemaUtil.getSchemaDifference((MessageType)schema, Collections.emptyMap(), Collections.emptyList(), (boolean)true);
        Assertions.assertEquals((Object)"TIMESTAMP", schemaDifference.getAddColumnTypes().get("`my_element`"));
        schemaDifference = HiveSchemaUtil.getSchemaDifference((MessageType)schema, (Map)schemaDifference.getAddColumnTypes(), Collections.emptyList(), (boolean)true);
        Assertions.assertTrue((boolean)schemaDifference.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"useJdbcAndSchemaFromCommitMetadata"})
    public void testBasicSync(boolean useJdbc, boolean useSchemaFromCommitMetadata) throws Exception {
        HiveTestUtil.hiveSyncConfig.useJdbc = useJdbc;
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, useSchemaFromCommitMetadata);
        HoodieHiveClient hiveClient = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        Assertions.assertFalse((boolean)hiveClient.doesTableExist(HiveTestUtil.hiveSyncConfig.tableName), (String)("Table " + HiveTestUtil.hiveSyncConfig.tableName + " should not exist initially"));
        HiveSyncTool tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        Assertions.assertTrue((boolean)hiveClient.doesTableExist(HiveTestUtil.hiveSyncConfig.tableName), (String)("Table " + HiveTestUtil.hiveSyncConfig.tableName + " should exist after sync completes"));
        Assertions.assertEquals((int)hiveClient.getTableSchema(HiveTestUtil.hiveSyncConfig.tableName).size(), (int)(hiveClient.getDataSchema().getColumns().size() + 1), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)5, (int)hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)hiveClient.getLastCommitTimeSynced(HiveTestUtil.hiveSyncConfig.tableName).get(), (String)"The last commit that was sycned should be updated in the TBLPROPERTIES");
        List<String> newPartition = Arrays.asList("2050/01/01");
        hiveClient.addPartitionsToTable(HiveTestUtil.hiveSyncConfig.tableName, Arrays.asList(new String[0]));
        Assertions.assertEquals((int)5, (int)hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName).size(), (String)"No new partition should be added");
        hiveClient.addPartitionsToTable(HiveTestUtil.hiveSyncConfig.tableName, newPartition);
        Assertions.assertEquals((int)6, (int)hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName).size(), (String)"New partition should be added");
        hiveClient.updatePartitionsToTable(HiveTestUtil.hiveSyncConfig.tableName, Arrays.asList(new String[0]));
        Assertions.assertEquals((int)6, (int)hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName).size(), (String)"Partition count should remain the same");
        hiveClient.updatePartitionsToTable(HiveTestUtil.hiveSyncConfig.tableName, newPartition);
        Assertions.assertEquals((int)6, (int)hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName).size(), (String)"Partition count should remain the same");
        hiveClient.updateHiveSQL("ALTER TABLE `" + HiveTestUtil.hiveSyncConfig.tableName + "` PARTITION (`datestr`='2050-01-01') SET LOCATION '/some/new/location'");
        hiveClient = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        List hivePartitions = hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName);
        List writtenPartitionsSince = hiveClient.getPartitionsWrittenToSince(Option.empty());
        writtenPartitionsSince.add(newPartition.get(0));
        List partitionEvents = hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince);
        Assertions.assertEquals((int)1, (int)partitionEvents.size(), (String)"There should be only one paritition event");
        Assertions.assertEquals((Object)AbstractSyncHoodieClient.PartitionEvent.PartitionEventType.UPDATE, (Object)((AbstractSyncHoodieClient.PartitionEvent)partitionEvents.iterator().next()).eventType, (String)"The one partition event must of type UPDATE");
        tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        List tablePartitions = hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName);
        Assertions.assertEquals((int)6, (int)tablePartitions.size(), (String)"The one partition we wrote should be added to hive");
        Assertions.assertEquals((Object)instantTime, (Object)hiveClient.getLastCommitTimeSynced(HiveTestUtil.hiveSyncConfig.tableName).get(), (String)"The last commit that was sycned should be 100");
    }

    @ParameterizedTest
    @MethodSource(value={"useJdbc"})
    public void testSyncIncremental(boolean useJdbc) throws Exception {
        HiveTestUtil.hiveSyncConfig.useJdbc = useJdbc;
        String commitTime1 = "100";
        HiveTestUtil.createCOWTable(commitTime1, 5, true);
        HoodieHiveClient hiveClient = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        HiveSyncTool tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        Assertions.assertEquals((int)5, (int)hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)commitTime1, (Object)hiveClient.getLastCommitTimeSynced(HiveTestUtil.hiveSyncConfig.tableName).get(), (String)"The last commit that was sycned should be updated in the TBLPROPERTIES");
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(1, true, true, dateTime, commitTime2);
        hiveClient = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        List writtenPartitionsSince = hiveClient.getPartitionsWrittenToSince(Option.of((Object)commitTime1));
        Assertions.assertEquals((int)1, (int)writtenPartitionsSince.size(), (String)"We should have one partition written after 100 commit");
        List hivePartitions = hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName);
        List partitionEvents = hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince);
        Assertions.assertEquals((int)1, (int)partitionEvents.size(), (String)"There should be only one paritition event");
        Assertions.assertEquals((Object)AbstractSyncHoodieClient.PartitionEvent.PartitionEventType.ADD, (Object)((AbstractSyncHoodieClient.PartitionEvent)partitionEvents.iterator().next()).eventType, (String)"The one partition event must of type ADD");
        tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        Assertions.assertEquals((int)6, (int)hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName).size(), (String)"The one partition we wrote should be added to hive");
        Assertions.assertEquals((Object)commitTime2, (Object)hiveClient.getLastCommitTimeSynced(HiveTestUtil.hiveSyncConfig.tableName).get(), (String)"The last commit that was sycned should be 101");
    }

    @ParameterizedTest
    @MethodSource(value={"useJdbc"})
    public void testSyncIncrementalWithSchemaEvolution(boolean useJdbc) throws Exception {
        HiveTestUtil.hiveSyncConfig.useJdbc = useJdbc;
        String commitTime1 = "100";
        HiveTestUtil.createCOWTable(commitTime1, 5, true);
        HoodieHiveClient hiveClient = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        HiveSyncTool tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        int fields = hiveClient.getTableSchema(HiveTestUtil.hiveSyncConfig.tableName).size();
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(1, false, true, dateTime, commitTime2);
        tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        Assertions.assertEquals((int)(fields + 3), (int)hiveClient.getTableSchema(HiveTestUtil.hiveSyncConfig.tableName).size(), (String)"Hive Schema has evolved and should not be 3 more field");
        Assertions.assertEquals((Object)"BIGINT", hiveClient.getTableSchema(HiveTestUtil.hiveSyncConfig.tableName).get("favorite_number"), (String)"Hive Schema has evolved - Field favorite_number has evolved from int to long");
        Assertions.assertTrue((boolean)hiveClient.getTableSchema(HiveTestUtil.hiveSyncConfig.tableName).containsKey("favorite_movie"), (String)"Hive Schema has evolved - Field favorite_movie was added");
        Assertions.assertEquals((int)6, (int)hiveClient.scanTablePartitions(HiveTestUtil.hiveSyncConfig.tableName).size(), (String)"The one partition we wrote should be added to hive");
        Assertions.assertEquals((Object)commitTime2, (Object)hiveClient.getLastCommitTimeSynced(HiveTestUtil.hiveSyncConfig.tableName).get(), (String)"The last commit that was sycned should be 101");
    }

    @ParameterizedTest
    @MethodSource(value={"useJdbcAndSchemaFromCommitMetadata"})
    public void testSyncMergeOnRead(boolean useJdbc, boolean useSchemaFromCommitMetadata) throws Exception {
        HiveTestUtil.hiveSyncConfig.useJdbc = useJdbc;
        String instantTime = "100";
        String deltaCommitTime = "101";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, useSchemaFromCommitMetadata);
        String roTableName = HiveTestUtil.hiveSyncConfig.tableName + "_ro";
        HoodieHiveClient hiveClient = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        Assertions.assertFalse((boolean)hiveClient.doesTableExist(roTableName), (String)("Table " + HiveTestUtil.hiveSyncConfig.tableName + " should not exist initially"));
        HiveSyncTool tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        Assertions.assertTrue((boolean)hiveClient.doesTableExist(roTableName), (String)("Table " + roTableName + " should exist after sync completes"));
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)hiveClient.getTableSchema(roTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        } else {
            Assertions.assertEquals((int)hiveClient.getTableSchema(roTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size()), (String)"Hive Schema should match the table schema + partition field");
        }
        Assertions.assertEquals((int)5, (int)hiveClient.scanTablePartitions(roTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)deltaCommitTime, (Object)hiveClient.getLastCommitTimeSynced(roTableName).get(), (String)"The last commit that was sycned should be updated in the TBLPROPERTIES");
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addCOWPartitions(1, true, useSchemaFromCommitMetadata, dateTime, commitTime2);
        HiveTestUtil.addMORPartitions(1, true, false, useSchemaFromCommitMetadata, dateTime, commitTime2, deltaCommitTime2);
        tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        hiveClient = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)hiveClient.getTableSchema(roTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        } else {
            Assertions.assertEquals((int)hiveClient.getTableSchema(roTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        }
        Assertions.assertEquals((int)6, (int)hiveClient.scanTablePartitions(roTableName).size(), (String)"The 2 partitions we wrote should be added to hive");
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)hiveClient.getLastCommitTimeSynced(roTableName).get(), (String)"The last commit that was synced should be 103");
    }

    @ParameterizedTest
    @MethodSource(value={"useJdbcAndSchemaFromCommitMetadata"})
    public void testSyncMergeOnReadRT(boolean useJdbc, boolean useSchemaFromCommitMetadata) throws Exception {
        HiveTestUtil.hiveSyncConfig.useJdbc = useJdbc;
        String instantTime = "100";
        String deltaCommitTime = "101";
        String snapshotTableName = HiveTestUtil.hiveSyncConfig.tableName + "_rt";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, useSchemaFromCommitMetadata);
        HoodieHiveClient hiveClientRT = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        Assertions.assertFalse((boolean)hiveClientRT.doesTableExist(snapshotTableName), (String)("Table " + HiveTestUtil.hiveSyncConfig.tableName + "_rt" + " should not exist initially"));
        HiveSyncTool tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        Assertions.assertTrue((boolean)hiveClientRT.doesTableExist(snapshotTableName), (String)("Table " + HiveTestUtil.hiveSyncConfig.tableName + "_rt" + " should exist after sync completes"));
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)hiveClientRT.getTableSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        } else {
            Assertions.assertEquals((int)hiveClientRT.getTableSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size()), (String)"Hive Schema should match the table schema + partition field");
        }
        Assertions.assertEquals((int)5, (int)hiveClientRT.scanTablePartitions(snapshotTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)deltaCommitTime, (Object)hiveClientRT.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addCOWPartitions(1, true, useSchemaFromCommitMetadata, dateTime, commitTime2);
        HiveTestUtil.addMORPartitions(1, true, false, useSchemaFromCommitMetadata, dateTime, commitTime2, deltaCommitTime2);
        tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        hiveClientRT = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)hiveClientRT.getTableSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        } else {
            Assertions.assertEquals((int)hiveClientRT.getTableSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        }
        Assertions.assertEquals((int)6, (int)hiveClientRT.scanTablePartitions(snapshotTableName).size(), (String)"The 2 partitions we wrote should be added to hive");
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)hiveClientRT.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was sycned should be 103");
    }

    @ParameterizedTest
    @MethodSource(value={"useJdbc"})
    public void testMultiPartitionKeySync(boolean useJdbc) throws Exception {
        HiveTestUtil.hiveSyncConfig.useJdbc = useJdbc;
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        HiveSyncConfig hiveSyncConfig = HiveSyncConfig.copy((HiveSyncConfig)HiveTestUtil.hiveSyncConfig);
        hiveSyncConfig.partitionValueExtractorClass = MultiPartKeysValueExtractor.class.getCanonicalName();
        hiveSyncConfig.tableName = "multi_part_key";
        hiveSyncConfig.partitionFields = Arrays.asList("year", "month", "day");
        HiveTestUtil.getCreatedTablesSet().add(hiveSyncConfig.databaseName + "." + hiveSyncConfig.tableName);
        HoodieHiveClient hiveClient = new HoodieHiveClient(hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        Assertions.assertFalse((boolean)hiveClient.doesTableExist(hiveSyncConfig.tableName), (String)("Table " + hiveSyncConfig.tableName + " should not exist initially"));
        HiveSyncTool tool = new HiveSyncTool(hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        Assertions.assertTrue((boolean)hiveClient.doesTableExist(hiveSyncConfig.tableName), (String)("Table " + hiveSyncConfig.tableName + " should exist after sync completes"));
        Assertions.assertEquals((int)hiveClient.getTableSchema(hiveSyncConfig.tableName).size(), (int)(hiveClient.getDataSchema().getColumns().size() + 3), (String)"Hive Schema should match the table schema + partition fields");
        Assertions.assertEquals((int)5, (int)hiveClient.scanTablePartitions(hiveSyncConfig.tableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)hiveClient.getLastCommitTimeSynced(hiveSyncConfig.tableName).get(), (String)"The last commit that was sycned should be updated in the TBLPROPERTIES");
    }

    @ParameterizedTest
    @MethodSource(value={"useJdbc"})
    public void testNonPartitionedSync(boolean useJdbc) throws Exception {
        HiveTestUtil.hiveSyncConfig.useJdbc = useJdbc;
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        HiveSyncConfig hiveSyncConfig = HiveSyncConfig.copy((HiveSyncConfig)HiveTestUtil.hiveSyncConfig);
        hiveSyncConfig.partitionValueExtractorClass = NonPartitionedExtractor.class.getCanonicalName();
        hiveSyncConfig.tableName = "non_partitioned";
        hiveSyncConfig.partitionFields = Arrays.asList("year", "month", "day");
        HiveTestUtil.getCreatedTablesSet().add(hiveSyncConfig.databaseName + "." + hiveSyncConfig.tableName);
        HoodieHiveClient hiveClient = new HoodieHiveClient(hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        Assertions.assertFalse((boolean)hiveClient.doesTableExist(hiveSyncConfig.tableName), (String)("Table " + hiveSyncConfig.tableName + " should not exist initially"));
        HiveSyncTool tool = new HiveSyncTool(hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        Assertions.assertTrue((boolean)hiveClient.doesTableExist(hiveSyncConfig.tableName), (String)("Table " + hiveSyncConfig.tableName + " should exist after sync completes"));
        Assertions.assertEquals((int)hiveClient.getTableSchema(hiveSyncConfig.tableName).size(), (int)hiveClient.getDataSchema().getColumns().size(), (String)"Hive Schema should match the table schema\uff0cignoring the partition fields");
        Assertions.assertEquals((int)0, (int)hiveClient.scanTablePartitions(hiveSyncConfig.tableName).size(), (String)"Table should not have partitions because of the NonPartitionedExtractor");
    }

    @ParameterizedTest
    @MethodSource(value={"useJdbc"})
    public void testReadSchemaForMOR(boolean useJdbc) throws Exception {
        HiveTestUtil.hiveSyncConfig.useJdbc = useJdbc;
        String commitTime = "100";
        String snapshotTableName = HiveTestUtil.hiveSyncConfig.tableName + "_rt";
        HiveTestUtil.createMORTable(commitTime, "", 5, false, true);
        HoodieHiveClient hiveClientRT = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        Assertions.assertFalse((boolean)hiveClientRT.doesTableExist(snapshotTableName), (String)("Table " + HiveTestUtil.hiveSyncConfig.tableName + "_rt" + " should not exist initially"));
        HiveSyncTool tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        Assertions.assertTrue((boolean)hiveClientRT.doesTableExist(snapshotTableName), (String)("Table " + HiveTestUtil.hiveSyncConfig.tableName + "_rt" + " should exist after sync completes"));
        Assertions.assertEquals((int)hiveClientRT.getTableSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)5, (int)hiveClientRT.scanTablePartitions(snapshotTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addMORPartitions(1, true, false, true, dateTime, commitTime2, deltaCommitTime2);
        tool = new HiveSyncTool(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        tool.syncHoodieTable();
        hiveClientRT = new HoodieHiveClient(HiveTestUtil.hiveSyncConfig, HiveTestUtil.getHiveConf(), HiveTestUtil.fileSystem);
        Assertions.assertEquals((int)hiveClientRT.getTableSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + HiveTestUtil.hiveSyncConfig.partitionFields.size() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        Assertions.assertEquals((int)6, (int)hiveClientRT.scanTablePartitions(snapshotTableName).size(), (String)"The 1 partition we wrote should be added to hive");
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)hiveClientRT.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was sycned should be 103");
    }
}

