/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.testutils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.minicluster.HdfsTestService;
import org.apache.hudi.common.testutils.minicluster.ZookeeperTestService;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveClient;
import org.apache.hudi.hive.testutils.HiveTestService;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.platform.commons.JUnitException;

public class HiveTestUtil {
    private static MiniDFSCluster dfsCluster;
    private static ZooKeeperServer zkServer;
    private static HiveServer2 hiveServer;
    private static HiveTestService hiveTestService;
    private static Configuration configuration;
    public static HiveSyncConfig hiveSyncConfig;
    private static DateTimeFormatter dtfOut;
    public static FileSystem fileSystem;
    private static Set<String> createdTablesSet;

    public static void setUp() throws IOException, InterruptedException {
        if (dfsCluster == null) {
            HdfsTestService service = new HdfsTestService();
            dfsCluster = service.start(true);
            configuration = service.getHadoopConf();
        }
        if (zkServer == null) {
            ZookeeperTestService zkService = new ZookeeperTestService(configuration);
            zkServer = zkService.start();
        }
        if (hiveServer == null) {
            hiveTestService = new HiveTestService(configuration);
            hiveServer = hiveTestService.start();
        }
        fileSystem = FileSystem.get((Configuration)configuration);
        hiveSyncConfig = new HiveSyncConfig();
        HiveTestUtil.hiveSyncConfig.jdbcUrl = "jdbc:hive2://127.0.0.1:9999/";
        HiveTestUtil.hiveSyncConfig.hiveUser = "";
        HiveTestUtil.hiveSyncConfig.hivePass = "";
        HiveTestUtil.hiveSyncConfig.databaseName = "testdb";
        HiveTestUtil.hiveSyncConfig.tableName = "test1";
        HiveTestUtil.hiveSyncConfig.basePath = "/tmp/hdfs/TestHiveSyncTool/";
        HiveTestUtil.hiveSyncConfig.assumeDatePartitioning = true;
        HiveTestUtil.hiveSyncConfig.usePreApacheInputFormat = false;
        HiveTestUtil.hiveSyncConfig.partitionFields = Collections.singletonList("datestr");
        dtfOut = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
        HiveTestUtil.clear();
    }

    public static void clear() throws IOException {
        fileSystem.delete(new Path(HiveTestUtil.hiveSyncConfig.basePath), true);
        HoodieTableMetaClient.initTableType((Configuration)configuration, (String)HiveTestUtil.hiveSyncConfig.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)HiveTestUtil.hiveSyncConfig.tableName, (String)HoodieAvroPayload.class.getName());
        HoodieHiveClient client = new HoodieHiveClient(hiveSyncConfig, hiveServer.getHiveConf(), fileSystem);
        for (String tableName : createdTablesSet) {
            client.updateHiveSQL("drop table if exists " + tableName);
        }
        createdTablesSet.clear();
        client.updateHiveSQL("drop database if exists " + HiveTestUtil.hiveSyncConfig.databaseName);
        client.updateHiveSQL("create database " + HiveTestUtil.hiveSyncConfig.databaseName);
    }

    public static HiveConf getHiveConf() {
        return hiveServer.getHiveConf();
    }

    public static void shutdown() {
        if (hiveServer != null) {
            hiveServer.stop();
        }
        if (hiveTestService != null) {
            hiveTestService.stop();
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
        if (zkServer != null) {
            zkServer.shutdown();
        }
    }

    public static void createCOWTable(String instantTime, int numberOfPartitions, boolean useSchemaFromCommitMetadata) throws IOException, URISyntaxException {
        Path path = new Path(HiveTestUtil.hiveSyncConfig.basePath);
        FileIOUtils.deleteDirectory((File)new File(HiveTestUtil.hiveSyncConfig.basePath));
        HoodieTableMetaClient.initTableType((Configuration)configuration, (String)HiveTestUtil.hiveSyncConfig.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)HiveTestUtil.hiveSyncConfig.tableName, (String)HoodieAvroPayload.class.getName());
        boolean result = fileSystem.mkdirs(path);
        HiveTestUtil.checkResult(result);
        DateTime dateTime = DateTime.now();
        HoodieCommitMetadata commitMetadata = HiveTestUtil.createPartitions(numberOfPartitions, true, useSchemaFromCommitMetadata, dateTime, instantTime);
        createdTablesSet.add(HiveTestUtil.hiveSyncConfig.databaseName + "." + HiveTestUtil.hiveSyncConfig.tableName);
        HiveTestUtil.createCommitFile(commitMetadata, instantTime);
    }

    public static void createMORTable(String commitTime, String deltaCommitTime, int numberOfPartitions, boolean createDeltaCommit, boolean useSchemaFromCommitMetadata) throws IOException, URISyntaxException, InterruptedException {
        Path path = new Path(HiveTestUtil.hiveSyncConfig.basePath);
        FileIOUtils.deleteDirectory((File)new File(HiveTestUtil.hiveSyncConfig.basePath));
        HoodieTableMetaClient.initTableType((Configuration)configuration, (String)HiveTestUtil.hiveSyncConfig.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ, (String)HiveTestUtil.hiveSyncConfig.tableName, (String)HoodieAvroPayload.class.getName());
        boolean result = fileSystem.mkdirs(path);
        HiveTestUtil.checkResult(result);
        DateTime dateTime = DateTime.now();
        HoodieCommitMetadata commitMetadata = HiveTestUtil.createPartitions(numberOfPartitions, true, useSchemaFromCommitMetadata, dateTime, commitTime);
        createdTablesSet.add(HiveTestUtil.hiveSyncConfig.databaseName + "." + HiveTestUtil.hiveSyncConfig.tableName);
        createdTablesSet.add(HiveTestUtil.hiveSyncConfig.databaseName + "." + HiveTestUtil.hiveSyncConfig.tableName + "_rt");
        HoodieCommitMetadata compactionMetadata = new HoodieCommitMetadata();
        commitMetadata.getPartitionToWriteStats().forEach((key, value) -> value.forEach(l -> compactionMetadata.addWriteStat(key, l)));
        HiveTestUtil.addSchemaToCommitMetadata(compactionMetadata, commitMetadata.getMetadata("schema"), useSchemaFromCommitMetadata);
        HiveTestUtil.createCompactionCommitFile(compactionMetadata, commitTime);
        if (createDeltaCommit) {
            HoodieCommitMetadata deltaMetadata = HiveTestUtil.createLogFiles(commitMetadata.getPartitionToWriteStats(), true, useSchemaFromCommitMetadata);
            HiveTestUtil.createDeltaCommitFile(deltaMetadata, deltaCommitTime);
        }
    }

    public static void addCOWPartitions(int numberOfPartitions, boolean isParquetSchemaSimple, boolean useSchemaFromCommitMetadata, DateTime startFrom, String instantTime) throws IOException, URISyntaxException {
        HoodieCommitMetadata commitMetadata = HiveTestUtil.createPartitions(numberOfPartitions, isParquetSchemaSimple, useSchemaFromCommitMetadata, startFrom, instantTime);
        createdTablesSet.add(HiveTestUtil.hiveSyncConfig.databaseName + "." + HiveTestUtil.hiveSyncConfig.tableName);
        HiveTestUtil.createCommitFile(commitMetadata, instantTime);
    }

    public static void addMORPartitions(int numberOfPartitions, boolean isParquetSchemaSimple, boolean isLogSchemaSimple, boolean useSchemaFromCommitMetadata, DateTime startFrom, String instantTime, String deltaCommitTime) throws IOException, URISyntaxException, InterruptedException {
        HoodieCommitMetadata commitMetadata = HiveTestUtil.createPartitions(numberOfPartitions, isParquetSchemaSimple, useSchemaFromCommitMetadata, startFrom, instantTime);
        createdTablesSet.add(HiveTestUtil.hiveSyncConfig.databaseName + "." + HiveTestUtil.hiveSyncConfig.tableName + "_ro");
        createdTablesSet.add(HiveTestUtil.hiveSyncConfig.databaseName + "." + HiveTestUtil.hiveSyncConfig.tableName + "_rt");
        HoodieCommitMetadata compactionMetadata = new HoodieCommitMetadata();
        commitMetadata.getPartitionToWriteStats().forEach((key, value) -> value.forEach(l -> compactionMetadata.addWriteStat(key, l)));
        HiveTestUtil.addSchemaToCommitMetadata(compactionMetadata, commitMetadata.getMetadata("schema"), useSchemaFromCommitMetadata);
        HiveTestUtil.createCompactionCommitFile(compactionMetadata, instantTime);
        HoodieCommitMetadata deltaMetadata = HiveTestUtil.createLogFiles(commitMetadata.getPartitionToWriteStats(), isLogSchemaSimple, useSchemaFromCommitMetadata);
        HiveTestUtil.createDeltaCommitFile(deltaMetadata, deltaCommitTime);
    }

    private static HoodieCommitMetadata createLogFiles(Map<String, List<HoodieWriteStat>> partitionWriteStats, boolean isLogSchemaSimple, boolean useSchemaFromCommitMetadata) throws InterruptedException, IOException, URISyntaxException {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        for (Map.Entry<String, List<HoodieWriteStat>> wEntry : partitionWriteStats.entrySet()) {
            String partitionPath = wEntry.getKey();
            for (HoodieWriteStat wStat : wEntry.getValue()) {
                Path path = new Path(wStat.getPath());
                HoodieBaseFile dataFile = new HoodieBaseFile(fileSystem.getFileStatus(path));
                HoodieLogFile logFile = HiveTestUtil.generateLogData(path, isLogSchemaSimple);
                HoodieDeltaWriteStat writeStat = new HoodieDeltaWriteStat();
                writeStat.setFileId(dataFile.getFileId());
                writeStat.setPath(logFile.getPath().toString());
                commitMetadata.addWriteStat(partitionPath, (HoodieWriteStat)writeStat);
            }
        }
        HiveTestUtil.addSchemaToCommitMetadata(commitMetadata, isLogSchemaSimple, useSchemaFromCommitMetadata);
        return commitMetadata;
    }

    private static HoodieCommitMetadata createPartitions(int numberOfPartitions, boolean isParquetSchemaSimple, boolean useSchemaFromCommitMetadata, DateTime startFrom, String instantTime) throws IOException, URISyntaxException {
        startFrom = startFrom.withTimeAtStartOfDay();
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        for (int i = 0; i < numberOfPartitions; ++i) {
            String partitionPath = dtfOut.print((ReadableInstant)startFrom);
            Path partPath = new Path(HiveTestUtil.hiveSyncConfig.basePath + "/" + partitionPath);
            fileSystem.makeQualified(partPath);
            fileSystem.mkdirs(partPath);
            List<HoodieWriteStat> writeStats = HiveTestUtil.createTestData(partPath, isParquetSchemaSimple, instantTime);
            startFrom = startFrom.minusDays(1);
            writeStats.forEach(s -> commitMetadata.addWriteStat(partitionPath, s));
        }
        HiveTestUtil.addSchemaToCommitMetadata(commitMetadata, isParquetSchemaSimple, useSchemaFromCommitMetadata);
        return commitMetadata;
    }

    private static List<HoodieWriteStat> createTestData(Path partPath, boolean isParquetSchemaSimple, String instantTime) throws IOException, URISyntaxException {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        for (int i = 0; i < 5; ++i) {
            String fileId = UUID.randomUUID().toString();
            Path filePath = new Path(partPath.toString() + "/" + FSUtils.makeDataFileName((String)instantTime, (String)"1-0-1", (String)fileId));
            HiveTestUtil.generateParquetData(filePath, isParquetSchemaSimple);
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setFileId(fileId);
            writeStat.setPath(filePath.toString());
            writeStats.add(writeStat);
        }
        return writeStats;
    }

    private static void generateParquetData(Path filePath, boolean isParquetSchemaSimple) throws IOException, URISyntaxException {
        Schema schema = HiveTestUtil.getTestDataSchema(isParquetSchemaSimple);
        MessageType parquetSchema = new AvroSchemaConverter().convert(schema);
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-4, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(parquetSchema, schema, filter);
        ParquetWriter writer = new ParquetWriter(filePath, (WriteSupport)writeSupport, CompressionCodecName.GZIP, 0x7800000, 0x100000, 0x100000, true, false, ParquetWriter.DEFAULT_WRITER_VERSION, fileSystem.getConf());
        List testRecords = isParquetSchemaSimple ? SchemaTestUtil.generateTestRecords((int)0, (int)100) : SchemaTestUtil.generateEvolvedTestRecords((int)100, (int)100);
        testRecords.forEach(s -> {
            try {
                writer.write(s);
            }
            catch (IOException e) {
                Assertions.fail((String)("IOException while writing test records as parquet" + e.toString()));
            }
        });
        writer.close();
    }

    private static HoodieLogFile generateLogData(Path parquetFilePath, boolean isLogSchemaSimple) throws IOException, InterruptedException, URISyntaxException {
        Schema schema = HiveTestUtil.getTestDataSchema(isLogSchemaSimple);
        HoodieBaseFile dataFile = new HoodieBaseFile(fileSystem.getFileStatus(parquetFilePath));
        HoodieLogFormat.Writer logWriter = HoodieLogFormat.newWriterBuilder().onParentPath(parquetFilePath.getParent()).withFileExtension(".log").withFileId(dataFile.getFileId()).overBaseCommit(dataFile.getCommitTime()).withFs(fileSystem).build();
        List records = isLogSchemaSimple ? SchemaTestUtil.generateTestRecords((int)0, (int)100) : SchemaTestUtil.generateEvolvedTestRecords((int)100, (int)100);
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(2);
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, dataFile.getCommitTime());
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, schema.toString());
        HoodieAvroDataBlock dataBlock = new HoodieAvroDataBlock(records, header);
        logWriter.appendBlock((HoodieLogBlock)dataBlock);
        logWriter.close();
        return logWriter.getLogFile();
    }

    private static Schema getTestDataSchema(boolean isSimpleSchema) throws IOException {
        return isSimpleSchema ? SchemaTestUtil.getSimpleSchema() : SchemaTestUtil.getEvolvedSchema();
    }

    private static void addSchemaToCommitMetadata(HoodieCommitMetadata commitMetadata, boolean isSimpleSchema, boolean useSchemaFromCommitMetadata) throws IOException {
        if (useSchemaFromCommitMetadata) {
            Schema dataSchema = HiveTestUtil.getTestDataSchema(isSimpleSchema);
            commitMetadata.addMetadata("schema", dataSchema.toString());
        }
    }

    private static void addSchemaToCommitMetadata(HoodieCommitMetadata commitMetadata, String schema, boolean useSchemaFromCommitMetadata) {
        if (useSchemaFromCommitMetadata) {
            commitMetadata.addMetadata("schema", schema);
        }
    }

    private static void checkResult(boolean result) {
        if (!result) {
            throw new JUnitException("Could not initialize");
        }
    }

    private static void createCommitFile(HoodieCommitMetadata commitMetadata, String instantTime) throws IOException {
        byte[] bytes = commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8);
        Path fullPath = new Path(HiveTestUtil.hiveSyncConfig.basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeCommitFileName((String)instantTime));
        FSDataOutputStream fsout = fileSystem.create(fullPath, true);
        fsout.write(bytes);
        fsout.close();
    }

    private static void createCompactionCommitFile(HoodieCommitMetadata commitMetadata, String instantTime) throws IOException {
        byte[] bytes = commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8);
        Path fullPath = new Path(HiveTestUtil.hiveSyncConfig.basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeCommitFileName((String)instantTime));
        FSDataOutputStream fsout = fileSystem.create(fullPath, true);
        fsout.write(bytes);
        fsout.close();
    }

    private static void createDeltaCommitFile(HoodieCommitMetadata deltaCommitMetadata, String deltaCommitTime) throws IOException {
        byte[] bytes = deltaCommitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8);
        Path fullPath = new Path(HiveTestUtil.hiveSyncConfig.basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeDeltaFileName((String)deltaCommitTime));
        FSDataOutputStream fsout = fileSystem.create(fullPath, true);
        fsout.write(bytes);
        fsout.close();
    }

    public static Set<String> getCreatedTablesSet() {
        return createdTablesSet;
    }

    static {
        createdTablesSet = new HashSet<String>();
    }
}

