/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import com.beust.jcommander.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor;

public class HiveSyncConfig
implements Serializable {
    @Parameter(names={"--database"}, description="name of the target database in Hive", required=true)
    public String databaseName;
    @Parameter(names={"--table"}, description="name of the target table in Hive", required=true)
    public String tableName;
    @Parameter(names={"--base-file-format"}, description="Format of the base files (PARQUET (or) HFILE)")
    public String baseFileFormat = "PARQUET";
    @Parameter(names={"--user"}, description="Hive username", required=true)
    public String hiveUser;
    @Parameter(names={"--pass"}, description="Hive password", required=true)
    public String hivePass;
    @Parameter(names={"--jdbc-url"}, description="Hive jdbc connect url", required=true)
    public String jdbcUrl;
    @Parameter(names={"--base-path"}, description="Basepath of hoodie table to sync", required=true)
    public String basePath;
    @Parameter(names={"--partitioned-by"}, description="Fields in the schema partitioned by")
    public List<String> partitionFields = new ArrayList<String>();
    @Parameter(names={"--partition-value-extractor"}, description="Class which implements PartitionValueExtractor to extract the partition values from HDFS path")
    public String partitionValueExtractorClass = SlashEncodedDayPartitionValueExtractor.class.getName();
    @Parameter(names={"--assume-date-partitioning"}, description="Assume standard yyyy/mm/dd partitioning, this exists to support backward compatibility. If you use hoodie 0.3.x, do not set this parameter")
    public Boolean assumeDatePartitioning = false;
    @Parameter(names={"--use-pre-apache-input-format"}, description="Use InputFormat under com.uber.hoodie package instead of org.apache.hudi package. Use this when you are in the process of migrating from com.uber.hoodie to org.apache.hudi. Stop using this after you migrated the table definition to org.apache.hudi input format.")
    public Boolean usePreApacheInputFormat = false;
    @Parameter(names={"--use-jdbc"}, description="Hive jdbc connect url")
    public Boolean useJdbc = true;
    @Parameter(names={"--auto-create-database"}, description="Auto create hive database")
    public Boolean autoCreateDatabase = true;
    @Parameter(names={"--skip-ro-suffix"}, description="Skip the `_ro` suffix for Read optimized table, when registering")
    public Boolean skipROSuffix = false;
    @Parameter(names={"--help", "-h"}, help=true)
    public Boolean help = false;
    @Parameter(names={"--support-timestamp"}, description="'INT64' with original type TIMESTAMP_MICROS is converted to hive 'timestamp' type.Disabled by default for backward compatibility.")
    public Boolean supportTimestamp = false;

    public static HiveSyncConfig copy(HiveSyncConfig cfg) {
        HiveSyncConfig newConfig = new HiveSyncConfig();
        newConfig.basePath = cfg.basePath;
        newConfig.assumeDatePartitioning = cfg.assumeDatePartitioning;
        newConfig.databaseName = cfg.databaseName;
        newConfig.hivePass = cfg.hivePass;
        newConfig.hiveUser = cfg.hiveUser;
        newConfig.partitionFields = cfg.partitionFields;
        newConfig.partitionValueExtractorClass = cfg.partitionValueExtractorClass;
        newConfig.jdbcUrl = cfg.jdbcUrl;
        newConfig.tableName = cfg.tableName;
        newConfig.usePreApacheInputFormat = cfg.usePreApacheInputFormat;
        newConfig.supportTimestamp = cfg.supportTimestamp;
        return newConfig;
    }

    public String toString() {
        return "HiveSyncConfig{databaseName='" + this.databaseName + '\'' + ", tableName='" + this.tableName + '\'' + ", hiveUser='" + this.hiveUser + '\'' + ", hivePass='" + this.hivePass + '\'' + ", jdbcUrl='" + this.jdbcUrl + '\'' + ", basePath='" + this.basePath + '\'' + ", partitionFields=" + this.partitionFields + ", partitionValueExtractorClass='" + this.partitionValueExtractorClass + '\'' + ", assumeDatePartitioning=" + this.assumeDatePartitioning + '\'' + ", supportTimestamp='" + this.supportTimestamp + '\'' + ", usePreApacheInputFormat=" + this.usePreApacheInputFormat + ", useJdbc=" + this.useJdbc + ", help=" + this.help + '}';
    }
}

