/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.testutils;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.thrift.TUGIContainingTransport;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class HiveTestService {
    private static final Logger LOG = LogManager.getLogger(HiveTestService.class);
    private static final int CONNECTION_TIMEOUT = 30000;
    private Configuration hadoopConf;
    private String workDir;
    private String bindIP = "127.0.0.1";
    private int metastorePort = 9083;
    private int serverPort = 9999;
    private boolean clean = true;
    private Map<String, String> sysProps = new HashMap<String, String>();
    private ExecutorService executorService;
    private TServer tServer;
    private HiveServer2 hiveServer;

    public HiveTestService(Configuration configuration) throws IOException {
        this.workDir = Files.createTempDirectory(System.currentTimeMillis() + "-", new FileAttribute[0]).toFile().getAbsolutePath();
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public HiveServer2 start() throws IOException {
        Objects.requireNonNull(this.workDir, "The work dir must be set before starting cluster.");
        if (this.hadoopConf == null) {
            this.hadoopConf = HoodieTestUtils.getDefaultHadoopConf();
        }
        String localHiveLocation = HiveTestService.getHiveLocation(this.workDir);
        if (this.clean) {
            LOG.info((Object)("Cleaning Hive cluster data at: " + localHiveLocation + " and starting fresh."));
            File file = new File(localHiveLocation);
            FileIOUtils.deleteDirectory((File)file);
        }
        HiveConf serverConf = this.configureHive(this.hadoopConf, localHiveLocation);
        this.executorService = Executors.newSingleThreadExecutor();
        this.tServer = this.startMetaStore(this.bindIP, this.metastorePort, serverConf);
        serverConf.set("hive.in.test", "true");
        this.hiveServer = this.startHiveServer(serverConf);
        String serverHostname = this.bindIP.equals("0.0.0.0") ? "localhost" : this.bindIP;
        if (!this.waitForServerUp(serverConf, serverHostname, this.metastorePort, 30000)) {
            throw new IOException("Waiting for startup of standalone server");
        }
        LOG.info((Object)"Hive Minicluster service started.");
        return this.hiveServer;
    }

    public void stop() {
        this.resetSystemProperties();
        if (this.tServer != null) {
            try {
                this.tServer.stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Stop meta store failed", (Throwable)e);
            }
        }
        if (this.hiveServer != null) {
            try {
                this.hiveServer.stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Stop hive server failed", (Throwable)e);
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        LOG.info((Object)"Hive Minicluster service shut down.");
        this.tServer = null;
        this.hiveServer = null;
        this.hadoopConf = null;
    }

    private HiveConf configureHive(Configuration conf, String localHiveLocation) throws IOException {
        conf.set("hive.metastore.local", "false");
        conf.set(HiveConf.ConfVars.METASTOREURIS.varname, "thrift://" + this.bindIP + ":" + this.metastorePort);
        conf.set(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname, this.bindIP);
        conf.setInt(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, this.serverPort);
        File localHiveDir = new File(localHiveLocation);
        localHiveDir.mkdirs();
        File metastoreDbDir = new File(localHiveDir, "metastore_db");
        conf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:" + metastoreDbDir.getPath() + ";create=true");
        File derbyLogFile = new File(localHiveDir, "derby.log");
        derbyLogFile.createNewFile();
        this.setSystemProperty("derby.stream.error.file", derbyLogFile.getPath());
        this.setSystemProperty("derby.system.home", localHiveDir.getAbsolutePath());
        conf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, Files.createTempDirectory(System.currentTimeMillis() + "-", new FileAttribute[0]).toFile().getAbsolutePath());
        conf.set("datanucleus.schema.autoCreateTables", "true");
        conf.set("hive.metastore.schema.verification", "false");
        conf.set("datanucleus.autoCreateSchema", "true");
        conf.set("datanucleus.fixedDatastore", "false");
        this.setSystemProperty("derby.stream.error.file", derbyLogFile.getPath());
        return new HiveConf(conf, this.getClass(), true);
    }

    private boolean waitForServerUp(HiveConf serverConf, String hostname, int port, int timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                new HiveMetaStoreClient((Configuration)serverConf);
                return true;
            }
            catch (MetaException e) {
                LOG.info((Object)("server " + hostname + ":" + port + " not up " + (Object)((Object)e)));
                if (System.currentTimeMillis() <= start + (long)timeout) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                return false;
            }
            break;
        }
    }

    private void setSystemProperty(String name, String value) {
        if (!this.sysProps.containsKey(name)) {
            String currentValue = System.getProperty(name);
            this.sysProps.put(name, currentValue);
        }
        if (value != null) {
            System.setProperty(name, value);
        } else {
            System.getProperties().remove(name);
        }
    }

    private void resetSystemProperties() {
        for (Map.Entry<String, String> entry : this.sysProps.entrySet()) {
            if (entry.getValue() != null) {
                System.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            System.getProperties().remove(entry.getKey());
        }
        this.sysProps.clear();
    }

    private static String getHiveLocation(String baseLocation) {
        return baseLocation + "/" + "hive";
    }

    private HiveServer2 startHiveServer(HiveConf serverConf) {
        HiveServer2 hiveServer = new HiveServer2();
        hiveServer.init(serverConf);
        hiveServer.start();
        return hiveServer;
    }

    public TServer startMetaStore(String forceBindIP, int port, HiveConf conf) throws IOException {
        try {
            TUGIBasedProcessor processor;
            ChainedTTransportFactory transFactory;
            TServerSocketKeepAlive serverTransport;
            int minWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMINTHREADS);
            int maxWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMAXTHREADS);
            boolean tcpKeepAlive = conf.getBoolVar(HiveConf.ConfVars.METASTORE_TCP_KEEP_ALIVE);
            boolean useFramedTransport = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_FRAMED_TRANSPORT);
            if (forceBindIP != null) {
                InetSocketAddress address = new InetSocketAddress(forceBindIP, port);
                serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(address) : new TServerSocket(address);
            } else {
                serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(port) : new TServerSocket(port);
            }
            HiveMetaStore.HMSHandler baseHandler = new HiveMetaStore.HMSHandler("new db based metaserver", (Configuration)conf, false);
            IHMSHandler handler = RetryingHMSHandler.getProxy((Configuration)conf, (IHMSHandler)baseHandler, (boolean)true);
            if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI)) {
                transFactory = useFramedTransport ? new ChainedTTransportFactory((TTransportFactory)new TFramedTransport.Factory(), (TTransportFactory)new TUGIContainingTransport.Factory()) : new TUGIContainingTransport.Factory();
                processor = new TUGIBasedProcessor((ThriftHiveMetastore.Iface)handler);
                LOG.info((Object)"Starting DB backed MetaStore Server with SetUGI enabled");
            } else {
                transFactory = useFramedTransport ? new TFramedTransport.Factory() : new TTransportFactory();
                processor = new TSetIpAddressProcessor((ThriftHiveMetastore.Iface)handler);
                LOG.info((Object)"Starting DB backed MetaStore Server");
            }
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor)).transportFactory((TTransportFactory)transFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(minWorkerThreads).maxWorkerThreads(maxWorkerThreads);
            TThreadPoolServer tServer = new TThreadPoolServer(args);
            this.executorService.submit(() -> ((TServer)tServer).serve());
            return tServer;
        }
        catch (Throwable x) {
            throw new IOException(x);
        }
    }

    private static final class TServerSocketKeepAlive
    extends TServerSocket {
        public TServerSocketKeepAlive(int port) throws TTransportException {
            super(port, 0);
        }

        public TServerSocketKeepAlive(InetSocketAddress address) throws TTransportException {
            super(address, 0);
        }

        protected TSocket acceptImpl() throws TTransportException {
            TSocket ts = super.acceptImpl();
            try {
                ts.getSocket().setKeepAlive(true);
            }
            catch (SocketException e) {
                throw new TTransportException((Throwable)e);
            }
            return ts;
        }
    }

    private static final class ChainedTTransportFactory
    extends TTransportFactory {
        private final TTransportFactory parentTransFactory;
        private final TTransportFactory childTransFactory;

        private ChainedTTransportFactory(TTransportFactory parentTransFactory, TTransportFactory childTransFactory) {
            this.parentTransFactory = parentTransFactory;
            this.childTransFactory = childTransFactory;
        }

        public TTransport getTransport(TTransport trans) {
            return this.childTransFactory.getTransport(this.parentTransFactory.getTransport(trans));
        }
    }
}

