/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.hive.util.ColumnNameXLator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class HiveSchemaUtil {
    private static final Logger LOG = LogManager.getLogger(HiveSchemaUtil.class);
    public static final String HIVE_ESCAPE_CHARACTER = "`";

    public static SchemaDifference getSchemaDifference(MessageType storageSchema, Map<String, String> tableSchema, List<String> partitionKeys) {
        return HiveSchemaUtil.getSchemaDifference(storageSchema, tableSchema, partitionKeys, false);
    }

    public static SchemaDifference getSchemaDifference(MessageType storageSchema, Map<String, String> tableSchema, List<String> partitionKeys, boolean supportTimestamp) {
        Map<String, String> newTableSchema;
        try {
            newTableSchema = HiveSchemaUtil.convertParquetSchemaToHiveSchema(storageSchema, supportTimestamp);
        }
        catch (IOException e) {
            throw new HoodieHiveSyncException("Failed to convert parquet schema to hive schema", e);
        }
        LOG.info((Object)("Getting schema difference for " + tableSchema + "\r\n\r\n" + newTableSchema));
        SchemaDifference.Builder schemaDiffBuilder = SchemaDifference.newBuilder(storageSchema, tableSchema);
        HashSet<String> tableColumns = new HashSet<String>();
        for (Map.Entry<String, String> field : tableSchema.entrySet()) {
            String fieldName = field.getKey().toLowerCase();
            String tickSurroundedFieldName = HiveSchemaUtil.tickSurround(fieldName);
            if (!HiveSchemaUtil.isFieldExistsInSchema(newTableSchema, tickSurroundedFieldName) && !partitionKeys.contains(fieldName)) {
                schemaDiffBuilder.deleteTableColumn(fieldName);
            } else {
                String tableColumnType = field.getValue();
                if (!HiveSchemaUtil.isFieldExistsInSchema(newTableSchema, tickSurroundedFieldName)) {
                    if (partitionKeys.contains(fieldName)) continue;
                    LOG.warn((Object)("Ignoring table column " + fieldName + " as its not present in the parquet schema"));
                    continue;
                }
                tableColumnType = tableColumnType.replaceAll("\\s+", "");
                String expectedType = HiveSchemaUtil.getExpectedType(newTableSchema, tickSurroundedFieldName);
                expectedType = expectedType.replaceAll("\\s+", "");
                if (!tableColumnType.equalsIgnoreCase(expectedType = expectedType.replaceAll(HIVE_ESCAPE_CHARACTER, ""))) {
                    if (!HiveSchemaUtil.isSchemaTypeUpdateAllowed(tableColumnType, expectedType)) {
                        throw new HoodieHiveSyncException("Could not convert field Type from " + tableColumnType + " to " + expectedType + " for field " + fieldName);
                    }
                    schemaDiffBuilder.updateTableColumn(fieldName, HiveSchemaUtil.getExpectedType(newTableSchema, tickSurroundedFieldName));
                }
            }
            tableColumns.add(tickSurroundedFieldName);
        }
        for (Map.Entry<String, String> entry : newTableSchema.entrySet()) {
            if (tableColumns.contains(entry.getKey().toLowerCase())) continue;
            schemaDiffBuilder.addTableColumn(entry.getKey(), entry.getValue());
        }
        LOG.info((Object)("Difference between schemas: " + schemaDiffBuilder.build().toString()));
        return schemaDiffBuilder.build();
    }

    private static String getExpectedType(Map<String, String> newTableSchema, String fieldName) {
        for (Map.Entry<String, String> entry : newTableSchema.entrySet()) {
            if (!entry.getKey().toLowerCase().equals(fieldName)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static boolean isFieldExistsInSchema(Map<String, String> newTableSchema, String fieldName) {
        for (String entry : newTableSchema.keySet()) {
            if (!entry.toLowerCase().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> convertParquetSchemaToHiveSchema(MessageType messageType, boolean supportTimestamp) throws IOException {
        LinkedHashMap<String, String> schema = new LinkedHashMap<String, String>();
        List parquetFields = messageType.getFields();
        for (Type parquetType : parquetFields) {
            StringBuilder result = new StringBuilder();
            String key = parquetType.getName();
            if (parquetType.isRepetition(Type.Repetition.REPEATED)) {
                result.append(HiveSchemaUtil.createHiveArray(parquetType, "", supportTimestamp));
            } else {
                result.append(HiveSchemaUtil.convertField(parquetType, supportTimestamp));
            }
            schema.put(HiveSchemaUtil.hiveCompatibleFieldName(key, false), result.toString());
        }
        return schema;
    }

    private static String convertField(Type parquetType, boolean supportTimestamp) {
        StringBuilder field = new StringBuilder();
        if (parquetType.isPrimitive()) {
            PrimitiveType.PrimitiveTypeName parquetPrimitiveTypeName = parquetType.asPrimitiveType().getPrimitiveTypeName();
            final OriginalType originalType = parquetType.getOriginalType();
            if (originalType == OriginalType.DECIMAL) {
                DecimalMetadata decimalMetadata = parquetType.asPrimitiveType().getDecimalMetadata();
                return field.append("DECIMAL(").append(decimalMetadata.getPrecision()).append(" , ").append(decimalMetadata.getScale()).append(")").toString();
            }
            if (originalType == OriginalType.DATE) {
                return field.append("DATE").toString();
            }
            if (supportTimestamp && originalType == OriginalType.TIMESTAMP_MICROS) {
                return field.append("TIMESTAMP").toString();
            }
            return (String)parquetPrimitiveTypeName.convert((PrimitiveType.PrimitiveTypeNameConverter)new PrimitiveType.PrimitiveTypeNameConverter<String, RuntimeException>(){

                public String convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return "boolean";
                }

                public String convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return "int";
                }

                public String convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return "bigint";
                }

                public String convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return "timestamp-millis";
                }

                public String convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return "float";
                }

                public String convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return "double";
                }

                public String convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return "binary";
                }

                public String convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    if (originalType == OriginalType.UTF8 || originalType == OriginalType.ENUM) {
                        return "string";
                    }
                    return "binary";
                }
            });
        }
        GroupType parquetGroupType = parquetType.asGroupType();
        OriginalType originalType = parquetGroupType.getOriginalType();
        if (originalType != null) {
            switch (originalType) {
                case LIST: {
                    if (parquetGroupType.getFieldCount() != 1) {
                        throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                    }
                    Type elementType = parquetGroupType.getType(0);
                    if (!elementType.isRepetition(Type.Repetition.REPEATED)) {
                        throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                    }
                    return HiveSchemaUtil.createHiveArray(elementType, parquetGroupType.getName(), supportTimestamp);
                }
                case MAP: {
                    if (parquetGroupType.getFieldCount() != 1 || parquetGroupType.getType(0).isPrimitive()) {
                        throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                    }
                    GroupType mapKeyValType = parquetGroupType.getType(0).asGroupType();
                    if (!mapKeyValType.isRepetition(Type.Repetition.REPEATED) || !mapKeyValType.getOriginalType().equals((Object)OriginalType.MAP_KEY_VALUE) || mapKeyValType.getFieldCount() != 2) {
                        throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                    }
                    Type keyType = mapKeyValType.getType(0);
                    if (!(keyType.isPrimitive() && keyType.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY) && keyType.getOriginalType().equals((Object)OriginalType.UTF8))) {
                        throw new UnsupportedOperationException("Map key type must be binary (UTF8): " + keyType);
                    }
                    Type valueType = mapKeyValType.getType(1);
                    return HiveSchemaUtil.createHiveMap(HiveSchemaUtil.convertField(keyType, supportTimestamp), HiveSchemaUtil.convertField(valueType, supportTimestamp));
                }
                case ENUM: 
                case UTF8: {
                    return "string";
                }
            }
            throw new UnsupportedOperationException("Cannot convert Parquet type " + parquetType);
        }
        return HiveSchemaUtil.createHiveStruct(parquetGroupType.getFields(), supportTimestamp);
    }

    private static String createHiveStruct(List<Type> parquetFields, boolean supportTimestamp) {
        StringBuilder struct = new StringBuilder();
        struct.append("STRUCT< ");
        for (Type field : parquetFields) {
            struct.append(HiveSchemaUtil.hiveCompatibleFieldName(field.getName(), true)).append(" : ");
            struct.append(HiveSchemaUtil.convertField(field, supportTimestamp)).append(", ");
        }
        struct.delete(struct.length() - 2, struct.length());
        struct.append(">");
        String finalStr = struct.toString();
        finalStr = finalStr.replaceAll("-", "_");
        return finalStr;
    }

    private static String hiveCompatibleFieldName(String fieldName, boolean isNested) {
        String result = fieldName;
        if (isNested) {
            result = ColumnNameXLator.translateNestedColumn(fieldName);
        }
        return HiveSchemaUtil.tickSurround(result);
    }

    private static String tickSurround(String result) {
        if (!result.startsWith(HIVE_ESCAPE_CHARACTER)) {
            result = HIVE_ESCAPE_CHARACTER + result;
        }
        if (!result.endsWith(HIVE_ESCAPE_CHARACTER)) {
            result = result + HIVE_ESCAPE_CHARACTER;
        }
        return result;
    }

    private static String removeSurroundingTick(String result) {
        if (result.startsWith(HIVE_ESCAPE_CHARACTER) && result.endsWith(HIVE_ESCAPE_CHARACTER)) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    private static String createHiveMap(String keyType, String valueType) {
        return "MAP< " + keyType + ", " + valueType + ">";
    }

    private static String createHiveArray(Type elementType, String elementName, boolean supportTimestamp) {
        StringBuilder array = new StringBuilder();
        array.append("ARRAY< ");
        if (elementType.isPrimitive()) {
            array.append(HiveSchemaUtil.convertField(elementType, supportTimestamp));
        } else {
            GroupType groupType = elementType.asGroupType();
            List groupFields = groupType.getFields();
            if (groupFields.size() > 1 || groupFields.size() == 1 && (elementType.getName().equals("array") || elementType.getName().equals(elementName + "_tuple"))) {
                array.append(HiveSchemaUtil.convertField(elementType, supportTimestamp));
            } else {
                array.append(HiveSchemaUtil.convertField((Type)groupType.getFields().get(0), supportTimestamp));
            }
        }
        array.append(">");
        return array.toString();
    }

    public static boolean isSchemaTypeUpdateAllowed(String prevType, String newType) {
        if (prevType == null || prevType.trim().isEmpty() || newType == null || newType.trim().isEmpty()) {
            return false;
        }
        if ((prevType = prevType.toLowerCase()).equals(newType = newType.toLowerCase())) {
            return true;
        }
        if (prevType.equalsIgnoreCase("int") && newType.equalsIgnoreCase("bigint")) {
            return true;
        }
        if (prevType.equalsIgnoreCase("float") && newType.equalsIgnoreCase("double")) {
            return true;
        }
        return prevType.contains("struct") && newType.toLowerCase().contains("struct");
    }

    public static String generateSchemaString(MessageType storageSchema) throws IOException {
        return HiveSchemaUtil.generateSchemaString(storageSchema, Collections.EMPTY_LIST);
    }

    public static String generateSchemaString(MessageType storageSchema, List<String> colsToSkip) throws IOException {
        return HiveSchemaUtil.generateSchemaString(storageSchema, colsToSkip, false);
    }

    public static String generateSchemaString(MessageType storageSchema, List<String> colsToSkip, boolean supportTimestamp) throws IOException {
        Map<String, String> hiveSchema = HiveSchemaUtil.convertParquetSchemaToHiveSchema(storageSchema, supportTimestamp);
        StringBuilder columns = new StringBuilder();
        for (Map.Entry<String, String> hiveSchemaEntry : hiveSchema.entrySet()) {
            if (colsToSkip.contains(HiveSchemaUtil.removeSurroundingTick(hiveSchemaEntry.getKey()))) continue;
            columns.append(hiveSchemaEntry.getKey()).append(" ");
            columns.append(hiveSchemaEntry.getValue()).append(", ");
        }
        columns.delete(columns.length() - 2, columns.length());
        return columns.toString();
    }

    public static String generateCreateDDL(String tableName, MessageType storageSchema, HiveSyncConfig config, String inputFormatClass, String outputFormatClass, String serdeClass) throws IOException {
        Map<String, String> hiveSchema = HiveSchemaUtil.convertParquetSchemaToHiveSchema(storageSchema, config.supportTimestamp);
        String columns = HiveSchemaUtil.generateSchemaString(storageSchema, config.partitionFields, config.supportTimestamp);
        ArrayList<String> partitionFields = new ArrayList<String>();
        for (String partitionKey : config.partitionFields) {
            String partitionKeyWithTicks = HiveSchemaUtil.tickSurround(partitionKey);
            partitionFields.add(partitionKeyWithTicks + " " + HiveSchemaUtil.getPartitionKeyType(hiveSchema, partitionKeyWithTicks));
        }
        String partitionsStr = String.join((CharSequence)",", partitionFields);
        StringBuilder sb = new StringBuilder("CREATE EXTERNAL TABLE  IF NOT EXISTS ");
        sb.append(HIVE_ESCAPE_CHARACTER).append(config.databaseName).append(HIVE_ESCAPE_CHARACTER).append(".").append(HIVE_ESCAPE_CHARACTER).append(tableName).append(HIVE_ESCAPE_CHARACTER);
        sb.append("( ").append(columns).append(")");
        if (!config.partitionFields.isEmpty()) {
            sb.append(" PARTITIONED BY (").append(partitionsStr).append(")");
        }
        sb.append(" ROW FORMAT SERDE '").append(serdeClass).append("'");
        sb.append(" STORED AS INPUTFORMAT '").append(inputFormatClass).append("'");
        sb.append(" OUTPUTFORMAT '").append(outputFormatClass).append("' LOCATION '").append(config.basePath).append("'");
        return sb.toString();
    }

    private static String getPartitionKeyType(Map<String, String> hiveSchema, String partitionKey) {
        if (hiveSchema.containsKey(partitionKey)) {
            return hiveSchema.get(partitionKey);
        }
        return "String";
    }
}

