/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import org.apache.hudi.sync.common.util.Parquet2SparkSchemaUtils;
import org.apache.parquet.schema.GroupType;
import org.apache.spark.sql.execution.SparkSqlParser;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParquetToSparkSchemaUtils {
    private final SparkToParquetSchemaConverter sparkToParquetConverter = new SparkToParquetSchemaConverter(new SQLConf());
    private final SparkSqlParser parser = TestParquetToSparkSchemaUtils.createSqlParser();

    private static SparkSqlParser createSqlParser() {
        try {
            return (SparkSqlParser)SparkSqlParser.class.getDeclaredConstructor(SQLConf.class).newInstance(new SQLConf());
        }
        catch (Exception ne) {
            try {
                return (SparkSqlParser)SparkSqlParser.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testConvertPrimitiveType() {
        StructType sparkSchema = this.parser.parseTableSchema("f0 int, f1 string, f3 bigint, f4 decimal(5,2), f5 timestamp, f6 date, f7 short, f8 float, f9 double, f10 byte, f11 tinyint, f12 smallint, f13 binary, f14 boolean");
        String sparkSchemaJson = Parquet2SparkSchemaUtils.convertToSparkSchemaJson((GroupType)this.sparkToParquetConverter.convert(sparkSchema).asGroupType());
        StructType convertedSparkSchema = (StructType)StructType.fromJson((String)sparkSchemaJson);
        Assertions.assertEquals((Object)sparkSchema.json(), (Object)convertedSparkSchema.json());
        StructField field0 = new StructField("f0", (DataType)StringType$.MODULE$, false, Metadata.empty());
        StructField field1 = new StructField("f1", (DataType)StringType$.MODULE$, true, Metadata.empty());
        StructType sparkSchemaWithNullable = new StructType(new StructField[]{field0, field1});
        String sparkSchemaWithNullableJson = Parquet2SparkSchemaUtils.convertToSparkSchemaJson((GroupType)this.sparkToParquetConverter.convert(sparkSchemaWithNullable).asGroupType());
        StructType convertedSparkSchemaWithNullable = (StructType)StructType.fromJson((String)sparkSchemaWithNullableJson);
        Assertions.assertEquals((Object)sparkSchemaWithNullable.json(), (Object)convertedSparkSchemaWithNullable.json());
    }

    @Test
    public void testConvertComplexType() {
        StructType sparkSchema = this.parser.parseTableSchema("f0 int, f1 map<string, int>, f2 array<decimal(10,2)>,f3 map<array<date>, bigint>, f4 array<array<double>>,f5 struct<id:int, name:string>");
        String sparkSchemaJson = Parquet2SparkSchemaUtils.convertToSparkSchemaJson((GroupType)this.sparkToParquetConverter.convert(sparkSchema).asGroupType());
        StructType convertedSparkSchema = (StructType)StructType.fromJson((String)sparkSchemaJson);
        Assertions.assertEquals((Object)sparkSchema.json(), (Object)convertedSparkSchema.json());
        StructField field0 = new StructField("f0", (DataType)new ArrayType((DataType)StringType$.MODULE$, true), false, Metadata.empty());
        StructField field1 = new StructField("f1", (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, true), false, Metadata.empty());
        StructType sparkSchemaWithNullable = new StructType(new StructField[]{field0, field1});
        String sparkSchemaWithNullableJson = Parquet2SparkSchemaUtils.convertToSparkSchemaJson((GroupType)this.sparkToParquetConverter.convert(sparkSchemaWithNullable).asGroupType());
        StructType convertedSparkSchemaWithNullable = (StructType)StructType.fromJson((String)sparkSchemaWithNullableJson);
        Assertions.assertEquals((Object)sparkSchemaWithNullable.json(), (Object)convertedSparkSchemaWithNullable.json());
    }
}

