/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.testutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.testutils.NetworkTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.minicluster.HdfsTestService;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hive.testutils.HiveTestService;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class HiveTestCluster
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    public MiniDFSCluster dfsCluster;
    private HdfsTestService hdfsTestService;
    private HiveTestService hiveTestService;
    private HiveConf conf;
    private HiveServer2 server2;
    private DateTimeFormatter dtfOut;
    private File hiveSiteXml;
    private IMetaStoreClient client;

    public void beforeAll(ExtensionContext context) throws Exception {
        this.setup();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.shutDown();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
    }

    public void afterEach(ExtensionContext context) throws Exception {
    }

    public void setup() throws Exception {
        this.hdfsTestService = new HdfsTestService();
        this.dfsCluster = this.hdfsTestService.start(true);
        Configuration hadoopConf = this.hdfsTestService.getHadoopConf();
        hadoopConf.setInt(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, NetworkTestUtils.nextFreePort());
        this.hiveTestService = new HiveTestService(hadoopConf);
        this.server2 = this.hiveTestService.start();
        this.dtfOut = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        this.hiveSiteXml = File.createTempFile("hive-site", ".xml");
        this.hiveSiteXml.deleteOnExit();
        this.conf = this.hiveTestService.getHiveConf();
        try (FileOutputStream os = new FileOutputStream(this.hiveSiteXml);){
            this.conf.writeXml((OutputStream)os);
        }
        this.client = HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)RetryingMetaStoreClient.getProxy((Configuration)this.conf, (boolean)true));
    }

    public String getHiveSiteXmlLocation() {
        return this.hiveSiteXml.getAbsolutePath();
    }

    public IMetaStoreClient getHMSClient() {
        return this.client;
    }

    public String getHiveJdBcUrl() {
        return this.hiveTestService.getJdbcHive2Url();
    }

    public String tablePath(String dbName, String tableName) throws Exception {
        return this.dbPath(dbName) + "/" + tableName;
    }

    private String dbPath(String dbName) throws Exception {
        return this.dfsCluster.getFileSystem().getWorkingDirectory().toString() + "/" + dbName;
    }

    public void forceCreateDb(String dbName) throws Exception {
        try {
            this.client.dropDatabase(dbName);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Database db = new Database(dbName, "", this.dbPath(dbName), new HashMap());
        this.client.createDatabase(db);
    }

    public void createCOWTable(String commitTime, int numberOfPartitions, String dbName, String tableName) throws Exception {
        String tablePathStr = this.tablePath(dbName, tableName);
        Path path = new Path(tablePathStr);
        FileIOUtils.deleteDirectory((File)new File(path.toString()));
        HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(tableName).setPayloadClass(HoodieAvroPayload.class).initTable(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.conf), path.toString());
        this.dfsCluster.getFileSystem().mkdirs(path);
        ZonedDateTime dateTime = ZonedDateTime.now();
        HoodieCommitMetadata commitMetadata = this.createPartitions(numberOfPartitions, true, dateTime, commitTime, path.toString());
        this.createCommitFile(commitMetadata, commitTime, path.toString());
    }

    private void createCommitFile(HoodieCommitMetadata commitMetadata, String commitTime, String basePath) throws IOException {
        Path fullPath = new Path(basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeCommitFileName(commitTime + "_" + InProcessTimeGenerator.createNewInstantTime()));
        try (FSDataOutputStream fsout = this.dfsCluster.getFileSystem().create(fullPath, true);){
            ((HoodieInstantWriter)HoodieTestUtils.COMMIT_METADATA_SER_DE.getInstantWriter((Object)commitMetadata).get()).writeToStream((OutputStream)fsout);
        }
    }

    private HoodieCommitMetadata createPartitions(int numberOfPartitions, boolean isParquetSchemaSimple, ZonedDateTime startFrom, String commitTime, String basePath) throws IOException, URISyntaxException {
        startFrom = startFrom.truncatedTo(ChronoUnit.DAYS);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        for (int i = 0; i < numberOfPartitions; ++i) {
            String partitionPath = startFrom.format(this.dtfOut);
            Path partPath = new Path(basePath + "/" + partitionPath);
            this.dfsCluster.getFileSystem().makeQualified(partPath);
            this.dfsCluster.getFileSystem().mkdirs(partPath);
            List<HoodieWriteStat> writeStats = this.createTestData(partPath, isParquetSchemaSimple, commitTime);
            startFrom = startFrom.minusDays(1L);
            writeStats.forEach(s -> commitMetadata.addWriteStat(partitionPath, s));
        }
        return commitMetadata;
    }

    private List<HoodieWriteStat> createTestData(Path partPath, boolean isParquetSchemaSimple, String commitTime) throws IOException, URISyntaxException {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        for (int i = 0; i < 5; ++i) {
            String fileId = UUID.randomUUID().toString();
            Path filePath = new Path(partPath.toString() + "/" + FSUtils.makeBaseFileName((String)commitTime, (String)"1-0-1", (String)fileId, (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension()));
            this.generateParquetData(filePath, isParquetSchemaSimple);
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setFileId(fileId);
            writeStat.setPath(filePath.toString());
            writeStats.add(writeStat);
        }
        return writeStats;
    }

    private void generateParquetData(Path filePath, boolean isParquetSchemaSimple) throws IOException, URISyntaxException {
        Schema schema = isParquetSchemaSimple ? SchemaTestUtil.getSimpleSchema() : SchemaTestUtil.getEvolvedSchema();
        MessageType parquetSchema = new AvroSchemaConverter().convert(schema);
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-4, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(parquetSchema, schema, Option.of((Object)filter), new Properties());
        ParquetWriter writer = new ParquetWriter(filePath, (WriteSupport)writeSupport, CompressionCodecName.GZIP, 0x7800000, 0x100000, 0x100000, true, false, ParquetWriter.DEFAULT_WRITER_VERSION, this.dfsCluster.getFileSystem().getConf());
        List testRecords = isParquetSchemaSimple ? SchemaTestUtil.generateTestRecords((int)0, (int)100) : SchemaTestUtil.generateEvolvedTestRecords((int)100, (int)100);
        testRecords.forEach(s -> {
            try {
                writer.write(s);
            }
            catch (IOException e) {
                Assertions.fail((String)"IOException while writing test records as parquet", (Throwable)e);
            }
        });
        writer.close();
    }

    public HiveConf getHiveConf() {
        return this.server2.getHiveConf();
    }

    public void stopHiveServer2() {
        if (this.server2 != null) {
            this.server2.stop();
            this.server2 = null;
        }
    }

    public void startHiveServer2() {
        if (this.server2 == null) {
            this.server2 = new HiveServer2();
            this.server2.init(this.hiveTestService.getHiveConf());
            this.server2.start();
        }
    }

    public void shutDown() throws IOException {
        Files.deleteIfExists(this.hiveSiteXml.toPath());
        Hive.closeCurrent();
        this.hiveTestService.stop();
        this.hdfsTestService.stop();
        FileSystem.closeAll();
    }
}

