/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import org.apache.hudi.expression.BoundReference;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.ExpressionVisitor;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.NameReference;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.internal.schema.Types;

public class FilterGenVisitor
implements ExpressionVisitor<String> {
    private String makeBinaryOperatorString(String left, Expression.Operator operator, String right) {
        return String.format("%s %s %s", left, operator.sqlOperator, right);
    }

    protected String quoteStringLiteral(String value) {
        if (!value.contains("\"")) {
            return "\"" + value + "\"";
        }
        if (!value.contains("'")) {
            return "'" + value + "'";
        }
        throw new UnsupportedOperationException("Cannot pushdown filters if \" and ' both exist");
    }

    public String visitAnd(Predicates.And and) {
        String leftResult = (String)and.getLeft().accept((ExpressionVisitor)this);
        String rightResult = (String)and.getRight().accept((ExpressionVisitor)this);
        if (leftResult.isEmpty()) {
            if (rightResult.isEmpty()) {
                return "";
            }
            return rightResult;
        }
        if (rightResult.isEmpty()) {
            return leftResult;
        }
        return "(" + this.makeBinaryOperatorString(leftResult, Expression.Operator.AND, rightResult) + ")";
    }

    public String visitOr(Predicates.Or or) {
        String leftResult = (String)or.getLeft().accept((ExpressionVisitor)this);
        String rightResult = (String)or.getRight().accept((ExpressionVisitor)this);
        if (!leftResult.isEmpty() && !rightResult.isEmpty()) {
            return "(" + this.makeBinaryOperatorString(leftResult, Expression.Operator.OR, rightResult) + ")";
        }
        return "";
    }

    private String visitBinaryComparator(Expression left, Expression.Operator operator, Expression right) {
        String leftResult = (String)left.accept((ExpressionVisitor)this);
        String rightResult = (String)right.accept((ExpressionVisitor)this);
        if (!leftResult.isEmpty() && !rightResult.isEmpty()) {
            return this.makeBinaryOperatorString(leftResult, operator, rightResult);
        }
        return "";
    }

    public String visitPredicate(Predicate predicate) {
        if (predicate instanceof Predicates.BinaryComparison) {
            Predicates.BinaryComparison expr = (Predicates.BinaryComparison)predicate;
            return this.visitBinaryComparator(expr.getLeft(), expr.getOperator(), expr.getRight());
        }
        return "";
    }

    public String alwaysTrue() {
        return "";
    }

    public String alwaysFalse() {
        return "";
    }

    public String visitLiteral(Literal literalExpr) {
        if (literalExpr.getDataType() instanceof Types.StringType) {
            return this.quoteStringLiteral((String)literalExpr.getValue());
        }
        if (literalExpr.getDataType() instanceof Types.IntType || literalExpr.getDataType() instanceof Types.LongType || literalExpr.getDataType() instanceof Types.DateType) {
            return literalExpr.getValue().toString();
        }
        return "";
    }

    public String visitNameReference(NameReference attribute) {
        return attribute.getName();
    }

    public String visitBoundReference(BoundReference boundReference) {
        throw new UnsupportedOperationException("BoundReference cannot be used to build filter string");
    }
}

