/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.deltastreamer.DeltaSync;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;

public class HoodieDeltaStreamerWrapper
extends HoodieDeltaStreamer {
    public HoodieDeltaStreamerWrapper(HoodieDeltaStreamer.Config cfg, JavaSparkContext jssc) throws Exception {
        super(cfg, jssc);
    }

    public JavaRDD<WriteStatus> upsert(WriteOperationType operation) throws Exception {
        this.cfg.operation = operation;
        return (JavaRDD)((HoodieDeltaStreamer.DeltaSyncService)this.deltaSyncService.get()).getDeltaSync().syncOnce().getRight();
    }

    public JavaRDD<WriteStatus> insert() throws Exception {
        return this.upsert(WriteOperationType.INSERT);
    }

    public JavaRDD<WriteStatus> bulkInsert() throws Exception {
        return this.upsert(WriteOperationType.BULK_INSERT);
    }

    public JavaRDD<WriteStatus> insertOverwrite() throws Exception {
        return this.upsert(WriteOperationType.INSERT_OVERWRITE);
    }

    public JavaRDD<WriteStatus> insertOverwriteTable() throws Exception {
        return this.upsert(WriteOperationType.INSERT_OVERWRITE_TABLE);
    }

    public void scheduleCompact() throws Exception {
        this.upsert(WriteOperationType.UPSERT);
    }

    public JavaRDD<WriteStatus> compact() throws Exception {
        return this.upsert(WriteOperationType.UPSERT);
    }

    public Pair<SchemaProvider, Pair<String, JavaRDD<HoodieRecord>>> fetchSource() throws Exception {
        DeltaSync service = ((HoodieDeltaStreamer.DeltaSyncService)this.deltaSyncService.get()).getDeltaSync();
        service.refreshTimeline();
        return service.readFromSource(service.getCommitTimelineOpt());
    }
}

