/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.converter;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.integ.testsuite.converter.Converter;
import org.apache.hudi.integ.testsuite.generator.LazyRecordGeneratorIterator;
import org.apache.hudi.integ.testsuite.generator.UpdateGeneratorIterator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;

public class UpdateConverter
implements Converter<GenericRecord, GenericRecord> {
    private final String schemaStr;
    private final List<String> partitionPathFields;
    private final List<String> recordKeyFields;
    private final int minPayloadSize;

    public UpdateConverter(String schemaStr, int minPayloadSize, List<String> partitionPathFields, List<String> recordKeyFields) {
        this.schemaStr = schemaStr;
        this.partitionPathFields = partitionPathFields;
        this.recordKeyFields = recordKeyFields;
        this.minPayloadSize = minPayloadSize;
    }

    @Override
    public JavaRDD<GenericRecord> convert(JavaRDD<GenericRecord> inputRDD) {
        return inputRDD.mapPartitions((FlatMapFunction & Serializable)recordItr -> new LazyRecordGeneratorIterator(new UpdateGeneratorIterator((Iterator<GenericRecord>)recordItr, this.schemaStr, this.partitionPathFields, this.recordKeyFields, this.minPayloadSize)));
    }
}

