/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.writer.DeltaWriteStats;
import org.apache.spark.api.java.JavaRDD;

public class CompactNode
extends DagNode<JavaRDD<WriteStatus>> {
    public CompactNode(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext executionContext, int curItrCount) throws Exception {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(executionContext.getHoodieTestSuiteWriter().getConfiguration()).setBasePath(executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath).build();
        Option lastInstant = metaClient.getActiveTimeline().getWriteTimeline().filterPendingCompactionTimeline().lastInstant();
        if (lastInstant.isPresent()) {
            log.info("Compacting instant {}", lastInstant.get());
            this.result = executionContext.getHoodieTestSuiteWriter().compact((Option<String>)Option.of((Object)((HoodieInstant)lastInstant.get()).getTimestamp()));
            executionContext.getHoodieTestSuiteWriter().commitCompaction((JavaRDD<WriteStatus>)((JavaRDD)this.result), (JavaRDD<DeltaWriteStats>)executionContext.getJsc().emptyRDD(), (Option<String>)Option.of((Object)((HoodieInstant)lastInstant.get()).getTimestamp()));
        }
    }
}

