/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.BaseValidateDatasetNode;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDatasetNode
extends BaseValidateDatasetNode {
    private static Logger log = LoggerFactory.getLogger(ValidateDatasetNode.class);

    public ValidateDatasetNode(DeltaConfig.Config config) {
        super(config);
    }

    @Override
    public Logger getLogger() {
        return log;
    }

    @Override
    public Dataset<Row> getDatasetToValidate(SparkSession session, ExecutionContext context, StructType inputSchema) {
        String hudiPath = context.getHoodieTestSuiteWriter().getCfg().targetBasePath + "/*/*/*";
        log.info("Validate data in target hudi path " + hudiPath);
        Dataset hudiDf = session.read().format("hudi").load(hudiPath);
        return hudiDf.drop("_hoodie_commit_time").drop("_hoodie_commit_seqno").drop("_hoodie_record_key").drop("_hoodie_partition_path").drop("_hoodie_file_name");
    }
}

