/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes.spark.sql;

import java.io.Serializable;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.BaseValidateDatasetNode;
import org.apache.hudi.integ.testsuite.utils.SparkSqlUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d4Aa\u0002\u0005\u00017!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003:\u0001\u0011\u0005!\bC\u0004?\u0001\t\u0007I\u0011A \t\r\u0019\u0003\u0001\u0015!\u0003A\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015I\u0005\u0001\"\u0011K\u0005m\u0019\u0006/\u0019:l'Fdg+\u00197jI\u0006$X\rR1uCN,GOT8eK*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"A\u0003o_\u0012,7O\u0003\u0002\u0010!\u0005\u0019A-Y4\u000b\u0005E\u0011\u0012!\u0003;fgR\u001cX/\u001b;f\u0015\t\u0019B#A\u0003j]R,wM\u0003\u0002\u0016-\u0005!\u0001.\u001e3j\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;yi\u0011\u0001D\u0005\u0003?1\u0011qCQ1tKZ\u000bG.\u001b3bi\u0016$\u0015\r^1tKRtu\u000eZ3\u0002\u001b\u0011\fwMT8eK\u000e{gNZ5h!\t\u0011cG\u0004\u0002$g9\u0011A%\r\b\u0003KAr!AJ\u0018\u000f\u0005\u001drcB\u0001\u0015.\u001d\tIC&D\u0001+\u0015\tY#$\u0001\u0004=e>|GOP\u0005\u00023%\u0011q\u0003G\u0005\u0003+YI!a\u0005\u000b\n\u0005E\u0011\u0012B\u0001\u001a\u0011\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011A'N\u0001\f\t\u0016dG/Y\"p]\u001aLwM\u0003\u00023!%\u0011q\u0007\u000f\u0002\u0007\u0007>tg-[4\u000b\u0005Q*\u0014A\u0002\u001fj]&$h\b\u0006\u0002<{A\u0011A\bA\u0007\u0002\u0011!)\u0001E\u0001a\u0001C\u0005\u0019AjT$\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\r\u0002\u000bMdg\r\u000e6\n\u0005\u0015\u0013%A\u0002'pO\u001e,'/\u0001\u0003M\u001f\u001e\u0003\u0013!C4fi2{wmZ3s)\u0005\u0001\u0015\u0001F4fi\u0012\u000bG/Y:fiR{g+\u00197jI\u0006$X\r\u0006\u0003L)f{\u0006c\u0001'P#6\tQJ\u0003\u0002\n\u001d*\u00111BF\u0005\u0003!6\u0013q\u0001R1uCN,G\u000f\u0005\u0002M%&\u00111+\u0014\u0002\u0004%><\b\"B+\u0007\u0001\u00041\u0016aB:fgNLwN\u001c\t\u0003\u0019^K!\u0001W'\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bi3\u0001\u0019A.\u0002\u000f\r|g\u000e^3yiB\u0011A,X\u0007\u0002\u001d%\u0011aL\u0004\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQ\u0001\u0019\u0004A\u0002\u0005\f1\"\u001b8qkR\u001c6\r[3nCB\u0011!-Z\u0007\u0002G*\u0011A-T\u0001\u0006if\u0004Xm]\u0005\u0003M\u000e\u0014!b\u0015;sk\u000e$H+\u001f9f\u0001")
public class SparkSqlValidateDatasetNode
extends BaseValidateDatasetNode {
    private final Logger LOG = LoggerFactory.getLogger(SparkSqlValidateDatasetNode.class);

    public Logger LOG() {
        return this.LOG;
    }

    @Override
    public Logger getLogger() {
        return this.LOG();
    }

    @Override
    public Dataset<Row> getDatasetToValidate(SparkSession session, ExecutionContext context, StructType inputSchema) {
        String tableName = context.getWriterContext().getCfg().targetTableName;
        this.LOG().info(new StringBuilder(23).append("Validate data in table ").append(tableName).toString());
        String[] sortedInputFieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSchema.fieldNames())).sorted((Ordering)Ordering.String$.MODULE$);
        StructType tableSchema = session.table(tableName).schema();
        String[] sortedTableFieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fieldNames())).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SparkSqlValidateDatasetNode.$anonfun$getDatasetToValidate$1(field))))).sorted((Ordering)Ordering.String$.MODULE$);
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedInputFieldNames)).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sortedTableFieldNames))) {
            this.LOG().error("Input schema: ");
            inputSchema.printTreeString();
            this.LOG().error("Table schema: ");
            tableSchema.printTreeString();
            throw new AssertionError((Object)"Data set validation failed.  The schema does not match.");
        }
        return session.sql(SparkSqlUtils$.MODULE$.constructSelectQuery(inputSchema, tableName));
    }

    public static final /* synthetic */ boolean $anonfun$getDatasetToValidate$1(String field) {
        return !HoodieRecord.HOODIE_META_COLUMNS.contains(field);
    }

    public SparkSqlValidateDatasetNode(DeltaConfig.Config dagNodeConfig) {
        super(dagNodeConfig);
        this.config = dagNodeConfig;
    }
}

