/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.generator;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.Schema;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.integ.testsuite.generator.GenericRecordFullPayloadGenerator;

public class GenericRecordFullPayloadSizeEstimator
implements Serializable {
    private final transient Schema baseSchema;
    private final transient AtomicInteger counter = new AtomicInteger(0);

    public GenericRecordFullPayloadSizeEstimator(Schema schema) {
        this.baseSchema = schema;
    }

    public Pair<Integer, Integer> typeEstimateAndNumComplexFields() {
        int size = this.estimate(this.baseSchema);
        return Pair.of((Object)size, (Object)this.counter.get());
    }

    protected int estimate(Schema schema) {
        long size = 0L;
        for (Schema.Field f : schema.getFields()) {
            size += this.typeEstimate(f.schema());
        }
        return (int)size;
    }

    private long typeEstimate(Schema schema) {
        Schema localSchema = schema;
        if (this.isOption(schema)) {
            localSchema = this.getNonNull(schema);
        }
        switch (localSchema.getType()) {
            case BOOLEAN: {
                return 1L;
            }
            case DOUBLE: {
                return 8L;
            }
            case FLOAT: {
                return 4L;
            }
            case INT: {
                return 4L;
            }
            case LONG: {
                return 8L;
            }
            case STRING: {
                return UUID.randomUUID().toString().length();
            }
            case ENUM: {
                return 1L;
            }
            case RECORD: {
                return this.estimate(localSchema);
            }
            case ARRAY: {
                if (GenericRecordFullPayloadGenerator.isPrimitive(localSchema.getElementType())) {
                    this.counter.addAndGet(1);
                }
                Schema elementSchema = localSchema.getElementType();
                return this.typeEstimate(elementSchema);
            }
            case MAP: {
                if (GenericRecordFullPayloadGenerator.isPrimitive(localSchema.getValueType())) {
                    this.counter.addAndGet(1);
                }
                Schema valueSchema = localSchema.getValueType();
                return (long)UUID.randomUUID().toString().length() + this.typeEstimate(valueSchema);
            }
            case BYTES: {
                return UUID.randomUUID().toString().length();
            }
            case FIXED: {
                return localSchema.getFixedSize();
            }
        }
        throw new IllegalArgumentException("Cannot handle type: " + localSchema.getType());
    }

    protected boolean isOption(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType().equals((Object)Schema.Type.NULL) || ((Schema)schema.getTypes().get(1)).getType().equals((Object)Schema.Type.NULL));
    }

    protected Schema getNonNull(Schema schema) {
        List types = schema.getTypes();
        return ((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) ? (Schema)types.get(1) : (Schema)types.get(0);
    }
}

