/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.integ.testsuite.reader.DeltaInputReader;

public abstract class DFSDeltaInputReader
implements DeltaInputReader<GenericRecord> {
    protected List<String> getFilePathsToRead(String basePath, PathFilter filter, long totalRecordsToRead) throws IOException {
        FileSystem fs = FSUtils.getFs((String)basePath, (Configuration)new Configuration());
        List<FileStatus> fileStatuses = Arrays.asList(fs.globStatus(new Path(basePath, "*/*"), filter));
        if (fileStatuses.size() > 0) {
            FileStatus status = fileStatuses.get(0);
            long avgNumRecordsPerFile = this.analyzeSingleFile(status.getPath().toString());
            long numFilesToMatchExpectedRecords = (long)Math.ceil((double)totalRecordsToRead / (double)avgNumRecordsPerFile);
            long avgSizeOfEachFile = status.getLen();
            long totalSizeToRead = avgSizeOfEachFile * numFilesToMatchExpectedRecords;
            Pair<Integer, Integer> fileStatusIndexRange = this.getFileStatusIndexRange(fileStatuses, avgSizeOfEachFile, totalSizeToRead);
            ArrayList<String> filePaths = new ArrayList<String>();
            for (int startIndex = ((Integer)fileStatusIndexRange.getLeft()).intValue(); startIndex == 0 || startIndex < (Integer)fileStatusIndexRange.getRight(); ++startIndex) {
                filePaths.add(fileStatuses.get(startIndex).getPath().toString());
            }
            return filePaths;
        }
        return Collections.emptyList();
    }

    protected Pair<Integer, Integer> getFileStatusIndexRange(List<FileStatus> fileStatuses, long averageFileSize, long totalSizeToRead) {
        long totalSizeOfFilesPresent = 0L;
        int startOffset = 0;
        int endOffset = 0;
        for (FileStatus fileStatus : fileStatuses) {
            totalSizeOfFilesPresent = fileStatus.getLen() > averageFileSize ? (totalSizeOfFilesPresent += averageFileSize) : (totalSizeOfFilesPresent += fileStatus.getLen());
            if (totalSizeOfFilesPresent <= totalSizeToRead) {
                ++endOffset;
                continue;
            }
            return Pair.of((Object)startOffset, (Object)endOffset);
        }
        return Pair.of((Object)startOffset, (Object)endOffset);
    }

    protected long analyzeSingleFile(String filePath) {
        throw new UnsupportedOperationException("No implementation found");
    }
}

