/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.reader;

import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.common.util.Option;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import scala.collection.Iterator;
import scala.collection.JavaConverters;

public class SparkBasedReader {
    public static final String SPARK_AVRO_FORMAT = "avro";
    public static final String SPARK_PARQUET_FORMAT = "com.databricks.spark.parquet";
    private static final String AVRO_SCHEMA_OPTION_KEY = "avroSchema";

    public static JavaRDD<GenericRecord> readAvro(SparkSession sparkSession, String schemaStr, List<String> listOfPaths, Option<String> structName, Option<String> nameSpace) {
        Dataset dataSet = sparkSession.read().format(SPARK_AVRO_FORMAT).option(AVRO_SCHEMA_OPTION_KEY, schemaStr).load(((Iterator)JavaConverters.asScalaIteratorConverter(listOfPaths.iterator()).asScala()).toSeq());
        return HoodieSparkUtils.createRdd((Dataset)dataSet.toDF(), (String)((String)structName.orElse((Object)"hoodie_source")), (String)((String)nameSpace.orElse((Object)"hoodie.source")), (boolean)false, (Option)Option.empty()).toJavaRDD();
    }

    public static JavaRDD<GenericRecord> readParquet(SparkSession sparkSession, List<String> listOfPaths, Option<String> structName, Option<String> nameSpace) {
        Dataset dataSet = sparkSession.read().parquet(((Iterator)JavaConverters.asScalaIteratorConverter(listOfPaths.iterator()).asScala()).toSeq());
        return HoodieSparkUtils.createRdd((Dataset)dataSet.toDF(), (String)((String)structName.orElse((Object)"hoodie_source")), (String)"hoodie.source", (boolean)false, (Option)Option.empty()).toJavaRDD();
    }

    public static JavaRDD<GenericRecord> readOrc(SparkSession sparkSession, List<String> listOfPaths, Option<String> structName, Option<String> nameSpace) {
        Dataset dataSet = sparkSession.read().orc(((Iterator)JavaConverters.asScalaIteratorConverter(listOfPaths.iterator()).asScala()).toSeq());
        return HoodieSparkUtils.createRdd((Dataset)dataSet.toDF(), (String)((String)structName.orElse((Object)"hoodie_source")), (String)"hoodie.source", (boolean)false, (Option)Option.empty()).toJavaRDD();
    }
}

