/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.integ.testsuite.writer.DeltaInputWriter;
import org.apache.hudi.integ.testsuite.writer.DeltaWriteStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroFileDeltaInputWriter
implements DeltaInputWriter<GenericRecord> {
    public static final String AVRO_EXTENSION = ".avro";
    private static Logger log = LoggerFactory.getLogger(AvroFileDeltaInputWriter.class);
    private final Long maxFileSize;
    private final Configuration configuration;
    private HoodieWrapperFileSystem fs;
    private Path file;
    private String basePath;
    private DatumWriter<IndexedRecord> writer;
    private DataFileWriter<IndexedRecord> dataFileWriter;
    private OutputStream output;
    private Schema schema;
    private DeltaWriteStats deltaWriteStats;
    private long recordsWritten = 0L;

    public AvroFileDeltaInputWriter(Configuration configuration, String basePath, String schemaStr, Long maxFileSize) throws IOException {
        this.schema = Schema.parse((String)schemaStr);
        this.maxFileSize = maxFileSize;
        this.configuration = configuration;
        this.basePath = basePath;
        Path path = new Path(basePath, new Path(UUID.randomUUID().toString() + AVRO_EXTENSION));
        this.file = HoodieWrapperFileSystem.convertToHoodiePath((Path)path, (Configuration)configuration);
        this.fs = (HoodieWrapperFileSystem)this.file.getFileSystem(FSUtils.registerFileSystem((Path)path, (Configuration)configuration));
        this.output = this.fs.create(this.file);
        this.writer = new GenericDatumWriter(this.schema);
        this.dataFileWriter = new DataFileWriter(this.writer).create(this.schema, this.output);
        this.deltaWriteStats = new DeltaWriteStats();
    }

    @Override
    public void writeData(GenericRecord iData) throws IOException {
        this.dataFileWriter.append((Object)iData);
        ++this.recordsWritten;
    }

    @Override
    public boolean canWrite() {
        return this.fs.getBytesWritten(this.file) < this.maxFileSize;
    }

    @Override
    public void close() throws IOException {
        this.deltaWriteStats.setBytesWritten(this.fs.getBytesWritten(this.file));
        this.deltaWriteStats.setRecordsWritten(this.recordsWritten);
        this.deltaWriteStats.setFilePath(this.file.toUri().getPath());
        this.dataFileWriter.close();
        log.info("New Avro File : {}", (Object)this.getPath());
    }

    @Override
    public DeltaInputWriter getNewWriter() throws IOException {
        AvroFileDeltaInputWriter avroFileDeltaInputWriter = new AvroFileDeltaInputWriter(this.configuration, this.basePath, this.schema.toString(), this.maxFileSize);
        return avroFileDeltaInputWriter;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public Path getPath() {
        return this.file;
    }

    @Override
    public DeltaWriteStats getDeltaWriteStats() {
        return this.deltaWriteStats;
    }
}

