/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.writer;

import java.io.IOException;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.integ.testsuite.writer.DeltaInputWriter;
import org.apache.hudi.integ.testsuite.writer.DeltaWriteStats;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;

public class SparkAvroDeltaInputWriter
implements DeltaInputWriter<JavaRDD<GenericRecord>> {
    private static final String AVRO_FORMAT_PACKAGE = "avro";
    public SparkSession sparkSession;
    private String schemaStr;
    private String basePath;

    public SparkAvroDeltaInputWriter(SparkSession sparkSession, String schemaStr, String basePath) {
        this.sparkSession = sparkSession;
        this.schemaStr = schemaStr;
        this.basePath = basePath;
    }

    @Override
    public void writeData(JavaRDD<GenericRecord> iData) throws IOException {
        AvroConversionUtils.createDataFrame((RDD)iData.rdd(), (String)this.schemaStr, (SparkSession)this.sparkSession).write().format(AVRO_FORMAT_PACKAGE).save(this.basePath);
    }

    @Override
    public boolean canWrite() {
        throw new UnsupportedOperationException("not applicable for spark based writer");
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public DeltaWriteStats getDeltaWriteStats() {
        throw new UnsupportedOperationException("not applicable for spark based writer");
    }

    @Override
    public DeltaInputWriter getNewWriter() throws IOException {
        throw new UnsupportedOperationException("not applicable for spark based writer");
    }
}

