/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.execution.bulkinsert.JavaCustomColumnsSortPartitioner;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.testutils.HoodieJavaClientTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestJavaBulkInsertInternalPartitioner
extends HoodieJavaClientTestBase {
    private static final Comparator<HoodieRecord> KEY_COMPARATOR = Comparator.comparing(o -> o.getPartitionPath() + "+" + o.getRecordKey());

    public static List<HoodieRecord> generateTestRecordsForBulkInsert(int numRecords) {
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        List records = dataGenerator.generateInserts("0", Integer.valueOf(numRecords));
        return records;
    }

    public static Map<String, Long> generatePartitionNumRecords(List<HoodieRecord> records) {
        return records.stream().map(record -> record.getPartitionPath()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    @ParameterizedTest
    @ValueSource(strings={"rider", "rider,driver"})
    public void testCustomColumnSortPartitioner(String sortColumnString) throws Exception {
        String[] sortColumns = sortColumnString.split(",");
        Comparator<HoodieRecord> columnComparator = this.getCustomColumnComparator(HoodieTestDataGenerator.AVRO_SCHEMA, sortColumns);
        List<HoodieRecord> records = TestJavaBulkInsertInternalPartitioner.generateTestRecordsForBulkInsert(1000);
        this.testBulkInsertInternalPartitioner((BulkInsertPartitioner)new JavaCustomColumnsSortPartitioner(sortColumns, HoodieTestDataGenerator.AVRO_SCHEMA), records, true, TestJavaBulkInsertInternalPartitioner.generatePartitionNumRecords(records), (Option<Comparator<HoodieRecord>>)Option.of(columnComparator));
    }

    private Comparator<HoodieRecord> getCustomColumnComparator(Schema schema, String[] sortColumns) {
        return Comparator.comparing(record -> HoodieAvroUtils.getRecordColumnValues((HoodieRecord)record, (String[])sortColumns, (Schema)schema).toString());
    }

    private void verifyRecordAscendingOrder(List<HoodieRecord> records, Option<Comparator<HoodieRecord>> comparator) {
        ArrayList<HoodieRecord> expectedRecords = new ArrayList<HoodieRecord>(records);
        Collections.sort(expectedRecords, (Comparator)comparator.orElse(KEY_COMPARATOR));
        Assertions.assertEquals(expectedRecords, records);
    }

    private void testBulkInsertInternalPartitioner(BulkInsertPartitioner partitioner, List<HoodieRecord> records, boolean isSorted, Map<String, Long> expectedPartitionNumRecords, Option<Comparator<HoodieRecord>> comparator) {
        List actualRecords = (List)partitioner.repartitionRecords(records, 1);
        if (isSorted) {
            this.verifyRecordAscendingOrder(actualRecords, comparator);
        }
        Assertions.assertEquals(expectedPartitionNumRecords, TestJavaBulkInsertInternalPartitioner.generatePartitionNumRecords(actualRecords));
    }
}

