/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.client.HoodieJavaWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.Transformations;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.table.HoodieJavaCopyOnWriteTable;
import org.apache.hudi.table.HoodieJavaTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BaseJavaCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaBulkInsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaInsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaInsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaUpsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaUpsertPreppedCommitActionExecutor;
import org.apache.hudi.testutils.HoodieJavaClientTestBase;
import org.apache.hudi.testutils.MetadataMergeWriteStatus;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestJavaCopyOnWriteActionExecutor
extends HoodieJavaClientTestBase {
    private static final Logger LOG = LogManager.getLogger(TestJavaCopyOnWriteActionExecutor.class);
    private static final Schema SCHEMA = SchemaTestUtil.getSchemaFromResource(TestJavaCopyOnWriteActionExecutor.class, (String)"/exampleSchema.avsc");

    @Test
    public void testMakeNewPath() {
        String fileName = UUID.randomUUID().toString();
        String partitionPath = "2016/05/04";
        String instantTime = HoodieTestTable.makeNewCommitTime();
        HoodieWriteConfig config = this.makeHoodieClientConfig();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieJavaTable table = HoodieJavaTable.create((HoodieWriteConfig)config, (HoodieJavaEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        Pair newPathWithWriteToken = (Pair)Arrays.asList(1).stream().map(arg_0 -> this.lambda$testMakeNewPath$0(partitionPath, config, instantTime, (HoodieTable)table, fileName, arg_0)).collect(Collectors.toList()).get(0);
        Assertions.assertEquals((Object)((Path)newPathWithWriteToken.getKey()).toString(), (Object)Paths.get(this.basePath, partitionPath, FSUtils.makeDataFileName((String)instantTime, (String)((String)newPathWithWriteToken.getRight()), (String)fileName)).toString());
    }

    private HoodieWriteConfig makeHoodieClientConfig() {
        return this.makeHoodieClientConfigBuilder().build();
    }

    private HoodieWriteConfig.Builder makeHoodieClientConfigBuilder() {
        return HoodieWriteConfig.newBuilder().withEngineType(EngineType.JAVA).withPath(this.basePath).withSchema(SCHEMA.toString());
    }

    @Test
    public void testUpdateRecords() throws Exception {
        GenericRecord newRecord;
        HoodieWriteConfig config = this.makeHoodieClientConfig();
        String firstCommitTime = HoodieTestTable.makeNewCommitTime();
        HoodieJavaWriteClient writeClient = this.getHoodieWriteClient(config);
        writeClient.startCommitWithTime(firstCommitTime);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        BaseFileUtils fileUtils = BaseFileUtils.getInstance((HoodieTableMetaClient)this.metaClient);
        String partitionPath = "2016/01/31";
        HoodieJavaCopyOnWriteTable table = (HoodieJavaCopyOnWriteTable)HoodieJavaTable.create((HoodieWriteConfig)config, (HoodieJavaEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        String recordStr1 = "{\"_row_key\":\"8eb5b87a-1feh-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"8eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"8eb5b87c-1fej-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"8eb5b87d-1fej-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":51}";
        ArrayList<HoodieRecord> records = new ArrayList<HoodieRecord>();
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        records.add(new HoodieRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1));
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        records.add(new HoodieRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2));
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        records.add(new HoodieRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3));
        HoodieJavaCopyOnWriteTable cowTable = table;
        writeClient.insert(records, firstCommitTime);
        FileStatus[] allFiles = this.getIncrementalFiles(partitionPath, "0", -1);
        Assertions.assertEquals((int)1, (int)allFiles.length);
        Path filePath = allFiles[0].getPath();
        BloomFilter filter = fileUtils.readBloomFilterFromMetadata(this.hadoopConf, filePath);
        for (HoodieRecord record : records) {
            Assertions.assertTrue((boolean)filter.mightContain(record.getRecordKey()));
        }
        List fileRecords = fileUtils.readAvroRecords(this.hadoopConf, filePath);
        int index = 0;
        for (GenericRecord record : fileRecords) {
            Assertions.assertEquals((Object)((HoodieRecord)records.get(index)).getRecordKey(), (Object)record.get("_row_key").toString());
            ++index;
        }
        String updateRecordStr1 = "{\"_row_key\":\"8eb5b87a-1feh-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        RawTripTestPayload updateRowChanges1 = new RawTripTestPayload(updateRecordStr1);
        HoodieRecord updatedRecord1 = new HoodieRecord(new HoodieKey(updateRowChanges1.getRowKey(), updateRowChanges1.getPartitionPath()), (HoodieRecordPayload)updateRowChanges1);
        RawTripTestPayload rowChange4 = new RawTripTestPayload(recordStr4);
        HoodieRecord insertedRecord1 = new HoodieRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        List<HoodieRecord> updatedRecords = Arrays.asList(updatedRecord1, insertedRecord1);
        Thread.sleep(1000L);
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        writeClient.startCommitWithTime(newCommitTime);
        List statuses = writeClient.upsert(updatedRecords, newCommitTime);
        allFiles = this.getIncrementalFiles(partitionPath, firstCommitTime, -1);
        Assertions.assertEquals((int)1, (int)allFiles.length);
        Assertions.assertEquals((Object)FSUtils.getFileId((String)filePath.getName()), (Object)FSUtils.getFileId((String)allFiles[0].getPath().getName()));
        Path updatedfilePath = allFiles[0].getPath();
        BloomFilter updatedFilter = fileUtils.readBloomFilterFromMetadata(this.hadoopConf, updatedfilePath);
        for (HoodieRecord record : records) {
            Assertions.assertTrue((boolean)updatedFilter.mightContain(record.getRecordKey()));
        }
        Assertions.assertTrue((boolean)updatedFilter.mightContain(insertedRecord1.getRecordKey()));
        records.add(insertedRecord1);
        ParquetReader updatedReader = ParquetReader.builder((ReadSupport)new AvroReadSupport(), (Path)updatedfilePath).build();
        index = 0;
        while ((newRecord = (GenericRecord)updatedReader.read()) != null) {
            Assertions.assertEquals((Object)newRecord.get("_row_key").toString(), (Object)((HoodieRecord)records.get(index)).getRecordKey());
            if (index == 0) {
                Assertions.assertEquals((Object)"15", (Object)newRecord.get("number").toString());
            }
            ++index;
        }
        updatedReader.close();
        WriteStatus writeStatus = (WriteStatus)statuses.get(0);
        Assertions.assertEquals((int)1, (int)statuses.size(), (String)"Should be only one file generated");
        Assertions.assertEquals((long)4L, (long)writeStatus.getStat().getNumWrites());
    }

    private FileStatus[] getIncrementalFiles(String partitionPath, String startCommitTime, int numCommitsToPull) throws Exception {
        HoodieParquetInputFormat hoodieInputFormat = new HoodieParquetInputFormat();
        JobConf jobConf = new JobConf(this.hadoopConf);
        hoodieInputFormat.setConf((Configuration)jobConf);
        HoodieTestUtils.init((Configuration)this.hadoopConf, (String)this.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE);
        this.setupIncremental(jobConf, startCommitTime, numCommitsToPull);
        FileInputFormat.setInputPaths((JobConf)jobConf, (String)Paths.get(this.basePath, partitionPath).toString());
        return hoodieInputFormat.listStatus(jobConf);
    }

    private void setupIncremental(JobConf jobConf, String startCommit, int numberOfCommitsToPull) {
        String modePropertyName = String.format("hoodie.%s.consume.mode", "raw_trips");
        jobConf.set(modePropertyName, "INCREMENTAL");
        String startCommitTimestampName = String.format("hoodie.%s.consume.start.timestamp", "raw_trips");
        jobConf.set(startCommitTimestampName, startCommit);
        String maxCommitPulls = String.format("hoodie.%s.consume.max.commits", "raw_trips");
        jobConf.setInt(maxCommitPulls, numberOfCommitsToPull);
    }

    private List<HoodieRecord> newHoodieRecords(int n, String time) throws Exception {
        ArrayList<HoodieRecord> records = new ArrayList<HoodieRecord>();
        for (int i = 0; i < n; ++i) {
            String recordStr = String.format("{\"_row_key\":\"%s\",\"time\":\"%s\",\"number\":%d}", UUID.randomUUID().toString(), time, i);
            RawTripTestPayload rowChange = new RawTripTestPayload(recordStr);
            records.add(new HoodieRecord(new HoodieKey(rowChange.getRowKey(), rowChange.getPartitionPath()), (HoodieRecordPayload)rowChange));
        }
        return records;
    }

    @Test
    public void testMetadataAggregateFromWriteStatus() throws Exception {
        HoodieWriteConfig config = this.makeHoodieClientConfigBuilder().withWriteStatusClass(MetadataMergeWriteStatus.class).build();
        String firstCommitTime = HoodieTestTable.makeNewCommitTime();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieJavaCopyOnWriteTable table = (HoodieJavaCopyOnWriteTable)HoodieJavaTable.create((HoodieWriteConfig)config, (HoodieJavaEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        String recordStr1 = "{\"_row_key\":\"8eb5b87a-1feh-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"8eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"8eb5b87c-1fej-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        ArrayList<HoodieRecord> records = new ArrayList<HoodieRecord>();
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        records.add(new HoodieRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1));
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        records.add(new HoodieRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2));
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        records.add(new HoodieRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3));
        JavaInsertCommitActionExecutor actionExecutor = new JavaInsertCommitActionExecutor((HoodieEngineContext)this.context, config, (HoodieTable)table, firstCommitTime, records);
        ArrayList writeStatuses = new ArrayList();
        actionExecutor.handleInsert(FSUtils.createNewFileIdPfx(), records.iterator()).forEachRemaining(x -> writeStatuses.addAll((List)x));
        Map allWriteStatusMergedMetadataMap = MetadataMergeWriteStatus.mergeMetadataForWriteStatuses(writeStatuses);
        Assertions.assertTrue((boolean)allWriteStatusMergedMetadataMap.containsKey("InputRecordCount_1506582000"));
        Assertions.assertEquals((Object)"6", allWriteStatusMergedMetadataMap.get("InputRecordCount_1506582000"));
    }

    private void verifyStatusResult(List<WriteStatus> statuses, Map<String, Long> expectedPartitionNumRecords) {
        HashMap<String, Long> actualPartitionNumRecords = new HashMap<String, Long>();
        for (int i = 0; i < statuses.size(); ++i) {
            WriteStatus writeStatus = statuses.get(i);
            String partitionPath = writeStatus.getPartitionPath();
            actualPartitionNumRecords.put(partitionPath, actualPartitionNumRecords.getOrDefault(partitionPath, 0L) + writeStatus.getTotalRecords());
            Assertions.assertEquals((int)0, (int)writeStatus.getFailedRecords().size());
        }
        Assertions.assertEquals(expectedPartitionNumRecords, actualPartitionNumRecords);
    }

    @Test
    public void testInsertRecords() throws Exception {
        HoodieWriteConfig config = this.makeHoodieClientConfig();
        String instantTime = HoodieTestTable.makeNewCommitTime();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieJavaCopyOnWriteTable table = (HoodieJavaCopyOnWriteTable)HoodieJavaTable.create((HoodieWriteConfig)config, (HoodieJavaEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        List<HoodieRecord> records = this.newHoodieRecords(10, "2016-01-31T03:16:41.415Z");
        records.addAll(this.newHoodieRecords(1, "2016-02-01T03:16:41.415Z"));
        List<HoodieRecord> recs2 = records;
        JavaInsertPreppedCommitActionExecutor actionExecutor = new JavaInsertPreppedCommitActionExecutor(this.context, config, (HoodieTable)table, instantTime, recs2);
        ArrayList<WriteStatus> returnedStatuses = new ArrayList<WriteStatus>();
        actionExecutor.handleInsert(FSUtils.createNewFileIdPfx(), recs2.iterator()).forEachRemaining(x -> returnedStatuses.addAll((List)x));
        Assertions.assertEquals((int)2, (int)returnedStatuses.size());
        HashMap<String, Long> expectedPartitionNumRecords = new HashMap<String, Long>();
        expectedPartitionNumRecords.put("2016/01/31", 10L);
        expectedPartitionNumRecords.put("2016/02/01", 1L);
        this.verifyStatusResult(returnedStatuses, expectedPartitionNumRecords);
        records = this.newHoodieRecords(1, "2016-01-31T03:16:41.415Z");
        records.addAll(this.newHoodieRecords(5, "2016-02-01T03:16:41.415Z"));
        records.addAll(this.newHoodieRecords(1, "2016-02-02T03:16:41.415Z"));
        List<HoodieRecord> recs3 = records;
        JavaUpsertPreppedCommitActionExecutor newActionExecutor = new JavaUpsertPreppedCommitActionExecutor(this.context, config, (HoodieTable)table, instantTime, recs3);
        ArrayList<WriteStatus> returnedStatuses1 = new ArrayList<WriteStatus>();
        newActionExecutor.handleInsert(FSUtils.createNewFileIdPfx(), recs3.iterator()).forEachRemaining(x -> returnedStatuses1.addAll((List)x));
        Assertions.assertEquals((int)3, (int)returnedStatuses1.size());
        expectedPartitionNumRecords.clear();
        expectedPartitionNumRecords.put("2016/01/31", 1L);
        expectedPartitionNumRecords.put("2016/02/01", 5L);
        expectedPartitionNumRecords.put("2016/02/02", 1L);
        this.verifyStatusResult(returnedStatuses1, expectedPartitionNumRecords);
    }

    @Test
    public void testFileSizeUpsertRecords() throws Exception {
        HoodieWriteConfig config = this.makeHoodieClientConfigBuilder().withStorageConfig(HoodieStorageConfig.newBuilder().parquetMaxFileSize(65536L).hfileMaxFileSize(65536L).parquetBlockSize(65536).parquetPageSize(65536).build()).build();
        String instantTime = HoodieTestTable.makeNewCommitTime();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieJavaCopyOnWriteTable table = (HoodieJavaCopyOnWriteTable)HoodieJavaTable.create((HoodieWriteConfig)config, (HoodieJavaEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        ArrayList<HoodieRecord> records = new ArrayList<HoodieRecord>();
        for (int i = 0; i < 2000; ++i) {
            String recordStr = "{\"_row_key\":\"" + UUID.randomUUID().toString() + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":" + i + "}";
            RawTripTestPayload rowChange = new RawTripTestPayload(recordStr);
            records.add(new HoodieRecord(new HoodieKey(rowChange.getRowKey(), rowChange.getPartitionPath()), (HoodieRecordPayload)rowChange));
        }
        JavaUpsertCommitActionExecutor actionExecutor = new JavaUpsertCommitActionExecutor((HoodieEngineContext)this.context, config, (HoodieTable)table, instantTime, records);
        Arrays.asList(1).stream().map(arg_0 -> TestJavaCopyOnWriteActionExecutor.lambda$testFileSizeUpsertRecords$4((BaseJavaCommitActionExecutor)actionExecutor, records, arg_0)).map(Transformations::flatten).collect(Collectors.toList());
        int counts = 0;
        for (File file : Paths.get(this.basePath, "2016/01/31").toFile().listFiles()) {
            if (!file.getName().endsWith(table.getBaseFileExtension()) || !FSUtils.getCommitTime((String)file.getName()).equals(instantTime)) continue;
            LOG.info((Object)(file.getName() + "-" + file.length()));
            ++counts;
        }
        Assertions.assertEquals((int)3, (int)counts, (String)"If the number of records are more than 1150, then there should be a new file");
    }

    @Test
    public void testInsertUpsertWithHoodieAvroPayload() throws Exception {
        Schema schema = SchemaTestUtil.getSchemaFromResource(TestJavaCopyOnWriteActionExecutor.class, (String)"/testDataGeneratorSchema.txt");
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withEngineType(EngineType.JAVA).withPath(this.basePath).withSchema(schema.toString()).withStorageConfig(HoodieStorageConfig.newBuilder().parquetMaxFileSize(1024000L).hfileMaxFileSize(1024000L).build()).build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieJavaCopyOnWriteTable table = (HoodieJavaCopyOnWriteTable)HoodieJavaTable.create((HoodieWriteConfig)config, (HoodieJavaEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        String instantTime = "000";
        List inserts = this.dataGen.generateInsertsWithHoodieAvroPayload(instantTime, 100);
        JavaInsertCommitActionExecutor actionExecutor = new JavaInsertCommitActionExecutor((HoodieEngineContext)this.context, config, (HoodieTable)table, instantTime, inserts);
        ArrayList ws = new ArrayList();
        actionExecutor.handleInsert(UUID.randomUUID().toString(), inserts.iterator()).forEachRemaining(x -> ws.add((List)x));
        WriteStatus writeStatus = (WriteStatus)((List)ws.get(0)).get(0);
        String fileId = writeStatus.getFileId();
        this.metaClient.getFs().create(new Path(Paths.get(this.basePath, ".hoodie", "000.commit").toString())).close();
        HoodieJavaCopyOnWriteTable reloadedTable = (HoodieJavaCopyOnWriteTable)HoodieJavaTable.create((HoodieWriteConfig)config, (HoodieJavaEngineContext)this.context, (HoodieTableMetaClient)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient));
        List updates = this.dataGen.generateUpdatesWithHoodieAvroPayload(instantTime, inserts);
        String partitionPath = writeStatus.getPartitionPath();
        long numRecordsInPartition = updates.stream().filter(u -> u.getPartitionPath().equals(partitionPath)).count();
        JavaUpsertCommitActionExecutor newActionExecutor = new JavaUpsertCommitActionExecutor((HoodieEngineContext)this.context, config, (HoodieTable)reloadedTable, instantTime, updates);
        this.taskContextSupplier.reset();
        ArrayList updateStatus = new ArrayList();
        newActionExecutor.handleUpdate(partitionPath, fileId, updates.iterator()).forEachRemaining(x -> updateStatus.add((List)x));
        Assertions.assertEquals((long)((long)updates.size() - numRecordsInPartition), (long)((WriteStatus)((List)updateStatus.get(0)).get(0)).getTotalErrorRecords());
    }

    public void testBulkInsertRecords(String bulkInsertMode) throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": \"string\"},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withBulkInsertParallelism(2).withBulkInsertSortMode(bulkInsertMode).build();
        String instantTime = HoodieTestTable.makeNewCommitTime();
        HoodieJavaWriteClient writeClient = this.getHoodieWriteClient(config);
        writeClient.startCommitWithTime(instantTime);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieJavaCopyOnWriteTable table = (HoodieJavaCopyOnWriteTable)HoodieJavaTable.create((HoodieWriteConfig)config, (HoodieJavaEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        List<HoodieRecord> inputRecords = TestJavaCopyOnWriteActionExecutor.generateTestRecordsForBulkInsert();
        JavaBulkInsertCommitActionExecutor bulkInsertExecutor = new JavaBulkInsertCommitActionExecutor(this.context, config, (HoodieTable)table, instantTime, inputRecords, Option.empty());
        List returnedStatuses = (List)bulkInsertExecutor.execute().getWriteStatuses();
        this.verifyStatusResult(returnedStatuses, TestJavaCopyOnWriteActionExecutor.generateExpectedPartitionNumRecords(inputRecords));
    }

    public static Map<String, Long> generateExpectedPartitionNumRecords(List<HoodieRecord> records) {
        return records.stream().map(record -> Pair.of((Object)record.getPartitionPath(), (Object)1)).collect(Collectors.groupingBy(Pair::getLeft, Collectors.counting()));
    }

    public static List<HoodieRecord> generateTestRecordsForBulkInsert() {
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        List records1 = dataGenerator.generateInserts("0", Integer.valueOf(100));
        List records2 = dataGenerator.generateInserts("0", Integer.valueOf(150));
        records1.addAll(records2);
        return records1;
    }

    private static /* synthetic */ Iterator lambda$testFileSizeUpsertRecords$4(BaseJavaCommitActionExecutor actionExecutor, List records, Integer i) {
        return actionExecutor.handleInsert(FSUtils.createNewFileIdPfx(), records.iterator());
    }

    private /* synthetic */ Pair lambda$testMakeNewPath$0(String partitionPath, HoodieWriteConfig config, String instantTime, HoodieTable table, String fileName, Integer x) {
        HoodieRecord record = (HoodieRecord)Mockito.mock(HoodieRecord.class);
        Mockito.when((Object)record.getPartitionPath()).thenReturn((Object)partitionPath);
        String writeToken = FSUtils.makeWriteToken((int)((Integer)this.context.getTaskContextSupplier().getPartitionIdSupplier().get()), (int)((Integer)this.context.getTaskContextSupplier().getStageIdSupplier().get()), (long)((Long)this.context.getTaskContextSupplier().getAttemptIdSupplier().get()));
        HoodieCreateHandle io = new HoodieCreateHandle(config, instantTime, table, partitionPath, fileName, this.context.getTaskContextSupplier());
        return Pair.of((Object)io.makeNewPath(record.getPartitionPath()), (Object)writeToken);
    }
}

