/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hudi.client.HoodieJavaWriteClient;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.minicluster.HdfsTestService;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class HoodieJavaClientTestHarness
extends HoodieCommonTestHarness
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(HoodieJavaClientTestHarness.class);
    private String testMethodName;
    protected transient Configuration hadoopConf = null;
    protected transient HoodieJavaEngineContext context = null;
    protected transient TestJavaTaskContextSupplier taskContextSupplier = null;
    protected transient FileSystem fs;
    protected transient ExecutorService executorService;
    protected transient HoodieTableFileSystemView tableView;
    protected transient HoodieJavaWriteClient writeClient;
    protected String dfsBasePath;
    protected transient HdfsTestService hdfsTestService;
    protected transient MiniDFSCluster dfsCluster;
    protected transient DistributedFileSystem dfs;

    @BeforeEach
    public void setTestMethodName(TestInfo testInfo) {
        this.testMethodName = testInfo.getTestMethod().isPresent() ? ((Method)testInfo.getTestMethod().get()).getName() : "Unknown";
    }

    public void initResources() throws IOException {
        this.initPath();
        this.hadoopConf = new Configuration();
        this.taskContextSupplier = new TestJavaTaskContextSupplier();
        this.context = new HoodieJavaEngineContext(this.hadoopConf, (TaskContextSupplier)this.taskContextSupplier);
        this.initTestDataGenerator();
        this.initFileSystem();
        this.initMetaClient();
    }

    public void cleanupResources() throws IOException {
        this.cleanupClients();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
        this.cleanupDFS();
        this.cleanupExecutorService();
        System.gc();
    }

    protected void initFileSystem() {
        this.initFileSystemWithConfiguration(this.hadoopConf);
    }

    protected void cleanupFileSystem() throws IOException {
        if (this.fs != null) {
            LOG.warn((Object)"Closing file-system instance used in previous test-run");
            this.fs.close();
            this.fs = null;
        }
    }

    protected void initMetaClient() throws IOException {
        this.initMetaClient(this.getTableType());
    }

    protected void initMetaClient(HoodieTableType tableType) throws IOException {
        if (this.basePath == null) {
            throw new IllegalStateException("The base path has not been initialized.");
        }
        this.metaClient = HoodieTestUtils.init((Configuration)this.hadoopConf, (String)this.basePath, (HoodieTableType)tableType);
    }

    protected void cleanupClients() {
        if (this.metaClient != null) {
            this.metaClient = null;
        }
        if (this.writeClient != null) {
            this.writeClient.close();
            this.writeClient = null;
        }
        if (this.tableView != null) {
            this.tableView.close();
            this.tableView = null;
        }
    }

    protected void cleanupDFS() throws IOException {
        if (this.hdfsTestService != null) {
            this.hdfsTestService.stop();
            this.dfsCluster.shutdown();
            this.hdfsTestService = null;
            this.dfsCluster = null;
            this.dfs = null;
        }
        FileSystem.closeAll();
    }

    protected void cleanupExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void initFileSystemWithConfiguration(Configuration configuration) {
        if (this.basePath == null) {
            throw new IllegalStateException("The base path has not been initialized.");
        }
        this.fs = FSUtils.getFs((String)this.basePath, (Configuration)configuration);
        if (this.fs instanceof LocalFileSystem) {
            LocalFileSystem lfs = (LocalFileSystem)this.fs;
            lfs.setVerifyChecksum(true);
        }
    }

    public HoodieJavaWriteClient getHoodieWriteClient(HoodieWriteConfig cfg) {
        if (null != this.writeClient) {
            this.writeClient.close();
            this.writeClient = null;
        }
        this.writeClient = new HoodieJavaWriteClient((HoodieEngineContext)this.context, cfg);
        return this.writeClient;
    }

    public class TestJavaTaskContextSupplier
    extends TaskContextSupplier {
        int partitionId = 0;
        int stageId = 0;
        long attemptId = 0L;

        public void reset() {
            ++this.stageId;
        }

        public Supplier<Integer> getPartitionIdSupplier() {
            return () -> this.partitionId;
        }

        public Supplier<Integer> getStageIdSupplier() {
            return () -> this.stageId;
        }

        public Supplier<Long> getAttemptIdSupplier() {
            return () -> this.attemptId;
        }

        public Option<String> getProperty(EngineProperty prop) {
            return Option.empty();
        }
    }
}

