/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.AbstractHoodieWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieList;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.JavaHoodieIndexFactory;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieJavaTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;

public class HoodieJavaWriteClient<T extends HoodieRecordPayload>
extends AbstractHoodieWriteClient<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    public HoodieJavaWriteClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        super(context, clientConfig);
    }

    public HoodieJavaWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, timelineService);
    }

    public List<HoodieRecord<T>> filterExists(List<HoodieRecord<T>> hoodieRecords) {
        HoodieJavaTable table = HoodieJavaTable.create(this.config, (HoodieJavaEngineContext)this.context);
        Timer.Context indexTimer = this.metrics.getIndexCtx();
        List recordsWithLocation = HoodieList.getList((HoodieData)this.getIndex().tagLocation((HoodieData)HoodieList.of(hoodieRecords), this.context, table));
        this.metrics.updateIndexMetrics("lookup", this.metrics.getDurationInMs(indexTimer == null ? 0L : indexTimer.stop()));
        return recordsWithLocation.stream().filter(v1 -> !v1.isCurrentLocationKnown()).collect(Collectors.toList());
    }

    protected HoodieIndex createIndex(HoodieWriteConfig writeConfig) {
        return JavaHoodieIndexFactory.createIndex(this.config);
    }

    public boolean commit(String instantTime, List<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds) {
        List writeStats = writeStatuses.stream().map(WriteStatus::getStat).collect(Collectors.toList());
        return this.commitStats(instantTime, writeStats, extraMetadata, commitActionType, partitionToReplacedFileIds);
    }

    protected HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> createTable(HoodieWriteConfig config, Configuration hadoopConf, boolean refreshTimeline) {
        return HoodieJavaTable.create(config, this.context);
    }

    public List<WriteStatus> upsert(List<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.UPSERT, instantTime);
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.upsert(this.context, instantTime, records);
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", ((Duration)result.getIndexLookupDuration().get()).toMillis());
        }
        return this.postWrite(result, instantTime, (HoodieTable)table);
    }

    public List<WriteStatus> upsertPreppedRecords(List<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.UPSERT_PREPPED, instantTime);
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.upsertPrepped(this.context, instantTime, preppedRecords);
        return this.postWrite(result, instantTime, (HoodieTable)table);
    }

    public List<WriteStatus> insert(List<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT, instantTime);
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.insert(this.context, instantTime, records);
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", ((Duration)result.getIndexLookupDuration().get()).toMillis());
        }
        return this.postWrite(result, instantTime, (HoodieTable)table);
    }

    public List<WriteStatus> insertPreppedRecords(List<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT_PREPPED, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.insertPrepped(this.context, instantTime, preppedRecords);
        return this.postWrite(result, instantTime, (HoodieTable)table);
    }

    public List<WriteStatus> bulkInsert(List<HoodieRecord<T>> records, String instantTime) {
        throw new HoodieNotSupportedException("BulkInsert is not supported in HoodieJavaClient");
    }

    public List<WriteStatus> bulkInsert(List<HoodieRecord<T>> records, String instantTime, Option<BulkInsertPartitioner<List<HoodieRecord<T>>>> userDefinedBulkInsertPartitioner) {
        throw new HoodieNotSupportedException("BulkInsert is not supported in HoodieJavaClient");
    }

    public void transitionInflight(String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        metaClient.getActiveTimeline().transitionRequestedToInflight(new HoodieInstant(HoodieInstant.State.REQUESTED, metaClient.getCommitActionType(), instantTime), Option.empty(), this.config.shouldAllowMultiWriteOnSameInstant());
    }

    public List<WriteStatus> bulkInsertPreppedRecords(List<HoodieRecord<T>> preppedRecords, String instantTime, Option<BulkInsertPartitioner<List<HoodieRecord<T>>>> bulkInsertPartitioner) {
        HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.BULK_INSERT_PREPPED, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsertPrepped(this.context, instantTime, preppedRecords, bulkInsertPartitioner);
        return this.postWrite(result, instantTime, (HoodieTable)table);
    }

    public List<WriteStatus> delete(List<HoodieKey> keys, String instantTime) {
        HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.DELETE, instantTime);
        this.preWrite(instantTime, WriteOperationType.DELETE, table.getMetaClient());
        HoodieWriteMetadata result = table.delete(this.context, instantTime, keys);
        return this.postWrite(result, instantTime, (HoodieTable)table);
    }

    protected List<WriteStatus> postWrite(HoodieWriteMetadata<List<WriteStatus>> result, String instantTime, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> hoodieTable) {
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics(this.getOperationType().name(), ((Duration)result.getIndexUpdateDuration().get()).toMillis());
        }
        if (result.isCommitted()) {
            if (result.getFinalizeDuration().isPresent()) {
                this.metrics.updateFinalizeWriteMetrics(((Duration)result.getFinalizeDuration().get()).toMillis(), (long)((List)result.getWriteStats().get()).size());
            }
            this.postCommit(hoodieTable, (HoodieCommitMetadata)result.getCommitMetadata().get(), instantTime, Option.empty());
            this.emitCommitMetrics(instantTime, (HoodieCommitMetadata)result.getCommitMetadata().get(), hoodieTable.getMetaClient().getCommitActionType());
        }
        return (List)result.getWriteStatuses();
    }

    public void commitCompaction(String compactionInstantTime, List<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata) throws IOException {
        throw new HoodieNotSupportedException("CommitCompaction is not supported in HoodieJavaClient");
    }

    protected void completeCompaction(HoodieCommitMetadata metadata, List<WriteStatus> writeStatuses, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table, String compactionCommitTime) {
        throw new HoodieNotSupportedException("CompleteCompaction is not supported in HoodieJavaClient");
    }

    protected List<WriteStatus> compact(String compactionInstantTime, boolean shouldComplete) {
        throw new HoodieNotSupportedException("Compact is not supported in HoodieJavaClient");
    }

    public HoodieWriteMetadata<List<WriteStatus>> cluster(String clusteringInstant, boolean shouldComplete) {
        throw new HoodieNotSupportedException("Cluster is not supported in HoodieJavaClient");
    }

    protected HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> getTableAndInitCtx(WriteOperationType operationType, String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        return this.getTableAndInitCtx(metaClient, operationType);
    }

    private HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> getTableAndInitCtx(HoodieTableMetaClient metaClient, WriteOperationType operationType) {
        HoodieJavaTable table;
        if (operationType == WriteOperationType.DELETE) {
            this.setWriteSchemaForDeletes(metaClient);
        }
        this.writeTimer = (table = HoodieJavaTable.create(this.config, (HoodieJavaEngineContext)this.context, metaClient)).getMetaClient().getCommitActionType().equals("commit") ? this.metrics.getCommitCtx() : this.metrics.getDeltaCommitCtx();
        return table;
    }
}

