/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieJavaCopyOnWriteTable;
import org.apache.hudi.table.HoodieJavaMergeOnReadTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class JavaRecentDaysClusteringPlanStrategy<T extends HoodieRecordPayload<T>>
extends JavaSizeBasedClusteringPlanStrategy<T> {
    private static final Logger LOG = LogManager.getLogger(JavaRecentDaysClusteringPlanStrategy.class);

    public JavaRecentDaysClusteringPlanStrategy(HoodieJavaCopyOnWriteTable<T> table, HoodieJavaEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    public JavaRecentDaysClusteringPlanStrategy(HoodieJavaMergeOnReadTable<T> table, HoodieJavaEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    protected List<String> filterPartitionPaths(List<String> partitionPaths) {
        int targetPartitionsForClustering = this.getWriteConfig().getTargetPartitionsForClustering();
        int skipPartitionsFromLatestForClustering = this.getWriteConfig().getSkipPartitionsFromLatestForClustering();
        return partitionPaths.stream().sorted(Comparator.reverseOrder()).skip(Math.max(skipPartitionsFromLatestForClustering, 0)).limit(targetPartitionsForClustering > 0 ? (long)targetPartitionsForClustering : (long)partitionPaths.size()).collect(Collectors.toList());
    }
}

